/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.CPU2IO;
import ru.ifmo.cs.bcomp.ControlSignal;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.IODevTimer;
import ru.ifmo.cs.bcomp.MicroProgram;
import ru.ifmo.cs.bcomp.SignalListener;
import ru.ifmo.cs.elements.DataDestination;

public class BasicComp {
    private final CPU cpu;
    private final IOCtrl[] ioctrls;
    private final IODevTimer timer;

    public BasicComp(MicroProgram mp) throws Exception {
        this.cpu = new CPU(mp);
        this.cpu.startCPU();
        CPU2IO cpu2io = this.cpu.getCPU2IO();
        this.ioctrls = new IOCtrl[]{new IOCtrl(0, IOCtrl.Direction.OUT, cpu2io), new IOCtrl(1, IOCtrl.Direction.OUT, cpu2io), new IOCtrl(2, IOCtrl.Direction.IN, cpu2io), new IOCtrl(3, IOCtrl.Direction.INOUT, cpu2io), new IOCtrl(4, IOCtrl.Direction.OUT, cpu2io), new IOCtrl(5, IOCtrl.Direction.OUT, cpu2io), new IOCtrl(6, IOCtrl.Direction.OUT, cpu2io), new IOCtrl(7, IOCtrl.Direction.IN, cpu2io), new IOCtrl(8, IOCtrl.Direction.IN, cpu2io), new IOCtrl(9, IOCtrl.Direction.INOUT, cpu2io)};
        this.timer = new IODevTimer(this.ioctrls[0]);
    }

    public CPU getCPU() {
        return this.cpu;
    }

    public IOCtrl[] getIOCtrls() {
        return this.ioctrls;
    }

    public void startTimer() {
        this.timer.start("IO0");
    }

    public void stopTimer() {
        this.timer.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ctrlDestination(ControlSignal cs, DataDestination dest, boolean remove) {
        this.cpu.tickLock();
        try {
            IOCtrl.ControlSignal iocs;
            int iodev;
            switch (cs) {
                case IO0_TSF: {
                    iodev = 0;
                    iocs = IOCtrl.ControlSignal.CHKFLAG;
                    break;
                }
                case IO1_TSF: {
                    iodev = 1;
                    iocs = IOCtrl.ControlSignal.CHKFLAG;
                    break;
                }
                case IO1_SETFLAG: {
                    iodev = 1;
                    iocs = IOCtrl.ControlSignal.SETFLAG;
                    break;
                }
                case IO1_OUT: {
                    iodev = 1;
                    iocs = IOCtrl.ControlSignal.OUT;
                    break;
                }
                case IO2_TSF: {
                    iodev = 2;
                    iocs = IOCtrl.ControlSignal.CHKFLAG;
                    break;
                }
                case IO2_SETFLAG: {
                    iodev = 2;
                    iocs = IOCtrl.ControlSignal.SETFLAG;
                    break;
                }
                case IO2_IN: {
                    iodev = 2;
                    iocs = IOCtrl.ControlSignal.IN;
                    break;
                }
                case IO3_TSF: {
                    iodev = 3;
                    iocs = IOCtrl.ControlSignal.CHKFLAG;
                    break;
                }
                case IO3_SETFLAG: {
                    iodev = 3;
                    iocs = IOCtrl.ControlSignal.SETFLAG;
                    break;
                }
                case IO3_IN: {
                    iodev = 3;
                    iocs = IOCtrl.ControlSignal.IN;
                    break;
                }
                case IO3_OUT: {
                    iodev = 3;
                    iocs = IOCtrl.ControlSignal.OUT;
                    break;
                }
                case IO4_TSF: {
                    iodev = 4;
                    iocs = IOCtrl.ControlSignal.CHKFLAG;
                    break;
                }
                case IO5_TSF: {
                    iodev = 5;
                    iocs = IOCtrl.ControlSignal.CHKFLAG;
                    break;
                }
                case IO6_TSF: {
                    iodev = 6;
                    iocs = IOCtrl.ControlSignal.CHKFLAG;
                    break;
                }
                case IO7_TSF: {
                    iodev = 7;
                    iocs = IOCtrl.ControlSignal.CHKFLAG;
                    break;
                }
                case IO7_IN: {
                    iodev = 7;
                    iocs = IOCtrl.ControlSignal.IN;
                    break;
                }
                case IO8_TSF: {
                    iodev = 8;
                    iocs = IOCtrl.ControlSignal.CHKFLAG;
                    break;
                }
                case IO8_IN: {
                    iodev = 8;
                    iocs = IOCtrl.ControlSignal.IN;
                    break;
                }
                case IO9_TSF: {
                    iodev = 9;
                    iocs = IOCtrl.ControlSignal.CHKFLAG;
                    break;
                }
                case IO9_IN: {
                    iodev = 9;
                    iocs = IOCtrl.ControlSignal.IN;
                    break;
                }
                default: {
                    if (remove) {
                        this.cpu.removeDestination(cs, dest);
                    } else {
                        this.cpu.addDestination(cs, dest);
                    }
                    return;
                }
            }
            if (remove) {
                this.ioctrls[iodev].removeDestination(iocs, dest);
            } else {
                this.ioctrls[iodev].addDestination(iocs, dest);
            }
        }
        finally {
            this.cpu.tickUnlock();
        }
    }

    public void addDestination(ControlSignal cs, DataDestination dest) {
        this.ctrlDestination(cs, dest, false);
    }

    public void removeDestination(ControlSignal cs, DataDestination dest) {
        this.ctrlDestination(cs, dest, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDestination(SignalListener[] listeners) {
        this.cpu.tickLock();
        try {
            for (SignalListener listener : listeners) {
                for (ControlSignal signal : listener.signals) {
                    this.addDestination(signal, listener.dest);
                }
            }
        }
        finally {
            this.cpu.tickUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestination(SignalListener[] listeners) {
        this.cpu.tickLock();
        try {
            for (SignalListener listener : listeners) {
                for (ControlSignal signal : listener.signals) {
                    this.removeDestination(signal, listener.dest);
                }
            }
        }
        finally {
            this.cpu.tickUnlock();
        }
    }
}

