/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

import java.util.EnumMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import ru.ifmo.cs.bcomp.CPU2IO;
import ru.ifmo.cs.bcomp.ControlSignal;
import ru.ifmo.cs.bcomp.ControlUnit;
import ru.ifmo.cs.bcomp.Instruction;
import ru.ifmo.cs.bcomp.MicroProgram;
import ru.ifmo.cs.bcomp.RunningCycle;
import ru.ifmo.cs.bcomp.StateReg;
import ru.ifmo.cs.elements.Bus;
import ru.ifmo.cs.elements.Consts;
import ru.ifmo.cs.elements.DataDestination;
import ru.ifmo.cs.elements.DataHandler;
import ru.ifmo.cs.elements.DataSource;
import ru.ifmo.cs.elements.Memory;
import ru.ifmo.cs.elements.Register;

public class CPU {
    private final Bus aluOutput = new Bus(16);
    private final Bus intrReq = new Bus(1);
    private final Register regState = new Register("C", "SR", 9, new DataSource[0]);
    private final ControlUnit cu = new ControlUnit(this.aluOutput);
    private final EnumMap<ControlSignal, DataHandler> valves = new EnumMap(ControlSignal.class);
    private final Register regAddr = new Register("AR", "Addr. Register", 11, this.getValve(ControlSignal.BUF_TO_ADDR, this.aluOutput));
    private final Memory mem = new Memory("Memory", 16, this.regAddr);
    private final Register regData = new Register("DR", "Data Register", 16, this.getValve(ControlSignal.BUF_TO_DATA, this.aluOutput), this.getValve(ControlSignal.MEMORY_READ, this.mem));
    private final Register regInstr = new Register("IR", "Instr. Register", 16, this.getValve(ControlSignal.BUF_TO_INSTR, this.aluOutput));
    private final Register regIP = new Register("IP", "Instr. Pointer", 11, this.getValve(ControlSignal.BUF_TO_IP, this.aluOutput));
    private final Register regAccum = new Register("Acc", "Accumulator", 16, this.getValve(ControlSignal.BUF_TO_ACCUM, this.aluOutput));
    private final Register regKey = new Register("KR", "Keyb. Register", 16, new DataSource[0]);
    private final Register regBuf;
    private final DataHandler valveRunState;
    private final DataHandler valveSetProgram;
    private final CPU2IO cpu2io;
    private volatile boolean clock = true;
    private final MicroProgram mp;
    private final ReentrantLock tick = new ReentrantLock();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition lockStart = this.lock.newCondition();
    private final Condition lockFinish = this.lock.newCondition();
    private Runnable tickStartListener = null;
    private Runnable tickFinishListener = null;
    private Runnable cpuStartListener = null;
    private Runnable cpuStopListener = null;
    private final Thread cpu = new Thread(new Runnable(){

        public void run() {
            CPU.this.lock.lock();
            try {
                try {
                    while (true) {
                        CPU.this.lockFinish.signalAll();
                        CPU.this.lockStart.await();
                        if (CPU.this.cpuStartListener != null) {
                            CPU.this.cpuStartListener.run();
                        }
                        if (CPU.this.clock) {
                            CPU.this.valveSetProgram.setValue(1);
                        }
                        do {
                            if (CPU.this.tickStartListener != null) {
                                CPU.this.tickStartListener.run();
                            }
                            CPU.this.tick.lock();
                            try {
                                CPU.this.cu.step();
                            }
                            finally {
                                CPU.this.tick.unlock();
                            }
                            if (CPU.this.tickFinishListener == null) continue;
                            CPU.this.tickFinishListener.run();
                        } while (CPU.this.regState.getValue(8) == 1);
                        if (CPU.this.cpuStopListener == null) continue;
                        CPU.this.cpuStopListener.run();
                    }
                }
                catch (InterruptedException e) {
                    CPU.this.lock.unlock();
                    return;
                }
            }
            catch (Throwable throwable) {
                CPU.this.lock.unlock();
                throw throwable;
            }
        }
    }, "BComp");

    public CPU(MicroProgram mp) throws Exception {
        this.getValve(ControlSignal.MEMORY_WRITE, this.regData).addDestination(this.mem);
        this.regState.setValue(2);
        Bus aluRight = new Bus(this.getValve(ControlSignal.DATA_TO_ALU, this.regData), this.getValve(ControlSignal.INSTR_TO_ALU, this.regInstr), this.getValve(ControlSignal.IP_TO_ALU, this.regIP));
        Bus aluLeft = new Bus(this.getValve(ControlSignal.ACCUM_TO_ALU, this.regAccum), this.getValve(ControlSignal.STATE_TO_ALU, this.regState), this.getValve(ControlSignal.KEY_TO_ALU, this.regKey));
        DataHandler notLeft = this.getValve(ControlSignal.INVERT_LEFT, aluLeft);
        DataHandler notRight = this.getValve(ControlSignal.INVERT_RIGHT, aluRight);
        DataHandler aluplus1 = this.getValve(ControlSignal.ALU_PLUS_1, Consts.consts[1]);
        this.regBuf = new Register("BR", "Buffer Register", 17, this.getValve(ControlSignal.ALU_AND, notLeft, notRight, aluplus1), this.getValve(ControlSignal.SHIFT_RIGHT, this.regAccum, this.regState), this.getValve(ControlSignal.SHIFT_LEFT, this.regAccum, this.regState));
        this.aluOutput.addInput(this.regBuf);
        StateReg regStateEI = new StateReg(this.regState, 4, this.getValve(ControlSignal.DISABLE_INTERRUPTS, Consts.consts[0]), this.getValve(ControlSignal.ENABLE_INTERRUPTS, Consts.consts[1]));
        StateReg regStateC = new StateReg(this.regState, 0, this.getValve(ControlSignal.BUF_TO_STATE_C, this.regBuf), this.getValve(ControlSignal.CLEAR_STATE_C, Consts.consts[0]), this.getValve(ControlSignal.SET_STATE_C, Consts.consts[1]));
        StateReg regStateN = new StateReg(this.regState, 2, this.getValve(ControlSignal.BUF_TO_STATE_N, this.regBuf));
        StateReg regStateZ = new StateReg(this.regState, 1, this.getValve(ControlSignal.BUF_TO_STATE_Z, this.regBuf));
        DataSource[] dataSourceArray = new DataSource[2];
        dataSourceArray[0] = this.getValve(ControlSignal.HALT, Consts.consts[0]);
        this.valveSetProgram = this.getValve(ControlSignal.SET_PROGRAM, new DataSource[0]);
        dataSourceArray[1] = this.valveSetProgram;
        StateReg regStateProg = new StateReg(this.regState, 8, dataSourceArray);
        DataHandler intrctrl = this.getValve(ControlSignal.SET_REQUEST_INTERRUPT, this.regState, this.intrReq, this.getValve(ControlSignal.DISABLE_INTERRUPTS, new DataSource[0]), this.getValve(ControlSignal.ENABLE_INTERRUPTS, new DataSource[0]));
        StateReg intrwrite = new StateReg(this.regState, 5, intrctrl);
        this.cpu2io = new CPU2IO(this.regAccum, this.regState, this.intrReq, this.getValve(ControlSignal.INPUT_OUTPUT, this.regData), this.getValve(ControlSignal.CLEAR_ALL_FLAGS, Consts.consts[1]), intrctrl);
        this.valveRunState = this.getValve(ControlSignal.SET_RUN_STATE, new DataSource[0]);
        StateReg regStateRun = new StateReg(this.regState, 7, this.valveRunState);
        this.mp = mp;
        this.cu.compileMicroProgram(this.mp);
        this.cu.jump(8);
    }

    void startCPU() throws InterruptedException {
        this.lock.lock();
        try {
            this.cpu.start();
            this.lockFinish.await();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stopCPU() {
        this.cpu.interrupt();
    }

    private DataHandler getValve(ControlSignal cs, DataSource ... inputs) {
        DataHandler valve = this.valves.get((Object)cs);
        if (valve == null) {
            valve = this.cu.createValve(cs, inputs);
            this.valves.put(cs, valve);
        }
        return valve;
    }

    public CPU2IO getCPU2IO() {
        return this.cpu2io;
    }

    public void setTickStartListener(Runnable tickStartListener) {
        this.tickStartListener = tickStartListener;
    }

    public void setTickFinishListener(Runnable tickFinishListener) {
        this.tickFinishListener = tickFinishListener;
    }

    public void setCPUStartListener(Runnable cpuStartListener) {
        this.cpuStartListener = cpuStartListener;
    }

    public void setCPUStopListener(Runnable cpuStopListener) {
        this.cpuStopListener = cpuStopListener;
    }

    void tickLock() {
        this.tick.lock();
    }

    void tickUnlock() {
        this.tick.unlock();
    }

    void addDestination(ControlSignal cs, DataDestination dest) {
        this.valves.get((Object)cs).addDestination(dest);
    }

    void removeDestination(ControlSignal cs, DataDestination dest) {
        this.valves.get((Object)cs).removeDestination(dest);
    }

    public Register getRegister(Reg reg) {
        switch (reg) {
            case ACCUM: {
                return this.regAccum;
            }
            case BUF: {
                return this.regBuf;
            }
            case DATA: {
                return this.regData;
            }
            case ADDR: {
                return this.regAddr;
            }
            case IP: {
                return this.regIP;
            }
            case INSTR: {
                return this.regInstr;
            }
            case STATE: {
                return this.regState;
            }
            case KEY: {
                return this.regKey;
            }
            case MIP: {
                return this.cu.getIP();
            }
            case MINSTR: {
                return this.cu.getInstr();
            }
        }
        return null;
    }

    public Reg findRegister(String reg) {
        if (this.regAccum.name.equals(reg)) {
            return Reg.ACCUM;
        }
        if (this.regBuf.name.equals(reg)) {
            return Reg.BUF;
        }
        if (this.regData.name.equals(reg)) {
            return Reg.DATA;
        }
        if (this.regAddr.name.equals(reg)) {
            return Reg.ADDR;
        }
        if (this.regIP.name.equals(reg)) {
            return Reg.IP;
        }
        if (this.regInstr.name.equals(reg)) {
            return Reg.INSTR;
        }
        if (this.regState.name.equals(reg)) {
            return Reg.STATE;
        }
        if (this.regKey.name.equals(reg)) {
            return Reg.KEY;
        }
        if (this.cu.getIP().name.equals(reg)) {
            return Reg.MIP;
        }
        if (this.cu.getInstr().name.equals(reg)) {
            return Reg.MINSTR;
        }
        return null;
    }

    public int getRegValue(Reg reg) {
        return this.getRegister(reg).getValue();
    }

    public int getRegWidth(Reg reg) {
        return this.getRegister(reg).getWidth();
    }

    public int getStateValue(int startbit) {
        return this.regState.getValue(startbit);
    }

    public boolean isRunning() {
        return this.lock.isLocked();
    }

    public Memory getMemory() {
        return this.mem;
    }

    public int getMemoryValue(int addr) {
        return this.mem.getValue(addr);
    }

    public Memory getMicroMemory() {
        return this.cu.getMemory();
    }

    public int getMicroMemoryValue(int addr) {
        return this.cu.getMemoryValue(addr);
    }

    public void setRegKey(int value) {
        this.regKey.setValue(value);
    }

    public void setRunState(boolean state) {
        this.tick.lock();
        try {
            this.valveRunState.setValue(state ? 1 : 0);
        }
        finally {
            this.tick.unlock();
        }
    }

    public void invertRunState() {
        this.tick.lock();
        try {
            this.valveRunState.setValue(~this.regState.getValue(7));
        }
        finally {
            this.tick.unlock();
        }
    }

    public boolean getClockState() {
        return this.clock;
    }

    public void setClockState(boolean clock) {
        this.tick.lock();
        try {
            this.clock = clock;
            if (!clock) {
                this.valveSetProgram.setValue(0);
            }
        }
        finally {
            this.tick.unlock();
        }
    }

    public boolean invertClockState() {
        this.setClockState(!this.clock);
        return this.clock;
    }

    private void jump(int label) {
        if (label != -1) {
            this.cu.jump(label);
        }
    }

    private boolean startFrom(int label) {
        if (this.lock.tryLock()) {
            try {
                this.jump(label);
                this.lockStart.signal();
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
        return false;
    }

    public boolean startSetAddr() {
        return this.startFrom(4);
    }

    public boolean startWrite() {
        return this.startFrom(6);
    }

    public boolean startRead() {
        return this.startFrom(5);
    }

    public boolean startStart() {
        return this.startFrom(7);
    }

    public boolean startContinue() {
        return this.startFrom(-1);
    }

    private boolean runFrom(int label) {
        if (this.lock.tryLock()) {
            try {
                this.jump(label);
                this.lockStart.signal();
                this.lockFinish.await();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
        return false;
    }

    public boolean runSetAddr() {
        return this.runFrom(4);
    }

    public boolean runSetAddr(int addr) {
        this.setRegKey(addr);
        return this.runSetAddr();
    }

    public boolean runWrite() {
        return this.runFrom(6);
    }

    public boolean runWrite(int value) {
        this.setRegKey(value);
        return this.runWrite();
    }

    public boolean runRead() {
        return this.runFrom(5);
    }

    public boolean runStart() {
        return this.runFrom(7);
    }

    public boolean runContinue() {
        return this.runFrom(-1);
    }

    public boolean runSetMAddr() {
        if (this.lock.tryLock()) {
            try {
                this.cu.setIP(this.regKey.getValue());
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
        return false;
    }

    public boolean runMWrite() {
        if (this.lock.tryLock()) {
            try {
                this.cu.setMemory(this.regKey.getValue());
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
        return false;
    }

    public boolean runMRead() {
        if (this.lock.tryLock()) {
            try {
                this.cu.readInstr();
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
        return false;
    }

    public MicroProgram getMicroProgram() {
        return this.mp;
    }

    public String getMicroProgramName() {
        return this.mp.microprogramName;
    }

    public int getIntrCycleStartAddr() {
        return this.cu.getIntrCycleStartAddr();
    }

    public Instruction[] getInstructionSet() {
        return this.mp.instructionSet;
    }

    public RunningCycle getRunningCycle() {
        return this.cu.getCycle();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.stopCPU();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reg {
        ACCUM,
        BUF,
        DATA,
        ADDR,
        IP,
        INSTR,
        STATE,
        KEY,
        MIP,
        MINSTR;

    }
}

