/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

import java.util.EnumMap;
import ru.ifmo.cs.bcomp.ControlSignal;
import ru.ifmo.cs.bcomp.MicroIP;
import ru.ifmo.cs.bcomp.MicroProgram;
import ru.ifmo.cs.bcomp.RunningCycle;
import ru.ifmo.cs.elements.Bus;
import ru.ifmo.cs.elements.Comparer;
import ru.ifmo.cs.elements.Consts;
import ru.ifmo.cs.elements.DataAdder;
import ru.ifmo.cs.elements.DataAnd;
import ru.ifmo.cs.elements.DataCheckZero;
import ru.ifmo.cs.elements.DataDecoder;
import ru.ifmo.cs.elements.DataHandler;
import ru.ifmo.cs.elements.DataInverter;
import ru.ifmo.cs.elements.DataPart;
import ru.ifmo.cs.elements.DataRotateLeft;
import ru.ifmo.cs.elements.DataRotateRight;
import ru.ifmo.cs.elements.DataSource;
import ru.ifmo.cs.elements.DataStorage;
import ru.ifmo.cs.elements.DummyValve;
import ru.ifmo.cs.elements.ForcedValve;
import ru.ifmo.cs.elements.Inverter;
import ru.ifmo.cs.elements.Memory;
import ru.ifmo.cs.elements.Register;
import ru.ifmo.cs.elements.Valve;
import ru.ifmo.cs.elements.ValveOnce;

public class ControlUnit {
    private final MicroIP ip = new MicroIP("MC", "MC Counter", 8);
    private final Memory mem = new Memory("MC Memory", 16, this.ip);
    private final Valve clock = new Valve((DataSource)this.mem, new DataSource[0]);
    private final Register instr = new Register("MR", "MicroCommand register", 16, this.clock);
    private final EnumMap<Decoders, DataHandler> decoders = new EnumMap(Decoders.class);
    private final DataHandler vr00;
    private final DataHandler vr01;
    private final DataHandler valve4ctrlcmd;
    private static final String[] labels = new String[]{"ADDRGET", "EXEC", "INTR", "EXECCNT", "ADDR", "READ", "WRITE", "START", "STP"};
    private final int[] labelsaddr = new int[labels.length];
    static final int NO_LABEL = -1;
    private static final int LABEL_CYCLE_ADDR = 0;
    private static final int LABEL_CYCLE_EXEC = 1;
    private static final int LABEL_CYCLE_INTR = 2;
    private static final int LABEL_CYCLE_EXECCNT = 3;
    static final int LABEL_ADDR = 4;
    static final int LABEL_READ = 5;
    static final int LABEL_WRITE = 6;
    static final int LABEL_START = 7;
    static final int LABEL_STP = 8;

    public ControlUnit(Bus aluOutput) {
        Valve vr0 = new Valve((DataSource)this.clock, new Inverter(15, this.clock));
        this.vr00 = new Valve((DataSource)vr0, new Inverter(14, vr0));
        this.decoders.put(Decoders.LEFT_INPUT, new DataDecoder(this.vr00, 12, 2));
        this.decoders.put(Decoders.RIGHT_INPUT, new DataDecoder(this.vr00, 8, 2));
        this.vr01 = new Valve((DataSource)vr0, 14, vr0);
        this.decoders.put(Decoders.FLAG_C, new DataDecoder(this.vr01, 6, 2));
        this.decoders.put(Decoders.BR_TO, new DataDecoder(this.vr01, 0, 3));
        Valve vr1 = new Valve((DataSource)this.clock, 15, this.clock);
        this.decoders.put(Decoders.CONTROL_CMD_REG, new DataDecoder(vr1, 12, 2));
        this.valve4ctrlcmd = new DummyValve(Consts.consts[0], vr1);
        DataDecoder bitselector = new DataDecoder(vr1, 8, 4);
        DataSource[] bits = new Valve[16];
        for (int i = 0; i < 16; ++i) {
            bits[i] = new Valve((DataSource)aluOutput, i, 1, i, bitselector);
        }
        ForcedValve writeMIP = new ForcedValve(vr1, 8, new Comparer(vr1, 14, bits), new DummyValve(Consts.consts[0], vr0));
        writeMIP.addDestination(this.ip);
    }

    public DataHandler createValve(ControlSignal cs, DataSource ... inputs) {
        switch (cs) {
            case HALT: {
                return new Valve("\u04120", inputs[0], 3, this.vr01);
            }
            case DATA_TO_ALU: {
                return new ValveOnce("\u04121", inputs[0], 1, this.decoders.get((Object)Decoders.RIGHT_INPUT), this.decoders.get((Object)Decoders.CONTROL_CMD_REG));
            }
            case INSTR_TO_ALU: {
                return new ValveOnce("\u04122", inputs[0], 2, this.decoders.get((Object)Decoders.RIGHT_INPUT), this.decoders.get((Object)Decoders.CONTROL_CMD_REG));
            }
            case IP_TO_ALU: {
                return new ValveOnce("\u04123", inputs[0], 3, this.decoders.get((Object)Decoders.RIGHT_INPUT));
            }
            case ACCUM_TO_ALU: {
                return new ValveOnce("\u04124", inputs[0], new DataPart(1, this.decoders.get((Object)Decoders.LEFT_INPUT)), new DataPart(3, this.decoders.get((Object)Decoders.CONTROL_CMD_REG)));
            }
            case STATE_TO_ALU: {
                return new ValveOnce("\u04125", inputs[0], new DataPart(2, this.decoders.get((Object)Decoders.LEFT_INPUT)), new DataPart(0, this.decoders.get((Object)Decoders.CONTROL_CMD_REG)));
            }
            case KEY_TO_ALU: {
                return new ValveOnce("\u04126", inputs[0], 3, this.decoders.get((Object)Decoders.LEFT_INPUT));
            }
            case INVERT_LEFT: {
                return new DataInverter("\u04127", inputs[0], new DataPart(6, this.vr00), this.valve4ctrlcmd);
            }
            case INVERT_RIGHT: {
                return new DataInverter("\u04128", inputs[0], new DataPart(7, this.vr00), this.valve4ctrlcmd);
            }
            case ALU_AND: {
                return new DataAdder("\u04129", inputs[0], inputs[1], inputs[2], new DataPart(5, this.vr00), this.valve4ctrlcmd);
            }
            case ALU_PLUS_1: {
                return new ValveOnce("\u041210", inputs[0], 4, this.vr00);
            }
            case SHIFT_RIGHT: {
                return new DataRotateRight("\u041211", inputs[0], inputs[1], 2, this.vr00);
            }
            case SHIFT_LEFT: {
                return new DataRotateLeft("\u041212", inputs[0], inputs[1], 3, this.vr00);
            }
            case BUF_TO_STATE_C: {
                return new Valve("\u041213", inputs[0], 16, 1, 1, this.decoders.get((Object)Decoders.FLAG_C));
            }
            case BUF_TO_STATE_N: {
                return new Valve("\u041214", inputs[0], 15, 1, 5, this.vr01);
            }
            case BUF_TO_STATE_Z: {
                return new DataCheckZero("\u041215", inputs[0], 16, 4, this.vr01);
            }
            case CLEAR_STATE_C: {
                return new Valve("\u041216", inputs[0], 2, this.decoders.get((Object)Decoders.FLAG_C));
            }
            case SET_STATE_C: {
                return new Valve("\u041217", inputs[0], 3, this.decoders.get((Object)Decoders.FLAG_C));
            }
            case BUF_TO_ADDR: {
                return new Valve("\u041218", inputs[0], 1, this.decoders.get((Object)Decoders.BR_TO));
            }
            case BUF_TO_DATA: {
                return new Valve("\u041219", inputs[0], 2, this.decoders.get((Object)Decoders.BR_TO));
            }
            case BUF_TO_INSTR: {
                return new Valve("\u041220", inputs[0], 3, this.decoders.get((Object)Decoders.BR_TO));
            }
            case BUF_TO_IP: {
                return new Valve("\u041221", inputs[0], 4, this.decoders.get((Object)Decoders.BR_TO));
            }
            case BUF_TO_ACCUM: {
                return new Valve("\u041222", inputs[0], 5, this.decoders.get((Object)Decoders.BR_TO));
            }
            case MEMORY_READ: {
                return new Valve("\u041223", inputs[0], 0, this.vr00);
            }
            case MEMORY_WRITE: {
                return new Valve("\u041224", inputs[0], 1, this.vr00);
            }
            case INPUT_OUTPUT: {
                return new Valve("\u041225", inputs[0], 8, this.vr01);
            }
            case CLEAR_ALL_FLAGS: {
                return new Valve("\u041226", inputs[0], 9, this.vr01);
            }
            case DISABLE_INTERRUPTS: {
                return new Valve("\u041227", inputs[0], 10, this.vr01);
            }
            case ENABLE_INTERRUPTS: {
                return new Valve("\u041228", inputs[0], 11, this.vr01);
            }
            case SET_RUN_STATE: {
                return new DataPart(0, new DataStorage[0]);
            }
            case SET_PROGRAM: {
                return new DataPart(0, new DataStorage[0]);
            }
            case SET_REQUEST_INTERRUPT: {
                return new DataAnd(inputs[0], 4, inputs[1], inputs[2], inputs[3]);
            }
        }
        return null;
    }

    private int getLabelAddr(String[][] mp, String label) {
        for (int i = 0; i < mp.length; ++i) {
            if (mp[i][0] == null || !mp[i][0].equals(label)) continue;
            return i;
        }
        return -1;
    }

    public void compileMicroProgram(MicroProgram mpsrc) throws Exception {
        String[][] mp = mpsrc.microprogram;
        int i = 0;
        while (i < this.labelsaddr.length) {
            this.labelsaddr[i++] = 0;
        }
        for (i = 0; i < mp.length; ++i) {
            int cmd = Integer.parseInt(mp[i][1], 16);
            if (mp[i][0] != null) {
                for (int j = 0; j < labels.length; ++j) {
                    if (!mp[i][0].equals(labels[j])) continue;
                    this.labelsaddr[j] = i;
                }
            }
            if (mp[i][2] != null) {
                int label = this.getLabelAddr(mp, mp[i][2]);
                if (label < 0) {
                    throw new Exception("Label " + mp[i][2] + " not found!");
                }
                cmd += label;
            }
            this.mem.setValue(i, cmd);
        }
        for (i = 0; i < labels.length; ++i) {
            if (this.labelsaddr[i] != 0) continue;
            throw new Exception("Required label '" + labels[i] + "' not found");
        }
    }

    public Register getIP() {
        return this.ip;
    }

    public int getIPValue() {
        return this.ip.getValue();
    }

    public void setIP(int value) {
        this.ip.setValue(value);
    }

    public void jump(int label) {
        this.ip.setValue(this.labelsaddr[label]);
    }

    public Register getInstr() {
        return this.instr;
    }

    public int getInstrValue() {
        return this.instr.getValue();
    }

    public void readInstr() {
        this.instr.setValue(this.mem.getValue());
        this.setIP(0);
    }

    public Memory getMemory() {
        return this.mem;
    }

    public int getMemoryValue(int addr) {
        return this.mem.getValue(addr);
    }

    public void setMemory(int value) {
        this.mem.setValue(value);
        this.ip.setValue(0);
    }

    public void step() {
        this.clock.setValue(1);
    }

    public RunningCycle getCycle() {
        int ipvalue = this.ip.getValue();
        if (ipvalue < this.labelsaddr[0]) {
            return RunningCycle.INSTR_FETCH;
        }
        if (ipvalue < this.labelsaddr[1]) {
            return RunningCycle.ADDR_FETCH;
        }
        if (ipvalue < this.labelsaddr[2]) {
            return ipvalue == this.labelsaddr[8] ? RunningCycle.NONE : RunningCycle.EXECUTION;
        }
        if (ipvalue < this.labelsaddr[4]) {
            return RunningCycle.INTERRUPT;
        }
        if (ipvalue < this.labelsaddr[3]) {
            return RunningCycle.PANEL;
        }
        return RunningCycle.EXECUTION;
    }

    public int getIntrCycleStartAddr() {
        return this.labelsaddr[2];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Decoders {
        LEFT_INPUT,
        RIGHT_INPUT,
        FLAG_C,
        BR_TO,
        CONTROL_CMD_REG;

    }
}

