/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui.components;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.ControlSignal;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.SignalListener;
import ru.ifmo.cs.bcomp.ui.GUI;
import ru.ifmo.cs.bcomp.ui.components.BCompLabel;
import ru.ifmo.cs.bcomp.ui.components.BCompPanel;
import ru.ifmo.cs.bcomp.ui.components.BusView;
import ru.ifmo.cs.bcomp.ui.components.DisplayStyles;
import ru.ifmo.cs.bcomp.ui.components.InputRegisterView;
import ru.ifmo.cs.bcomp.ui.components.RegisterProperties;
import ru.ifmo.cs.bcomp.ui.components.RegisterView;
import ru.ifmo.cs.bcomp.ui.io.BComp2BCompIODev;
import ru.ifmo.cs.bcomp.ui.io.Keyboard;
import ru.ifmo.cs.bcomp.ui.io.Numpad;
import ru.ifmo.cs.bcomp.ui.io.SevenSegmentDisplay;
import ru.ifmo.cs.bcomp.ui.io.TextPrinter;
import ru.ifmo.cs.bcomp.ui.io.Ticker;
import ru.ifmo.cs.elements.DataDestination;

public class IOView
extends BCompPanel {
    private final IOCtrl[] ioctrls;
    private TextPrinter textPrinter = null;
    private Ticker ticker = null;
    private SevenSegmentDisplay ssd = null;
    private Keyboard kbd = null;
    private Numpad numpad = null;
    private GUI pairgui = null;
    private final RegisterView[] ioregs = new RegisterView[3];
    private final JButton[] flags = new JButton[]{new JButton("F1 ED1"), new JButton("F2 ED2"), new JButton("F3 ED3")};
    private final BusView[] intrBuses = new BusView[]{new BusView(new int[][]{{DisplayStyles.IO1_CENTER, 46}, {DisplayStyles.IO1_CENTER, 30}, {DisplayStyles.BUS_INTR_LEFT_X, 30}}, new ControlSignal[0]), new BusView(new int[][]{{DisplayStyles.IO2_CENTER, 46}, {DisplayStyles.IO2_CENTER, 30}, {DisplayStyles.BUS_INTR_LEFT_X, 30}}, new ControlSignal[0]), new BusView(new int[][]{{DisplayStyles.IO3_CENTER, 46}, {DisplayStyles.IO3_CENTER, 30}, {DisplayStyles.BUS_INTR_LEFT_X, 30}}, new ControlSignal[0])};

    public IOView(final GUI gui, GUI _pairgui) {
        super(gui.getComponentManager(), new RegisterProperties[]{new RegisterProperties(CPU.Reg.ADDR, DisplayStyles.CU_X_IO, 86, true), new RegisterProperties(CPU.Reg.IP, DisplayStyles.CU_X_IO, 155, true), new RegisterProperties(CPU.Reg.DATA, DisplayStyles.CU_X_IO, 224, true), new RegisterProperties(CPU.Reg.INSTR, DisplayStyles.CU_X_IO, 293, true), new RegisterProperties(CPU.Reg.ACCUM, DisplayStyles.REG_ACC_X_IO, 362, true), new RegisterProperties(CPU.Reg.STATE, DisplayStyles.CU_X_IO, 362, false)}, new BusView[]{new BusView(new int[][]{{DisplayStyles.IO1_CENTER, 80}, {DisplayStyles.IO1_CENTER, 96}, {DisplayStyles.BUS_TSF_X, 96}, {DisplayStyles.BUS_TSF_X, 82}}, ControlSignal.IO1_TSF), new BusView(new int[][]{{DisplayStyles.IO2_CENTER, 80}, {DisplayStyles.IO2_CENTER, 96}, {DisplayStyles.BUS_TSF_X, 96}, {DisplayStyles.BUS_TSF_X, 82}}, ControlSignal.IO2_TSF), new BusView(new int[][]{{DisplayStyles.IO3_CENTER, 80}, {DisplayStyles.IO3_CENTER, 96}, {DisplayStyles.BUS_TSF_X, 96}, {DisplayStyles.BUS_TSF_X, 82}}, ControlSignal.IO3_TSF), new BusView(new int[][]{{DisplayStyles.IO1_CENTER, 145}, {DisplayStyles.IO1_CENTER, 152}}, ControlSignal.INPUT_OUTPUT), new BusView(new int[][]{{DisplayStyles.IO2_CENTER, 145}, {DisplayStyles.IO2_CENTER, 152}}, ControlSignal.INPUT_OUTPUT), new BusView(new int[][]{{DisplayStyles.BUS_IO_ADDR_X, 237}, {DisplayStyles.BUS_TSF_X, 237}, {DisplayStyles.BUS_TSF_X, 145}, {DisplayStyles.IO3_CENTER, 145}, {DisplayStyles.IO3_CENTER, 152}}, ControlSignal.INPUT_OUTPUT), new BusView(new int[][]{{DisplayStyles.IO1_CENTER, 263}, {DisplayStyles.IO1_CENTER, 256}}, ControlSignal.INPUT_OUTPUT), new BusView(new int[][]{{DisplayStyles.IO2_CENTER, 263}, {DisplayStyles.IO2_CENTER, 256}}, ControlSignal.INPUT_OUTPUT), new BusView(new int[][]{{DisplayStyles.BUS_IO_ADDR_X, 263}, {DisplayStyles.IO3_CENTER, 263}, {DisplayStyles.IO3_CENTER, 256}}, ControlSignal.INPUT_OUTPUT), new BusView(new int[][]{{DisplayStyles.IO2_CENTER, 323}, {DisplayStyles.IO2_CENTER, 308}, {DisplayStyles.BUS_TSF_X, 308}, {DisplayStyles.BUS_TSF_X, 375}, {DisplayStyles.BUS_IN_X, 375}}, ControlSignal.IO2_IN), new BusView(new int[][]{{DisplayStyles.IO3_CENTER, 323}, {DisplayStyles.IO3_CENTER, 308}, {DisplayStyles.BUS_TSF_X, 308}, {DisplayStyles.BUS_TSF_X, 375}, {DisplayStyles.BUS_IN_X, 375}}, ControlSignal.IO3_IN), new BusView(new int[][]{{DisplayStyles.BUS_OUT_X, 401}, {DisplayStyles.IO1_CENTER, 401}, {DisplayStyles.IO1_CENTER, 394}}, ControlSignal.IO1_OUT), new BusView(new int[][]{{DisplayStyles.BUS_OUT_X, 401}, {DisplayStyles.IO3_CENTER, 401}, {DisplayStyles.IO3_CENTER, 394}}, ControlSignal.IO3_OUT)});
        this.pairgui = _pairgui;
        this.ioctrls = gui.getIOCtrls();
        JButton button = new JButton("ED4");
        button.setFont(DisplayStyles.FONT_COURIER_PLAIN_12);
        button.setBounds(DisplayStyles.IO1_CENTER, 445, 100, 25);
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (IOView.this.textPrinter == null) {
                    IOView.this.textPrinter = new TextPrinter(IOView.this.ioctrls[4]);
                }
                IOView.this.textPrinter.activate();
            }
        });
        this.add(button);
        button = new JButton("ED5");
        button.setFont(DisplayStyles.FONT_COURIER_PLAIN_12);
        button.setBounds(DisplayStyles.IO2_CENTER, 445, 100, 25);
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (IOView.this.ticker == null) {
                    IOView.this.ticker = new Ticker(IOView.this.ioctrls[5]);
                }
                IOView.this.ticker.activate();
            }
        });
        this.add(button);
        button = new JButton("ED6");
        button.setFont(DisplayStyles.FONT_COURIER_PLAIN_12);
        button.setBounds(DisplayStyles.IO3_CENTER - 30, 445, 100, 25);
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (IOView.this.ssd == null) {
                    IOView.this.ssd = new SevenSegmentDisplay(IOView.this.ioctrls[6]);
                }
                IOView.this.ssd.activate();
            }
        });
        this.add(button);
        button = new JButton("ED7");
        button.setFont(DisplayStyles.FONT_COURIER_PLAIN_12);
        button.setBounds(DisplayStyles.IO1_CENTER, 475, 100, 25);
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (IOView.this.kbd == null) {
                    IOView.this.kbd = new Keyboard(IOView.this.ioctrls[7]);
                }
                IOView.this.kbd.activate();
            }
        });
        this.add(button);
        button = new JButton("ED8");
        button.setFont(DisplayStyles.FONT_COURIER_PLAIN_12);
        button.setBounds(DisplayStyles.IO2_CENTER, 475, 100, 25);
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (IOView.this.numpad == null) {
                    IOView.this.numpad = new Numpad(IOView.this.ioctrls[8]);
                }
                IOView.this.numpad.activate();
            }
        });
        this.add(button);
        button = new JButton("ED9");
        button.setFont(DisplayStyles.FONT_COURIER_PLAIN_12);
        button.setBounds(DisplayStyles.IO3_CENTER - 30, 475, 100, 25);
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (IOView.this.pairgui == null) {
                    try {
                        IOView.this.pairgui = new GUI(gui);
                        IOView.this.pairgui.gui();
                        BComp2BCompIODev bComp2BCompIODev = new BComp2BCompIODev(gui.getBasicComp().getIOCtrls()[9], IOView.this.pairgui.getBasicComp().getIOCtrls()[9]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                gui.requestFocus();
            }
        });
        this.add(button);
        for (int i = 0; i < this.ioregs.length; ++i) {
            int x = DisplayStyles.IO_X + i * DisplayStyles.IO_DELIM;
            this.ioregs[i] = i == 0 ? new RegisterView(this.ioctrls[i + 1].getRegData()) : new InputRegisterView(this.cmanager, this.ioctrls[i + 1].getRegData());
            this.ioregs[i].setProperties(x, 328, false);
            this.add(this.ioregs[i]);
            this.flags[i].setFont(DisplayStyles.FONT_COURIER_PLAIN_12);
            this.flags[i].setBounds(x + DisplayStyles.FLAG_OFFSET, 51, 100, 25);
            this.flags[i].setFocusable(false);
            this.add(this.flags[i]);
            this.flags[i].addActionListener(new FlagButtonListener(this.ioctrls[i + 1]));
            this.ioctrls[i + 1].addDestination(IOCtrl.ControlSignal.SETFLAG, new FlagListener(this.flags[i]));
            this.add(new BCompLabel(x, 166, DisplayStyles.REG_8_WIDTH, "Address", "& commands", "decoder"));
        }
        this.add(new BCompLabel(DisplayStyles.CU_X_IO, 17, DisplayStyles.REG_8_WIDTH, "Control", "unit"));
        this.addLabel("Interruption request", 6);
        this.addLabel("ED flag state", 104);
        this.addLabel("ED address", 124);
        this.addLabel("I/O command", 271);
        this.addLabel("Input bus", 287);
        this.addLabel("Output bus", 409);
        DataDestination intrListener = new DataDestination(){

            public void setValue(int value) {
                IOView.this.drawIntrBuses(IOView.this.getGraphics());
            }
        };
        this.setSignalListeners(new SignalListener[]{new SignalListener(this.ioregs[0], ControlSignal.IO1_OUT), new SignalListener(this.ioregs[2], ControlSignal.IO3_OUT), new SignalListener(intrListener, ControlSignal.IO1_SETFLAG), new SignalListener(intrListener, ControlSignal.IO2_SETFLAG), new SignalListener(intrListener, ControlSignal.IO3_SETFLAG)});
    }

    private void addLabel(String text, int y) {
        JLabel l = new JLabel(text, 0);
        l.setFont(DisplayStyles.FONT_COURIER_BOLD_18);
        l.setBounds(DisplayStyles.IO1_CENTER, y, DisplayStyles.IO3_CENTER - DisplayStyles.IO1_CENTER, 16);
        this.add(l);
    }

    private void drawIntrBuses(Graphics g) {
        int i;
        for (i = 0; i < 3; ++i) {
            if (this.ioctrls[i + 1].getFlag() != 0) continue;
            this.intrBuses[i].draw(g, DisplayStyles.COLOR_BUS);
        }
        for (i = 0; i < 3; ++i) {
            if (this.ioctrls[i + 1].getFlag() != 1) continue;
            this.intrBuses[i].draw(g, DisplayStyles.COLOR_ACTIVE);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawIntrBuses(g);
    }

    public String getPanelName() {
        return "Work with ED";
    }

    public void stepFinish() {
        super.stepFinish();
        for (ControlSignal signal : this.cmanager.getActiveSignals()) {
            switch (signal) {
                case IO1_OUT: {
                    this.ioregs[0].setValue();
                    break;
                }
                case IO3_OUT: {
                    this.ioregs[2].setValue();
                }
            }
        }
    }

    private class FlagListener
    implements DataDestination {
        private final JButton flag;

        public FlagListener(JButton flag) {
            this.flag = flag;
        }

        public void setValue(int value) {
            this.flag.setForeground(value == 1 ? DisplayStyles.COLOR_ACTIVE : DisplayStyles.COLOR_TEXT);
        }
    }

    private class FlagButtonListener
    implements ActionListener {
        private final IOCtrl ioctrl;

        public FlagButtonListener(IOCtrl ioctrl) {
            this.ioctrl = ioctrl;
        }

        public void actionPerformed(ActionEvent e) {
            this.ioctrl.setFlag();
        }
    }
}

