/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

import java.util.ArrayList;
import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.Instruction;
import ru.ifmo.cs.bcomp.Utils;

public class Assembler {
    private ArrayList<Label> labels;
    private ArrayList<Command> cmds;
    private Instruction[] instrset;

    public Assembler(Instruction[] instrset) {
        this.instrset = instrset;
    }

    public void compileProgram(String program) throws Exception {
        String[] prog = program.replace("\r", "").toUpperCase().split("\n");
        int addr = 0;
        int lineno = 0;
        this.labels = new ArrayList();
        this.cmds = new ArrayList();
        try {
            block7: for (String l : prog) {
                ++lineno;
                String[] line = l.trim().split("[#;]+");
                if (line.length == 0 || line[0].equals("") || (line = line[0].trim().split("[ \t]+")).length == 0 || line[0].equals("")) continue;
                if (line[0].equals("ORG")) {
                    if (line.length != 2) {
                        throw new Exception("\u0414\u0438\u0440\u0435\u043a\u0442\u0438\u0432\u0430 ORG \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u043e\u0434\u0438\u043d \u0438 \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0434\u0438\u043d \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442");
                    }
                    addr = Integer.parseInt(line[1], 16);
                    this.checkAddr(addr);
                    continue;
                }
                int col = 0;
                if (line[col].charAt(line[col].length() - 1) == ':') {
                    String labelname = line[col].substring(0, line[col].length() - 1);
                    Label label = this.getLabel(labelname);
                    if (label.hasAddress()) {
                        throw new Exception("\u041c\u0435\u0442\u043a\u0430 " + labelname + " \u043e\u0431\u044a\u044f\u0432\u043b\u0435\u043d\u0430 \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e");
                    }
                    label.setAddr(addr);
                    ++col;
                }
                if (col == line.length) continue;
                if (line[col].equals("WORD")) {
                    String[] values;
                    if (col++ == line.length - 1) {
                        throw new Exception("\u0414\u0438\u0440\u0435\u043a\u0442\u0438\u0432\u0430 WORD \u0434\u043e\u043b\u0436\u043d\u0430 \u0438\u043c\u0435\u0442\u044c \u043a\u0430\u043a \u043c\u0438\u043d\u0438\u043c\u0443\u043c \u043e\u0434\u0438\u043d \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442");
                    }
                    if (line.length - col == 3 && line[col + 1].equals("DUP")) {
                        int size = Integer.parseInt(line[col], 16);
                        if (size < 1 || addr + size > 2047) {
                            throw new Exception("\u0423\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439");
                        }
                        if (line[col += 2].charAt(0) != '(' || line[col].charAt(line[col].length() - 1) != ')') {
                            throw new Exception("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u043b\u0435 DUP \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0432 \u0441\u043a\u043e\u0431\u043a\u0430\u0445");
                        }
                        String value = line[col].substring(1, line[col].length() - 1);
                        this.createWord(addr, value, size);
                        addr += size;
                        continue;
                    }
                    String v = line[col++];
                    while (col < line.length) {
                        v = v.concat(" ").concat(line[col++]);
                    }
                    for (String value : values = v.split(",")) {
                        this.createWord(addr++, value.trim(), 1);
                    }
                    continue;
                }
                Instruction instr = this.findInstruction(line[col]);
                if (instr == null) {
                    throw new Exception("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430 " + line[col]);
                }
                switch (instr.getType()) {
                    case ADDR: {
                        int addrtype;
                        if (col != line.length - 2) {
                            throw new Exception("\u0410\u0434\u0440\u0435\u0441\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430 " + line[col] + " \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u043e\u0434\u0438\u043d \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442");
                        }
                        String labelname = line[col + 1];
                        if (labelname.charAt(0) == '(') {
                            if (labelname.charAt(labelname.length() - 1) != ')') {
                                throw new Exception("\u041d\u0435\u0442 \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u044e\u0449\u0435\u0439 \u0441\u043a\u043e\u0431\u043a\u0438");
                            }
                            labelname = labelname.substring(1, labelname.length() - 1);
                            addrtype = 2048;
                        } else {
                            addrtype = 0;
                        }
                        if (Utils.isHexNumeric(labelname)) {
                            this.cmds.add(new Command(addr++, instr.getInstr() + addrtype + Integer.parseInt(labelname, 16)));
                            continue block7;
                        }
                        this.cmds.add(new Command(addr++, instr.getInstr() + addrtype, this.getLabel(labelname)));
                        continue block7;
                    }
                    case NONADDR: {
                        if (col != line.length - 1) {
                            throw new Exception("\u0411\u0435\u0437\u0430\u0434\u0440\u0435\u0441\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430 " + line[col] + " \u043d\u0435 \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
                        }
                        this.cmds.add(new Command(addr++, instr.getInstr()));
                        continue block7;
                    }
                    case IO: {
                        if (col != line.length - 2) {
                            throw new Exception("\u0421\u0442\u0440\u043e\u043a\u0430 " + lineno + ": \u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0432\u0432\u043e\u0434\u0430-\u0432\u044b\u0432\u043e\u0434\u0430 " + line[col] + " \u0442\u0440\u0435\u0431\u0443\u0435\u0442 \u043e\u0434\u0438\u043d \u0438 \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0434\u0438\u043d \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442");
                        }
                        this.cmds.add(new Command(addr++, instr.getInstr() + (Integer.parseInt(line[col + 1], 16) & 0xFF)));
                    }
                }
            }
            for (Label label : this.labels) {
                if (label.hasAddress()) continue;
                throw new Exception("\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u043d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u0443\u044e \u043c\u0435\u0442\u043a\u0443 " + label.label);
            }
        }
        catch (Exception e) {
            throw new Exception("\u0421\u0442\u0440\u043e\u043a\u0430 " + lineno + ": " + e.getMessage());
        }
    }

    private Label findLabel(String labelname) {
        for (Label label : this.labels) {
            if (!label.label.equals(labelname)) continue;
            return label;
        }
        return null;
    }

    private Label getLabel(String labelname) throws Exception {
        Label label = this.findLabel(labelname);
        if (label == null) {
            label = new Label(labelname);
            this.labels.add(label);
        }
        return label;
    }

    private void createWord(int addr, String value, int size) throws Exception {
        if (value.equals("")) {
            throw new Exception("\u041f\u0443\u0441\u0442\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
        }
        if (value.equals("?")) {
            return;
        }
        int cmd = 0;
        Label arg = null;
        if (Utils.isHexNumeric(value)) {
            cmd = Integer.parseInt(value, 16);
        } else {
            arg = this.getLabel(value);
        }
        this.cmds.add(new Command(addr, cmd, arg, size));
    }

    private void checkAddr(int addr) throws Exception {
        if (addr < 0 || addr > 2047) {
            throw new Exception("\u0410\u0434\u0440\u0435\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0445 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439");
        }
    }

    public Instruction findInstruction(String mnemonics) {
        for (Instruction instr : this.instrset) {
            if (!instr.getMnemonics().equals(mnemonics)) continue;
            return instr;
        }
        return null;
    }

    public void loadProgram(CPU cpu) throws Exception {
        if (cpu.isRunning()) {
            throw new Exception("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430: \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430");
        }
        for (Command cmd : this.cmds) {
            if (!cpu.runSetAddr(cmd.addr)) {
                throw new Exception("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u0430: \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430");
            }
            for (int i = 0; i < cmd.size; ++i) {
                if (cpu.runWrite(cmd.getCommand())) continue;
                throw new Exception("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u0430: \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430");
            }
        }
        if (!cpu.runSetAddr(this.getBeginAddr())) {
            throw new Exception("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u0430: \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430");
        }
    }

    public int getLabelAddr(String labelname) throws Exception {
        Label label = this.findLabel(labelname);
        if (label == null) {
            throw new Exception("\u041c\u0435\u0442\u043a\u0430 " + labelname + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
        }
        return label.addr;
    }

    public int getBeginAddr() throws Exception {
        return this.getLabelAddr("BEGIN");
    }

    protected class Command {
        private final Label arg;
        private final int cmd;
        private final int addr;
        private final int size;

        private Command(int addr, int cmd, Label arg, int size) throws Exception {
            this.addr = addr;
            this.cmd = cmd;
            this.arg = arg;
            this.size = size;
            Assembler.this.checkAddr(addr);
        }

        private Command(int addr, int cmd, Label arg) throws Exception {
            this(addr, cmd, arg, 1);
        }

        private Command(int addr, int cmd) throws Exception {
            this(addr, cmd, null, 1);
        }

        protected int getCommand() {
            return this.arg == null ? this.cmd : this.cmd + this.arg.addr;
        }
    }

    private class Label {
        private final String label;
        private Integer addr;

        private Label(String label) throws Exception {
            this.label = label;
            if (label.equals("")) {
                throw new Exception("\u0418\u043c\u044f \u043c\u0435\u0442\u043a\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c");
            }
            if (Utils.isHexNumeric(label)) {
                throw new Exception("\u0418\u043c\u044f \u043c\u0435\u0442\u043a\u0438 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u0435\u0440\u0438\u0447\u043d\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c");
            }
        }

        private void setAddr(int addr) throws Exception {
            Assembler.this.checkAddr(addr);
            this.addr = addr;
        }

        private boolean hasAddress() {
            return this.addr != null;
        }
    }
}

