/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

public class Utils {
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String[] flags = new String[]{"0", "1"};

    public static String toBinaryFlag(int value) {
        return flags[value];
    }

    public static int getBinaryWidth(int width) {
        return width + (width - 1 >> 2);
    }

    public static String toBinary(int value, int width) {
        int chars = Utils.getBinaryWidth(width);
        char[] buf = new char[chars];
        int pos = chars;
        for (int i = 0; i < width; ++i) {
            if (i != 0 && (i & 3) == 0) {
                buf[--pos] = 32;
            }
            buf[--pos] = digits[value & 1];
            value >>= 1;
        }
        return new String(buf);
    }

    public static int getBitNo(int pos, int width, int charWidth) {
        if ((pos -= charWidth >> 1) < 0) {
            return -1;
        }
        if ((pos = width - pos / charWidth) % 5 == 0) {
            return -1;
        }
        return pos - pos / 5 - 1;
    }

    public static int getHexWidth(int width) {
        return width + 3 >> 2;
    }

    public static String toHex(int value, int width) {
        int chars = Utils.getHexWidth(width);
        char[] buf = new char[chars];
        while (chars > 0) {
            buf[--chars] = digits[value & 0xF];
            value >>= 4;
        }
        return new String(buf);
    }

    public static boolean isNumeric(String s, int radix) {
        if (s == null || s.length() == 0) {
            return false;
        }
        int i = 0;
        if (s.charAt(0) == '-') {
            ++i;
            if (s.length() == 1) {
                return false;
            }
        }
        while (i < s.length()) {
            if (Character.digit(s.charAt(i), radix) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isHexNumeric(String s) {
        return Utils.isNumeric(s, 16);
    }
}

