/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

import ru.ifmo.cs.bcomp.Instruction;
import ru.ifmo.cs.bcomp.Utils;

public class MicroProgram {
    public final String microprogramName;
    public final Instruction[] instructionSet;
    public final String[][] microprogram;

    public MicroProgram(String microprogramName, Instruction[] instructionSet, String[][] microprogram) {
        this.microprogramName = microprogramName;
        this.instructionSet = instructionSet;
        this.microprogram = microprogram;
    }

    private boolean checkBit(int cmd, int bit) {
        return (cmd >> bit & 1) == 1;
    }

    private int getBits(int cmd, int startbit, int width) {
        return cmd >> startbit & (1 << width) - 1;
    }

    private String getRegister(int cmd) {
        switch (this.getBits(cmd, 12, 2)) {
            case 0: {
                return "\u0420\u0421";
            }
            case 1: {
                return "\u0420\u0414";
            }
            case 2: {
                return "\u0420\u041a";
            }
            case 3: {
                return "\u0410";
            }
        }
        return null;
    }

    private String getLeftInput(int cmd) {
        switch (this.getBits(cmd, 12, 2)) {
            case 0: {
                return "0";
            }
            case 1: {
                return "\u0410";
            }
            case 2: {
                return "\u0420\u0421";
            }
            case 3: {
                return "\u041a\u043b\u0420";
            }
        }
        return null;
    }

    private String getRightInput(int cmd) {
        switch (this.getBits(cmd, 8, 2)) {
            case 0: {
                return "0";
            }
            case 1: {
                return "\u0420\u0414";
            }
            case 2: {
                return "\u0420\u041a";
            }
            case 3: {
                return "\u0421\u041a";
            }
        }
        return null;
    }

    private String getInvert(String reg, int inv) {
        return inv == 1 ? "COM(" + reg + ")" : reg;
    }

    private String getOperation(int cmd, String left, String right) {
        switch (this.getBits(cmd, 4, 2)) {
            case 0: {
                return left + " + " + right;
            }
            case 1: {
                return left + " + " + right + " + 1";
            }
            case 2: {
                return left + " & " + right;
            }
        }
        return null;
    }

    private String getRotate(int cmd) {
        switch (this.getBits(cmd, 2, 2)) {
            case 0: {
                return this.getOperation(cmd, this.getInvert(this.getLeftInput(cmd), this.getBits(cmd, 6, 1)), this.getInvert(this.getRightInput(cmd), this.getBits(cmd, 7, 1)));
            }
            case 1: {
                return "RAR(\u0410)";
            }
            case 2: {
                return "RAL(\u0410)";
            }
        }
        return null;
    }

    private String getMemory(int cmd) {
        switch (this.getBits(cmd, 0, 2)) {
            case 0: {
                return "";
            }
            case 1: {
                return ", \u041e\u041f(\u0420\u0410) ==> \u0420\u0414";
            }
            case 2: {
                return ", \u0420\u0414 ==> \u041e\u041f(\u0420\u0410)";
            }
        }
        return null;
    }

    private String getOutput(int cmd) {
        switch (this.getBits(cmd, 0, 3)) {
            case 0: {
                return "";
            }
            case 1: {
                return "\u0411\u0420 ==> \u0420\u0410";
            }
            case 2: {
                return "\u0411\u0420 ==> \u0420\u0414";
            }
            case 3: {
                return "\u0411\u0420 ==> \u0420\u041a";
            }
            case 4: {
                return "\u0411\u0420 ==> \u0421\u041a";
            }
            case 5: {
                return "\u0411\u0420 ==> \u0410";
            }
        }
        return null;
    }

    private String getC(int cmd) {
        switch (this.getBits(cmd, 6, 2)) {
            case 0: {
                return "";
            }
            case 1: {
                return ", \u0421";
            }
            case 2: {
                return "0 ==> C";
            }
            case 3: {
                return "1 ==> C";
            }
        }
        return null;
    }

    public String decodeCmd(int cmd) {
        if (this.checkBit(cmd, 15)) {
            int addr = this.getBits(cmd, 0, 8);
            return "IF " + this.getRegister(cmd) + "(" + this.getBits(cmd, 8, 4) + ") = " + this.getBits(cmd, 14, 1) + " THEN " + (addr >= this.microprogram.length ? "" : this.microprogram[addr][0]) + "(" + Utils.toHex(addr, 8) + ")";
        }
        if (this.checkBit(cmd, 14)) {
            return (this.checkBit(cmd, 11) ? "\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435 \u043f\u0440\u0435\u0440\u044b\u0432\u0430\u043d\u0438\u044f " : "") + (this.checkBit(cmd, 10) ? "\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0438\u0435 \u043f\u0440\u0435\u0440\u044b\u0432\u0430\u043d\u0438\u044f " : "") + (this.checkBit(cmd, 9) ? "\u0421\u0431\u0440\u043e\u0441 \u0444\u043b\u0430\u0433\u043e\u0432 \u0412\u0423 " : "") + (this.checkBit(cmd, 8) ? "\u0412\u0432\u043e\u0434/\u0432\u044b\u0432\u043e\u0434" : "") + (this.checkBit(cmd, 3) ? "\u041e\u0441\u0442\u0430\u043d\u043e\u0432 \u043c\u0430\u0448\u0438\u043d\u044b" : "") + this.getOutput(cmd) + this.getC(cmd) + (this.checkBit(cmd, 5) ? ", N" : "") + (this.checkBit(cmd, 4) ? ", Z" : "");
        }
        return this.getRotate(cmd) + " ==> \u0411\u0420" + this.getMemory(cmd);
    }
}

