/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.util.EnumMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.ifmo.cs.bcomp.Assembler;
import ru.ifmo.cs.bcomp.BasicComp;
import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.ControlSignal;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.MicroProgram;
import ru.ifmo.cs.bcomp.SignalListener;
import ru.ifmo.cs.bcomp.ui.GUI;
import ru.ifmo.cs.bcomp.ui.io.Keyboard;
import ru.ifmo.cs.bcomp.ui.io.Numpad;
import ru.ifmo.cs.bcomp.ui.io.SevenSegmentDisplay;
import ru.ifmo.cs.bcomp.ui.io.TextPrinter;
import ru.ifmo.cs.bcomp.ui.io.Ticker;
import ru.ifmo.cs.elements.DataDestination;
import ru.ifmo.cs.elements.Register;

public class Nightmare {
    private static final Color LED_OFF = new Color(128, 128, 128);
    private static final Color LED_ON = new Color(0, 160, 0);
    private static final int BIT_RADIUS = 16;
    private static final Font LABEL_FONT = new Font("Courier New", 1, 24);
    private static final Font HINTS_FONT = new Font("Courier New", 1, 14);
    private final long[] delayPeriods = new long[]{0L, 1L, 5L, 10L, 25L, 50L, 100L, 1000L};
    private volatile int currentDelay = 3;
    private final BasicComp bcomp;
    private final CPU cpu;
    private final IOCtrl[] ioctrls;
    private EnumMap<CPU.Reg, RegisterView> regs = new EnumMap(CPU.Reg.class);
    private final SignalListener[] listeners;
    private BasicIOView io1 = null;
    private BasicIOView io2 = null;
    private BasicIOView io3 = null;
    private TextPrinter textPrinter = null;
    private Ticker ticker = null;
    private SevenSegmentDisplay ssd = null;
    private Keyboard kbd = null;
    private Numpad numpad = null;
    private GUI pairgui = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Nightmare(MicroProgram mp) throws Exception {
        this.bcomp = new BasicComp(mp);
        this.cpu = this.bcomp.getCPU();
        this.ioctrls = this.bcomp.getIOCtrls();
        try {
            String string = System.getProperty("code", null);
            File file = new File(string);
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(file);
                byte[] content = new byte[(int)file.length()];
                fin.read(content);
                String string2 = new String(content, Charset.forName("UTF-8"));
                Assembler asm = new Assembler(this.cpu.getInstructionSet());
                asm.compileProgram(string2);
                asm.loadProgram(this.cpu);
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (CPU.Reg reg : CPU.Reg.values()) {
            this.regs.put(reg, new RegisterView(this.cpu.getRegister(reg)));
        }
        this.listeners = new SignalListener[]{new SignalListener(this.regs.get((Object)CPU.Reg.STATE), ControlSignal.BUF_TO_STATE_C, ControlSignal.CLEAR_STATE_C, ControlSignal.SET_STATE_C, ControlSignal.HALT, ControlSignal.BUF_TO_STATE_N, ControlSignal.BUF_TO_STATE_Z, ControlSignal.DISABLE_INTERRUPTS, ControlSignal.ENABLE_INTERRUPTS, ControlSignal.IO0_TSF, ControlSignal.IO1_TSF, ControlSignal.IO2_TSF, ControlSignal.IO3_TSF, ControlSignal.IO4_TSF, ControlSignal.IO5_TSF, ControlSignal.IO6_TSF, ControlSignal.IO7_TSF, ControlSignal.IO8_TSF, ControlSignal.IO9_TSF, ControlSignal.SET_RUN_STATE, ControlSignal.SET_PROGRAM, ControlSignal.SET_REQUEST_INTERRUPT), new SignalListener(this.regs.get((Object)CPU.Reg.ADDR), ControlSignal.BUF_TO_ADDR), new SignalListener(this.regs.get((Object)CPU.Reg.DATA), ControlSignal.BUF_TO_DATA, ControlSignal.MEMORY_READ), new SignalListener(this.regs.get((Object)CPU.Reg.INSTR), ControlSignal.BUF_TO_INSTR), new SignalListener(this.regs.get((Object)CPU.Reg.IP), ControlSignal.BUF_TO_IP), new SignalListener(this.regs.get((Object)CPU.Reg.ACCUM), ControlSignal.BUF_TO_ACCUM, ControlSignal.IO2_IN, ControlSignal.IO3_IN, ControlSignal.IO7_IN, ControlSignal.IO8_IN, ControlSignal.IO9_IN), new SignalListener(this.regs.get((Object)CPU.Reg.BUF), ControlSignal.ALU_AND, ControlSignal.SHIFT_RIGHT, ControlSignal.SHIFT_LEFT)};
        this.bcomp.addDestination(this.listeners);
        this.cpu.setTickFinishListener(new Runnable(){

            public void run() {
                if (Nightmare.this.delayPeriods[Nightmare.this.currentDelay] != 0L) {
                    try {
                        Thread.sleep(Nightmare.this.delayPeriods[Nightmare.this.currentDelay]);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        JFrame jFrame = new JFrame("\u0411\u042d\u0412\u041c");
        jFrame.setDefaultCloseOperation(3);
        JPanel panel = new JPanel(new GridLayout(9, 1));
        panel.add(this.regs.get((Object)CPU.Reg.ADDR));
        panel.add(this.regs.get((Object)CPU.Reg.DATA));
        panel.add(this.regs.get((Object)CPU.Reg.INSTR));
        panel.add(this.regs.get((Object)CPU.Reg.IP));
        panel.add(this.regs.get((Object)CPU.Reg.BUF));
        panel.add(this.regs.get((Object)CPU.Reg.ACCUM));
        panel.add(this.regs.get((Object)CPU.Reg.STATE));
        panel.add(this.regs.get((Object)CPU.Reg.KEY));
        JLabel hints = new JLabel("F4 Enter Address F5 Save F6 Load F7 Run F8 Continue F9 Run/Halt Shift-F9 Clock");
        hints.setFont(HINTS_FONT);
        panel.add(hints);
        jFrame.add(panel);
        jFrame.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.isControlDown()) {
                    switch (e.getKeyCode()) {
                        case 81: {
                            System.exit(0);
                            break;
                        }
                        case 49: 
                        case 112: {
                            if (Nightmare.this.io1 == null) {
                                Nightmare.this.io1 = new BasicIOView(Nightmare.this.ioctrls, 1);
                            }
                            Nightmare.this.io1.activate();
                            break;
                        }
                        case 50: 
                        case 113: {
                            if (Nightmare.this.io2 == null) {
                                Nightmare.this.io2 = new BasicIOView(Nightmare.this.ioctrls, 2);
                            }
                            Nightmare.this.io2.activate();
                            break;
                        }
                        case 51: 
                        case 114: {
                            if (Nightmare.this.io3 == null) {
                                Nightmare.this.io3 = new BasicIOView(Nightmare.this.ioctrls, 3);
                            }
                            Nightmare.this.io3.activate();
                            break;
                        }
                        case 52: 
                        case 115: {
                            if (Nightmare.this.textPrinter == null) {
                                Nightmare.this.textPrinter = new TextPrinter(Nightmare.this.ioctrls[4]);
                            }
                            Nightmare.this.textPrinter.activate();
                            break;
                        }
                        case 53: 
                        case 116: {
                            if (Nightmare.this.ticker == null) {
                                Nightmare.this.ticker = new Ticker(Nightmare.this.ioctrls[5]);
                            }
                            Nightmare.this.ticker.activate();
                            break;
                        }
                        case 54: 
                        case 117: {
                            if (Nightmare.this.ssd == null) {
                                Nightmare.this.ssd = new SevenSegmentDisplay(Nightmare.this.ioctrls[6]);
                            }
                            Nightmare.this.ssd.activate();
                            break;
                        }
                        case 55: 
                        case 118: {
                            if (Nightmare.this.kbd == null) {
                                Nightmare.this.kbd = new Keyboard(Nightmare.this.ioctrls[7]);
                            }
                            Nightmare.this.kbd.activate();
                            break;
                        }
                        case 56: 
                        case 119: {
                            if (Nightmare.this.numpad == null) {
                                Nightmare.this.numpad = new Numpad(Nightmare.this.ioctrls[8]);
                            }
                            Nightmare.this.numpad.activate();
                        }
                    }
                    return;
                }
                if (e.isShiftDown()) {
                    switch (e.getKeyCode()) {
                        case 120: {
                            Nightmare.this.cpu.invertClockState();
                        }
                    }
                    return;
                }
                switch (e.getKeyCode()) {
                    case 48: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(0);
                        break;
                    }
                    case 49: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(1);
                        break;
                    }
                    case 50: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(2);
                        break;
                    }
                    case 51: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(3);
                        break;
                    }
                    case 52: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(4);
                        break;
                    }
                    case 53: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(5);
                        break;
                    }
                    case 54: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(6);
                        break;
                    }
                    case 55: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(7);
                        break;
                    }
                    case 56: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(8);
                        break;
                    }
                    case 57: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(9);
                        break;
                    }
                    case 65: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(10);
                        break;
                    }
                    case 66: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(11);
                        break;
                    }
                    case 67: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(12);
                        break;
                    }
                    case 68: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(13);
                        break;
                    }
                    case 69: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(14);
                        break;
                    }
                    case 70: {
                        ((RegisterView)Nightmare.this.regs.get((Object)CPU.Reg.KEY)).invertBit(15);
                        break;
                    }
                    case 112: {
                        Nightmare.this.ioctrls[1].setFlag();
                        break;
                    }
                    case 113: {
                        Nightmare.this.ioctrls[2].setFlag();
                        break;
                    }
                    case 114: {
                        Nightmare.this.ioctrls[3].setFlag();
                        break;
                    }
                    case 115: {
                        Nightmare.this.cpu.startSetAddr();
                        break;
                    }
                    case 116: {
                        Nightmare.this.cpu.startWrite();
                        break;
                    }
                    case 117: {
                        Nightmare.this.cpu.startRead();
                        break;
                    }
                    case 118: {
                        Nightmare.this.cpu.startStart();
                        break;
                    }
                    case 119: {
                        Nightmare.this.cpu.startContinue();
                        break;
                    }
                    case 120: {
                        Nightmare.this.cpu.invertRunState();
                        break;
                    }
                    case 122: {
                        Nightmare.this.currentDelay = (Nightmare.this.currentDelay > 0 ? Nightmare.this.currentDelay : Nightmare.this.delayPeriods.length) - 1;
                        break;
                    }
                    case 123: {
                        Nightmare.this.currentDelay = Nightmare.this.currentDelay < Nightmare.this.delayPeriods.length - 1 ? Nightmare.this.currentDelay + 1 : 0;
                    }
                }
            }
        });
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.requestFocus();
    }

    private class BasicIOView {
        private final IOCtrl ioctrl;
        private final JFrame frame;
        private final RegisterView data;
        private final RegisterView flag;

        private BasicIOView(IOCtrl[] ioctrls, int number) {
            this.ioctrl = ioctrls[number];
            this.data = new RegisterView(this.ioctrl.getRegData());
            this.flag = new RegisterView(this.ioctrl.getRegFlag());
            this.ioctrl.addDestination(IOCtrl.ControlSignal.SETFLAG, this.flag);
            if (this.ioctrl.getDirection() != IOCtrl.Direction.IN) {
                this.ioctrl.addDestination(IOCtrl.ControlSignal.OUT, this.data);
            }
            JPanel panel = new JPanel(new FlowLayout(2, 0, 0));
            panel.add(this.flag);
            panel.add(this.data);
            this.frame = new JFrame("ED Controller" + number);
            this.frame.add(panel);
            this.frame.pack();
            this.frame.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 70: 
                        case 82: 
                        case 112: 
                        case 113: 
                        case 114: {
                            BasicIOView.this.ioctrl.setFlag();
                            break;
                        }
                        case 48: {
                            BasicIOView.this.invertBit(0);
                            break;
                        }
                        case 49: {
                            BasicIOView.this.invertBit(1);
                            break;
                        }
                        case 50: {
                            BasicIOView.this.invertBit(2);
                            break;
                        }
                        case 51: {
                            BasicIOView.this.invertBit(3);
                            break;
                        }
                        case 52: {
                            BasicIOView.this.invertBit(4);
                            break;
                        }
                        case 53: {
                            BasicIOView.this.invertBit(5);
                            break;
                        }
                        case 54: {
                            BasicIOView.this.invertBit(6);
                            break;
                        }
                        case 55: {
                            BasicIOView.this.invertBit(7);
                        }
                    }
                }
            });
        }

        private void invertBit(int startbit) {
            if (this.ioctrl.getDirection() != IOCtrl.Direction.OUT) {
                this.data.invertBit(startbit);
            }
        }

        private void activate() {
            this.frame.setVisible(true);
            this.frame.requestFocus();
        }
    }

    private class RegisterView
    extends JPanel
    implements DataDestination {
        private final Register reg;
        private final BitView[] bits;

        private RegisterView(Register reg) {
            super(new FlowLayout(2, 0, 0));
            this.reg = reg;
            JLabel label = new JLabel(this.reg.fullname);
            label.setFont(LABEL_FONT);
            this.add(label);
            this.bits = new BitView[reg.width];
            for (int i = reg.width - 1; i >= 0; --i) {
                this.bits[i] = new BitView(reg, i);
                this.add(this.bits[i]);
            }
        }

        public void setValue(int value) {
            int i = 0;
            while (i < this.reg.width) {
                this.bits[i++].repaint();
            }
        }

        private void invertBit(int startbit) {
            this.reg.invertBit(startbit);
            this.bits[startbit].repaint();
        }
    }

    private class BitView
    extends JComponent {
        private final Register reg;
        private final int startbit;

        protected BitView(Register reg, int startbit) {
            this.reg = reg;
            this.startbit = startbit;
            Dimension DIMS = new Dimension(36, 36);
            this.setMinimumSize(DIMS);
            this.setMaximumSize(DIMS);
            this.setPreferredSize(DIMS);
            this.setSize(DIMS);
        }

        public void paintComponent(Graphics g) {
            g.setColor(this.reg.getValue(this.startbit) == 1 ? LED_ON : LED_OFF);
            g.fillOval(2, 2, 32, 32);
        }
    }
}

