/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui.components;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.EnumMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import ru.ifmo.cs.bcomp.BasicComp;
import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.ControlSignal;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.SignalListener;
import ru.ifmo.cs.bcomp.ui.GUI;
import ru.ifmo.cs.bcomp.ui.components.ActiveBitView;
import ru.ifmo.cs.bcomp.ui.components.BCompPanel;
import ru.ifmo.cs.bcomp.ui.components.DisplayStyles;
import ru.ifmo.cs.bcomp.ui.components.InputRegisterView;
import ru.ifmo.cs.bcomp.ui.components.MemoryView;
import ru.ifmo.cs.bcomp.ui.components.MicroMemoryView;
import ru.ifmo.cs.bcomp.ui.components.RegisterView;
import ru.ifmo.cs.bcomp.ui.components.StateRegisterView;
import ru.ifmo.cs.elements.DataDestination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentManager {
    private Color[] buttonColors = new Color[]{DisplayStyles.COLOR_TEXT, DisplayStyles.COLOR_ACTIVE};
    private ButtonProperties[] buttonProperties = new ButtonProperties[]{new ButtonProperties(135, new String[]{"F4 Enter Address"}, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ComponentManager.this.cmdEnterAddr();
        }
    }), new ButtonProperties(115, new String[]{"F5 Save"}, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ComponentManager.this.cmdWrite();
        }
    }), new ButtonProperties(115, new String[]{"F6 Read"}, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ComponentManager.this.cmdRead();
        }
    }), new ButtonProperties(90, new String[]{"F7 Start"}, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ComponentManager.this.cmdStart();
        }
    }), new ButtonProperties(135, new String[]{"F8 Continue"}, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ComponentManager.this.cmdContinue();
        }
    }), new ButtonProperties(110, new String[]{"F9 Halt", "F9 Run"}, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ComponentManager.this.cmdInvertRunState();
        }
    }), new ButtonProperties(130, new String[]{"Shift+F9 Clock"}, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            ComponentManager.this.cmdInvertClockState();
        }
    })};
    private final KeyAdapter keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 112: {
                    if (e.isShiftDown()) {
                        ComponentManager.this.cmdAbout();
                        break;
                    }
                    ComponentManager.this.cmdSetIOFlag(1);
                    break;
                }
                case 113: {
                    ComponentManager.this.cmdSetIOFlag(2);
                    break;
                }
                case 114: {
                    ComponentManager.this.cmdSetIOFlag(3);
                    break;
                }
                case 115: {
                    ComponentManager.this.cmdEnterAddr();
                    break;
                }
                case 116: {
                    ComponentManager.this.cmdWrite();
                    break;
                }
                case 117: {
                    ComponentManager.this.cmdRead();
                    break;
                }
                case 118: {
                    ComponentManager.this.cmdStart();
                    break;
                }
                case 119: {
                    ComponentManager.this.cmdContinue();
                    break;
                }
                case 120: {
                    if (e.isShiftDown()) {
                        ComponentManager.this.cmdInvertClockState();
                        break;
                    }
                    ComponentManager.this.cmdInvertRunState();
                    break;
                }
                case 121: {
                    System.exit(0);
                    break;
                }
                case 122: {
                    ComponentManager.this.cmdPrevDelay();
                    break;
                }
                case 123: {
                    ComponentManager.this.cmdNextDelay();
                    break;
                }
                case 81: {
                    if (!e.isControlDown()) break;
                    System.exit(0);
                }
            }
        }
    };
    private static final int BUTTON_RUN = 5;
    private static final int BUTTON_CLOCK = 6;
    private JButton[] buttons;
    private ButtonsPanel buttonsPanel = new ButtonsPanel();
    private final GUI gui;
    private final BasicComp bcomp;
    private final CPU cpu;
    private final IOCtrl[] ioctrls;
    private final MemoryView mem;
    private final MicroMemoryView micromem;
    private EnumMap<CPU.Reg, RegisterView> regs = new EnumMap(CPU.Reg.class);
    private ActiveBitView activeBit = new ActiveBitView(DisplayStyles.ACTIVE_BIT_X, 445);
    private volatile BCompPanel activePanel;
    private final long[] delayPeriods = new long[]{0L, 1L, 5L, 10L, 25L, 50L, 100L, 1000L};
    private volatile int currentDelay = 3;
    private volatile int savedDelay;
    private final Object lockActivePanel = new Object();
    private final JCheckBox cucheckbox;
    private volatile boolean cuswitch = false;
    private final SignalListener[] listeners;
    private ArrayList<ControlSignal> openBuses = new ArrayList();
    private static final ControlSignal[] busSignals = new ControlSignal[]{ControlSignal.DATA_TO_ALU, ControlSignal.INSTR_TO_ALU, ControlSignal.IP_TO_ALU, ControlSignal.ACCUM_TO_ALU, ControlSignal.STATE_TO_ALU, ControlSignal.KEY_TO_ALU, ControlSignal.BUF_TO_ADDR, ControlSignal.BUF_TO_DATA, ControlSignal.BUF_TO_INSTR, ControlSignal.BUF_TO_IP, ControlSignal.BUF_TO_ACCUM, ControlSignal.MEMORY_READ, ControlSignal.MEMORY_WRITE, ControlSignal.INPUT_OUTPUT, ControlSignal.IO0_TSF, ControlSignal.IO1_TSF, ControlSignal.IO1_OUT, ControlSignal.IO2_TSF, ControlSignal.IO2_IN, ControlSignal.IO3_TSF, ControlSignal.IO3_IN, ControlSignal.IO3_OUT};

    public ComponentManager(GUI gui) {
        this.gui = gui;
        this.bcomp = gui.getBasicComp();
        this.cpu = gui.getCPU();
        this.ioctrls = gui.getIOCtrls();
        this.cpu.setTickStartListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ComponentManager.this.lockActivePanel;
                synchronized (object) {
                    if (ComponentManager.this.activePanel != null) {
                        ComponentManager.this.activePanel.stepStart();
                    }
                }
                ComponentManager.this.openBuses.clear();
            }
        });
        this.cpu.setTickFinishListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ComponentManager.this.lockActivePanel;
                synchronized (object) {
                    if (ComponentManager.this.activePanel != null) {
                        ComponentManager.this.activePanel.stepFinish();
                    }
                }
                if (ComponentManager.this.delayPeriods[ComponentManager.this.currentDelay] != 0L) {
                    try {
                        Thread.sleep(ComponentManager.this.delayPeriods[ComponentManager.this.currentDelay]);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        for (ControlSignal controlSignal : busSignals) {
            this.bcomp.addDestination(controlSignal, new SignalHandler(controlSignal));
        }
        block5: for (Enum enum_ : CPU.Reg.values()) {
            switch (14.$SwitchMap$ru$ifmo$cs$bcomp$CPU$Reg[enum_.ordinal()]) {
                case 1: {
                    InputRegisterView regKey = new InputRegisterView(this, this.cpu.getRegister((CPU.Reg)enum_));
                    this.regs.put((CPU.Reg)enum_, regKey);
                    regKey.setProperties(8, 445, false);
                    continue block5;
                }
                case 2: {
                    this.regs.put((CPU.Reg)enum_, new StateRegisterView(this.cpu.getRegister((CPU.Reg)enum_)));
                    continue block5;
                }
                default: {
                    this.regs.put((CPU.Reg)enum_, new RegisterView(this.cpu.getRegister((CPU.Reg)enum_)));
                }
            }
        }
        this.listeners = new SignalListener[]{new SignalListener(this.regs.get((Object)CPU.Reg.STATE), ControlSignal.BUF_TO_STATE_C, ControlSignal.CLEAR_STATE_C, ControlSignal.SET_STATE_C), new SignalListener(this.regs.get((Object)CPU.Reg.ADDR), ControlSignal.BUF_TO_ADDR), new SignalListener(this.regs.get((Object)CPU.Reg.DATA), ControlSignal.BUF_TO_DATA, ControlSignal.MEMORY_READ), new SignalListener(this.regs.get((Object)CPU.Reg.INSTR), ControlSignal.BUF_TO_INSTR), new SignalListener(this.regs.get((Object)CPU.Reg.IP), ControlSignal.BUF_TO_IP), new SignalListener(this.regs.get((Object)CPU.Reg.ACCUM), ControlSignal.BUF_TO_ACCUM, ControlSignal.IO2_IN, ControlSignal.IO3_IN, ControlSignal.IO7_IN, ControlSignal.IO8_IN, ControlSignal.IO9_IN)};
        this.mem = new MemoryView(this.cpu.getMemory(), 1, 1);
        this.micromem = new MicroMemoryView(this.cpu, DisplayStyles.MICROMEM_X, 1);
        this.bcomp.addDestination(ControlSignal.MEMORY_READ, new DataDestination(){

            public void setValue(int value) {
                if (ComponentManager.this.activePanel != null) {
                    ComponentManager.this.mem.eventRead();
                } else {
                    ComponentManager.this.mem.updateLastAddr();
                }
            }
        });
        this.bcomp.addDestination(ControlSignal.MEMORY_WRITE, new DataDestination(){

            public void setValue(int value) {
                if (ComponentManager.this.activePanel != null) {
                    ComponentManager.this.mem.eventWrite();
                } else {
                    ComponentManager.this.mem.updateLastAddr();
                }
            }
        });
        this.cucheckbox = new JCheckBox("Enter into Control unit");
        this.cucheckbox.setOpaque(false);
        this.cucheckbox.addKeyListener(this.keyListener);
        this.cucheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ComponentManager.this.cuswitch = e.getStateChange() == 1;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelActivate(BCompPanel component) {
        Object object = this.lockActivePanel;
        synchronized (object) {
            this.activePanel = component;
            this.bcomp.addDestination(this.activePanel.getSignalListeners());
            this.bcomp.addDestination(this.listeners);
        }
        component.add(this.mem);
        component.add(this.buttonsPanel);
        component.add(this.activeBit);
        component.add(this.regs.get((Object)CPU.Reg.KEY));
        this.mem.updateMemory();
        this.cuswitch = false;
        this.switchFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelDeactivate() {
        Object object = this.lockActivePanel;
        synchronized (object) {
            this.bcomp.removeDestination(this.listeners);
            this.bcomp.removeDestination(this.activePanel.getSignalListeners());
            this.activePanel = null;
        }
    }

    public void keyPressed(KeyEvent e) {
        this.keyListener.keyPressed(e);
    }

    public void switchFocus() {
        ((InputRegisterView)this.regs.get((Object)CPU.Reg.KEY)).setActive();
    }

    public RegisterView getRegisterView(CPU.Reg reg) {
        return this.regs.get((Object)reg);
    }

    public void cmdContinue() {
        this.cpu.startContinue();
    }

    public void cmdEnterAddr() {
        if (this.cuswitch) {
            this.cpu.runSetMAddr();
            this.regs.get((Object)CPU.Reg.MIP).setValue();
        } else {
            this.cpu.startSetAddr();
        }
    }

    public void cmdWrite() {
        if (this.cuswitch) {
            this.micromem.updateLastAddr();
            this.cpu.runMWrite();
            this.micromem.updateMemory();
            this.regs.get((Object)CPU.Reg.MIP).setValue();
        } else {
            this.cpu.startWrite();
        }
    }

    public void cmdRead() {
        if (this.cuswitch) {
            this.micromem.eventRead();
            this.cpu.runMRead();
            this.regs.get((Object)CPU.Reg.MIP).setValue();
            this.regs.get((Object)CPU.Reg.MINSTR).setValue();
        } else {
            this.cpu.startRead();
        }
    }

    public void cmdStart() {
        this.cpu.startStart();
    }

    public void cmdInvertRunState() {
        this.cpu.invertRunState();
        int state = this.cpu.getStateValue(7);
        this.buttons[5].setForeground(this.buttonColors[state]);
        this.buttons[5].setText(this.buttonProperties[5].texts[state]);
    }

    public void cmdInvertClockState() {
        boolean state = this.cpu.invertClockState();
        this.buttons[6].setForeground(this.buttonColors[state ? 0 : 1]);
    }

    public void cmdSetIOFlag(int dev) {
        this.ioctrls[dev].setFlag();
    }

    public void cmdNextDelay() {
        this.currentDelay = this.currentDelay < this.delayPeriods.length - 1 ? this.currentDelay + 1 : 0;
    }

    public void cmdPrevDelay() {
        this.currentDelay = (this.currentDelay > 0 ? this.currentDelay : this.delayPeriods.length) - 1;
    }

    public void saveDelay() {
        this.savedDelay = this.currentDelay;
        this.currentDelay = 0;
    }

    public void restoreDelay() {
        this.currentDelay = this.savedDelay;
    }

    public void cmdAbout() {
        JOptionPane.showMessageDialog(this.gui, "\u042d\u043c\u0443\u043b\u044f\u0442\u043e\u0440 \u0411\u0430\u0437\u043e\u0432\u043e\u0439 \u042d\u0412\u041c. \u0412\u0435\u0440\u0441\u0438\u044f r" + GUI.class.getPackage().getImplementationVersion() + "\n\n\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430 " + this.gui.getMicroProgramName() + " \u043c\u0438\u043a\u0440\u043e\u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430", "\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", 1);
    }

    public MicroMemoryView getMicroMemory() {
        return this.micromem;
    }

    public JCheckBox getMPCheckBox() {
        return this.cucheckbox;
    }

    public ActiveBitView getActiveBit() {
        return this.activeBit;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public ArrayList<ControlSignal> getActiveSignals() {
        return this.openBuses;
    }

    public void clearActiveSignals() {
        this.openBuses.clear();
    }

    static /* synthetic */ JButton[] access$102(ComponentManager x0, JButton[] x1) {
        x0.buttons = x1;
        return x1;
    }

    private class ButtonsPanel
    extends JComponent {
        public ButtonsPanel() {
            this.setBounds(0, 514, 856, 30);
            int buttonsX = 1;
            ComponentManager.access$102(ComponentManager.this, new JButton[ComponentManager.this.buttonProperties.length]);
            for (int i = 0; i < ComponentManager.this.buttons.length; ++i) {
                ((ComponentManager)ComponentManager.this).buttons[i] = new JButton(((ComponentManager)ComponentManager.this).buttonProperties[i].texts[0]);
                ComponentManager.this.buttons[i].setForeground(ComponentManager.this.buttonColors[0]);
                ComponentManager.this.buttons[i].setFont(DisplayStyles.FONT_COURIER_PLAIN_12);
                ComponentManager.this.buttons[i].setBounds(buttonsX, 0, ((ComponentManager)ComponentManager.this).buttonProperties[i].width, 30);
                buttonsX += ((ComponentManager)ComponentManager.this).buttonProperties[i].width + 2;
                ComponentManager.this.buttons[i].setFocusable(false);
                ComponentManager.this.buttons[i].addActionListener(((ComponentManager)ComponentManager.this).buttonProperties[i].listener);
                this.add(ComponentManager.this.buttons[i]);
            }
        }
    }

    private class ButtonProperties {
        public final int width;
        public final String[] texts;
        public final ActionListener listener;

        public ButtonProperties(int width, String[] texts, ActionListener listener) {
            this.width = width;
            this.texts = texts;
            this.listener = listener;
        }
    }

    private class SignalHandler
    implements DataDestination {
        private final ControlSignal signal;

        public SignalHandler(ControlSignal signal) {
            this.signal = signal;
        }

        public void setValue(int value) {
            ComponentManager.this.openBuses.add(this.signal);
        }
    }
}

