/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui.components;

import javax.swing.JLabel;
import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.RunningCycle;
import ru.ifmo.cs.bcomp.ui.components.BCompComponent;
import ru.ifmo.cs.bcomp.ui.components.DisplayStyles;

public class RunningCycleView
extends BCompComponent {
    private CPU cpu;
    private static final String[] cycles = new String[]{"Instruction fetch", "Address fetch", "Execution", "Interruption", "Operation control", "Program"};
    private final JLabel[] labels = new JLabel[cycles.length];
    private RunningCycle lastcycle = RunningCycle.NONE;
    private int lastprogram = 0;

    public RunningCycleView(CPU cpu, int x, int y) {
        super("Control unit", cycles.length);
        this.cpu = cpu;
        this.setBounds(x, y, DisplayStyles.REG_16_WIDTH);
        for (int i = 0; i < cycles.length; ++i) {
            this.labels[i] = this.addValueLabel(cycles[i]);
            this.labels[i].setBounds(1, this.getValueY(i), this.width - 2, 25);
        }
    }

    public void update() {
        RunningCycle newcycle = this.cpu.getRunningCycle();
        int newprogram = this.cpu.getStateValue(8);
        if (newcycle != this.lastcycle) {
            if (this.lastcycle != RunningCycle.NONE) {
                this.labels[this.lastcycle.ordinal()].setForeground(DisplayStyles.COLOR_TEXT);
            }
            if (newcycle != RunningCycle.NONE) {
                this.labels[newcycle.ordinal()].setForeground(DisplayStyles.COLOR_ACTIVE);
            }
            this.lastcycle = newcycle;
        }
        if (newprogram != this.lastprogram) {
            this.labels[this.labels.length - 1].setForeground(newprogram == 0 ? DisplayStyles.COLOR_TEXT : DisplayStyles.COLOR_ACTIVE);
            this.lastprogram = newprogram;
        }
    }
}

