# Настройка IDE: VSCode

В данном приложении, мы настроим IDE [VSCode][6] для разработки ОС `Xv6`.

## Шаг 0. Первый запуск ОС Xv6

Убедитесь, что вы выполнили [действия для первого запуска ОС Xv6](/doc/setup/linux.md).

## Шаг 1. Установка и настройка VSCode

Установите официальный пакет [VSCode][6] и настройте IDE под себя.

## Шаг 2. Установка расширений VSCode

Вам понадобится плагин для запуска `devcontainers` [ms-vscode-remote.remote-containers][7].

## Шаг 3. Запуск контейнера

Введите сочетение клавиш `CTRL + SHIFT + P`, в поисковой строке введите `Dev Containers: Reopen in Container` и нажмите `Enter`. [VSCode][6] переоткроет проект внутри контейнера. Также будут установлены необходимые плагины.

## Шаг 4. Инициализация проекта

База данных компиляции (compilation database) необходима для работы анализаторов кода `clangd` от `llvm` и представляется файлом `compile_commands.json`. Поскольку `Xv6` собирается при помощи `Make`. Предлагается получить эти данные с помощью утилиты [Bear][4]. Установить ее можно с помощью [вашего пакетного менеджера][5].

Для инициализации проекта можете использовать скрипт.

```bash
sh ci/dev/prepare.sh 
```

Вы должны заметить появившийся в корне репозитория файл `compile_commands.json`. Теперь [clangd][1] должен работать исправно (иначе попробуйте перезагрузить окно (reload window) [VSCode][6]).

## Шаг 5. Отладка ядра

Для запуска отладчика `gdb` вам понадобится открыть терминал и выполнить следующую команду.

```bash
make qemu-gdb
```

Запустится `qemu` и будет дожидаться подключение дебаггера. Для запуска `gdb` нажмите `F5`.

[1]: https://clangd.llvm.org/
[4]: https://github.com/rizsotto/Bear
[5]: https://repology.org/project/bear-clang/versions
[6]: https://code.visualstudio.com/
[7]: https://marketplace.visualstudio.com/items?itemName=ms-vscode-remote.remote-containers
