# Подготовка репозитория

Для того, чтобы сдавать лабораторные работы по `Xv6`, вам необходимо будет создавать `Merge Requests` с изменениями. Преподаватель по возможности будет проводить код-ревью. Когда все правки будут учтены, мы запустим `GitHub Workflow`, который проведет тестирование вашего решения. Задача будет зачтена, если пройдены тесты, разрешены замечания преподавателя, а также вы успешно прошли защиту (ответы на вопросы по теме).

## Создание своего репозитория

Сделайте свой приватный форк данного репозитория.

```sh
git clone git@github.com:secs-dev/xv6-riscv.git
```

Приватность форка очень важна. Пожалуйста, не выкладывайте свои решения в открытый доступ. Не искушайте коллег, дайте им насладиться процессом решения лабораторных работ самостоятельно и в полной мере. Мы проверим работы на антиплагиат. Быть может, в конце семестра мы проведем специальный семинар, на котором обсудим и разберем решения всех ЛР.

## Сдача ЛР

Порядок сдачи ЛР описан в документе [Порядок прохождения Code Review](https://github.com/secs-dev/os-course/blob/main/doc/code-review.md).

## Поддержка

Держите ветку `main` чистой, переодически подтягивайте изменения из основного репозитория. Лабораторные работы выполняйте в ветках с названием вида `lab-N`, где `N` - номер лабораторной работы. Постарайтесь не делать лишних изменений, чтобы иметь читаемый diff в ваших MR. Если вы хотите внести какие-то правки, не относящиеся к ЛР (например, рефакторинг системы сборки, использование `C++` в ядре), согласуйте их с преподавателем.
