/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

import java.util.EnumMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import ru.ifmo.cs.bcomp.ControlSignal;
import ru.ifmo.cs.bcomp.IOBuses;
import ru.ifmo.cs.bcomp.IOControlSignal;
import ru.ifmo.cs.bcomp.MCDecoder;
import ru.ifmo.cs.bcomp.MicroCode;
import ru.ifmo.cs.bcomp.Reg;
import ru.ifmo.cs.bcomp.RunningCycle;
import ru.ifmo.cs.bcomp.State;
import ru.ifmo.cs.components.AutoIncRegister;
import ru.ifmo.cs.components.BasicComponent;
import ru.ifmo.cs.components.Bus;
import ru.ifmo.cs.components.Complement;
import ru.ifmo.cs.components.Consts;
import ru.ifmo.cs.components.Control;
import ru.ifmo.cs.components.CtrlBus;
import ru.ifmo.cs.components.DataAdd;
import ru.ifmo.cs.components.DataAnd;
import ru.ifmo.cs.components.DataCheckZero;
import ru.ifmo.cs.components.DataDestination;
import ru.ifmo.cs.components.DataSource;
import ru.ifmo.cs.components.Decoder;
import ru.ifmo.cs.components.Extender;
import ru.ifmo.cs.components.InputBus;
import ru.ifmo.cs.components.Memory;
import ru.ifmo.cs.components.Not;
import ru.ifmo.cs.components.PartWriter;
import ru.ifmo.cs.components.Register;
import ru.ifmo.cs.components.Valve;
import ru.ifmo.cs.components.ValveAnd;
import ru.ifmo.cs.components.ValveTwo;
import ru.ifmo.cs.components.ValveValue;
import ru.ifmo.cs.components.Xor;

public class CPU {
    private static final long MR_WIDTH = ControlSignal.TYPE.ordinal() + 1;
    private static final long VR_WIDTH = MR_WIDTH - 17L;
    private static final long MP_WIDTH = 8L;
    private static final long AR_WIDTH = 11L;
    private static final long DATA_WIDTH = 16L;
    private static final long IO_WIDTH = 8L;
    private static final long IOCMD_WIDTH = 3L;
    private static final long PS_WIDTH = State.P.ordinal() + 1;
    private final EnumMap<Reg, Register> regs = new EnumMap(Reg.class);
    private final EnumMap<ControlSignal, Control> valves = new EnumMap(ControlSignal.class);
    private final EnumMap<Buses, Bus> buses = new EnumMap(Buses.class);
    private final EnumMap<IOBuses, Bus> iobuses = new EnumMap(IOBuses.class);
    private final EnumMap<RunningCycle, Integer> labels = new EnumMap(RunningCycle.class);
    private final MicroCode mc = new MicroCode();
    private final Memory mem;
    private final Memory microcode;
    private final Register ps;
    private final Register ir;
    private final Register mp;
    private final Bus vv;
    private final Bus expected;
    private final Bus newmp;
    private final InputBus irqreq = new InputBus(1L, new DataSource[0]);
    private volatile boolean clock = true;
    private volatile long debuglevel = 0L;
    private final ReentrantLock tick = new ReentrantLock();
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition lockStart = this.lock.newCondition();
    private final Condition lockFinish = this.lock.newCondition();
    private volatile Runnable tickStartListener = null;
    private volatile Runnable tickFinishListener = null;
    private volatile Runnable cpuStartListener = null;
    private volatile Runnable cpuStopListener = null;
    private final Thread cpu = new Thread(new Runnable(){

        @Override
        public void run() {
            CPU.this.lock.lock();
            try {
                try {
                    while (true) {
                        CPU.this.lockFinish.signalAll();
                        CPU.this.lockStart.await();
                        if (CPU.this.cpuStartListener != null) {
                            CPU.this.cpuStartListener.run();
                        }
                        if (CPU.this.clock) {
                            ((Control)CPU.this.valves.get((Object)ControlSignal.SET_PROGRAM)).setValue(1L);
                        }
                        do {
                            if (CPU.this.tickStartListener != null) {
                                CPU.this.tickStartListener.run();
                            }
                            CPU.this.tick.lock();
                            try {
                                CPU.this.step();
                            }
                            finally {
                                CPU.this.tick.unlock();
                            }
                            if (CPU.this.tickFinishListener == null) continue;
                            CPU.this.tickFinishListener.run();
                        } while (CPU.this.ps.getValue(State.P.ordinal()) == 1L);
                        if (CPU.this.cpuStopListener == null) continue;
                        CPU.this.cpuStopListener.run();
                    }
                }
                catch (InterruptedException e) {
                    CPU.this.lock.unlock();
                    return;
                }
            }
            catch (Throwable throwable) {
                CPU.this.lock.unlock();
                throw throwable;
            }
        }
    }, "BComp");

    protected CPU() throws Exception {
        Register dr = new Register(16L);
        this.regs.put(Reg.DR, dr);
        Register cr = new Register(16L);
        this.regs.put(Reg.CR, cr);
        Register ip = new Register(11L);
        this.regs.put(Reg.IP, ip);
        Register sp = new Register(11L);
        this.regs.put(Reg.SP, sp);
        Register ac = new Register(16L);
        this.regs.put(Reg.AC, ac);
        Register br = new Register(16L);
        this.regs.put(Reg.BR, br);
        this.ps = new Register(PS_WIDTH);
        this.regs.put(Reg.PS, this.ps);
        this.ir = new Register(16L);
        this.regs.put(Reg.IR, this.ir);
        Register ar = new Register(11L);
        this.regs.put(Reg.AR, ar);
        Register mr = new Register(MR_WIDTH);
        this.regs.put(Reg.MR, mr);
        this.mp = new AutoIncRegister(8L);
        this.regs.put(Reg.MP, this.mp);
        this.mem = new Memory(16L, ar);
        this.microcode = new Memory(MR_WIDTH, this.mp);
        this.valves.put(ControlSignal.CLOCK0, new Valve(this.microcode, MR_WIDTH, 0L, 0L, mr));
        Bus right = new Bus(16L);
        this.buses.put(Buses.RIGHT_INPUT, right);
        Bus left = new Bus(16L);
        this.buses.put(Buses.LEFT_INPUT, left);
        Bus rcom = new Bus(16L);
        this.buses.put(Buses.RIGHT_COMPLEMENT, rcom);
        Bus lcom = new Bus(16L);
        this.buses.put(Buses.LEFT_COMPLEMENT, lcom);
        Bus aluout = new Bus(19L);
        this.buses.put(Buses.ALU_OUT, aluout);
        Bus swout = new Bus(18L);
        this.buses.put(Buses.SWITCH_OUT, swout);
        this.vv = new Bus(1L);
        this.buses.put(Buses.VV, this.vv);
        this.expected = new Bus(1L);
        this.buses.put(Buses.EXPECTED, this.expected);
        this.newmp = new Bus(8L);
        this.buses.put(Buses.NEWMP, this.newmp);
        Bus iodata = new Bus(8L);
        this.iobuses.put(IOBuses.IOData, iodata);
        Bus ioaddr = new Bus(8L);
        this.iobuses.put(IOBuses.IOAddr, ioaddr);
        CtrlBus ioctrl = new CtrlBus(8L);
        this.iobuses.put(IOBuses.IOCtrl, ioctrl);
        ValveAnd irqrq = new ValveAnd(this.ps, (long)State.EI.ordinal(), this.irqreq, new PartWriter(this.ps, 1L, State.INT.ordinal()));
        Valve clock1 = new Valve(mr, MR_WIDTH, 0L, 0L, this.newValve(dr, 16L, 0L, ControlSignal.RDDR, right), this.newValve(cr, 16L, 0L, ControlSignal.RDCR, right), this.newValve(ip, 16L, 0L, ControlSignal.RDIP, right), this.newValve(sp, 16L, 0L, ControlSignal.RDSP, right), this.newValve(ac, 16L, 0L, ControlSignal.RDAC, left), this.newValve(br, 16L, 0L, ControlSignal.RDBR, left), this.newValve(this.ps, 16L, 0L, ControlSignal.RDPS, left), this.newValve(this.ir, 16L, 0L, ControlSignal.RDIR, left));
        this.valves.put(ControlSignal.CLOCK1, clock1);
        clock1.addDestination(new Not((long)ControlSignal.COMR.ordinal(), new Valve(right, 16L, 0L, 0L, rcom)));
        DataDestination[] dataDestinationArray = new DataDestination[1];
        Control c = new Complement(right, 16L, 0L, ControlSignal.COMR.ordinal(), rcom);
        dataDestinationArray[0] = c;
        clock1.addDestination(dataDestinationArray);
        this.valves.put(ControlSignal.COMR, c);
        clock1.addDestination(new Not((long)ControlSignal.COML.ordinal(), new Valve(left, 16L, 0L, 0L, lcom)));
        DataDestination[] dataDestinationArray2 = new DataDestination[1];
        c = new Complement(left, 16L, 0L, ControlSignal.COML.ordinal(), lcom);
        dataDestinationArray2[0] = c;
        clock1.addDestination(dataDestinationArray2);
        this.valves.put(ControlSignal.COMR, c);
        ValveValue carry = new ValveValue(ControlSignal.PLS1.ordinal());
        clock1.addDestination(carry);
        this.valves.put(ControlSignal.PLS1, carry);
        DataDestination[] dataDestinationArray3 = new DataDestination[1];
        c = new DataAnd(lcom, rcom, 16L, ControlSignal.SORA.ordinal(), aluout);
        dataDestinationArray3[0] = c;
        clock1.addDestination(dataDestinationArray3);
        this.valves.put(ControlSignal.SORA, c);
        PartWriter writetoH = new PartWriter(swout, 8L, 8L);
        clock1.addDestination(new Not((long)ControlSignal.SORA.ordinal(), new DataAdd(lcom, rcom, carry, 16L, 0L, aluout), new Valve(this.ps, 1L, 0L, 0L, new PartWriter(aluout, 1L, 18L))));
        clock1.addDestination(this.newValve(aluout, 8L, 0L, ControlSignal.LTOL, swout));
        clock1.addDestination(this.newValve(aluout, 8L, 0L, ControlSignal.LTOH, writetoH));
        clock1.addDestination(this.newValve(aluout, 8L, 8L, ControlSignal.HTOL, swout));
        clock1.addDestination(this.newValve(aluout, 10L, 8L, ControlSignal.HTOH, new PartWriter(swout, 10L, 8L)));
        Control vr0 = this.newValve(mr, VR_WIDTH, 16L, ControlSignal.TYPE, new DataDestination(){

            @Override
            public synchronized void setValue(long value) {
                CPU.this.newmp.setValue(value >> 8 & BasicComponent.calculateMask(8L));
                CPU.this.expected.setValue(value >> 16 & 1L);
            }
        });
        clock1.addDestination(vr0);
        for (long i = 0L; i < 8L; ++i) {
            vr0.addDestination(new Valve(swout, 1L, i, i, this.vv));
        }
        PartWriter writeto15 = new PartWriter(swout, 1L, 15L);
        PartWriter writeto17 = new PartWriter(swout, 1L, 17L);
        PartWriter stateProgram = new PartWriter(this.ps, 1L, State.P.ordinal());
        c = new Extender(aluout, 8L, 7L, ControlSignal.SEXT.ordinal() - 16, writetoH);
        this.valves.put(ControlSignal.SEXT, c);
        DataDestination[] dataDestinationArray4 = new DataDestination[1];
        DataDestination[] dataDestinationArray5 = new DataDestination[1];
        DataDestination[] dataDestinationArray6 = new DataDestination[24];
        dataDestinationArray6[0] = c;
        dataDestinationArray6[1] = new Valve(aluout, 1L, 14L, ControlSignal.SHLT.ordinal() - 16, writeto17);
        dataDestinationArray6[2] = this.newValveH(aluout, 16L, 0L, ControlSignal.SHLT, new PartWriter(swout, 16L, 1L));
        dataDestinationArray6[3] = this.newValveH(aluout, 1L, 18L, ControlSignal.SHL0, swout);
        dataDestinationArray6[4] = this.newValveH(aluout, 15L, 1L, ControlSignal.SHRT, swout);
        dataDestinationArray6[5] = new Valve(aluout, 1L, 0L, ControlSignal.SHRT.ordinal() - 16, new PartWriter(swout, 1L, 16L));
        DataDestination[] dataDestinationArray7 = new DataDestination[2];
        Valve shrf = new Valve(aluout, 1L, 18L, 0L, writeto15, writeto17);
        dataDestinationArray7[0] = shrf;
        dataDestinationArray7[1] = new Not(0L, new Valve(aluout, 1L, 15L, 0L, writeto15, writeto17));
        dataDestinationArray6[6] = new ValveTwo((long)(ControlSignal.SHRT.ordinal() - 16), (long)(ControlSignal.SHRF.ordinal() - 16), dataDestinationArray7);
        dataDestinationArray6[7] = this.newValveH(swout, 1L, 16L, ControlSignal.SETC, new PartWriter(this.ps, 1L, State.C.ordinal()));
        Xor setv = new Xor(swout, 2L, 16L, ControlSignal.SETV.ordinal() - 16, new PartWriter(this.ps, 1L, State.V.ordinal()));
        dataDestinationArray6[8] = setv;
        dataDestinationArray6[9] = new DataCheckZero(swout, 16L, (long)(ControlSignal.STNZ.ordinal() - 16), new PartWriter(this.ps, 1L, State.Z.ordinal()));
        dataDestinationArray6[10] = this.newValveH(swout, 1L, 15L, ControlSignal.STNZ, new PartWriter(this.ps, 1L, State.N.ordinal()));
        dataDestinationArray6[11] = this.newValveH(swout, 16L, 0L, ControlSignal.WRDR, dr);
        dataDestinationArray6[12] = this.newValveH(swout, 16L, 0L, ControlSignal.WRCR, cr);
        dataDestinationArray6[13] = this.newValveH(swout, 11L, 0L, ControlSignal.WRIP, ip);
        dataDestinationArray6[14] = this.newValveH(swout, 11L, 0L, ControlSignal.WRSP, sp);
        dataDestinationArray6[15] = this.newValveH(swout, 16L, 0L, ControlSignal.WRAC, ac);
        dataDestinationArray6[16] = this.newValveH(swout, 16L, 0L, ControlSignal.WRBR, br);
        dataDestinationArray6[17] = this.newValveH(swout, PS_WIDTH, 0L, ControlSignal.WRPS, new PartWriter(this.ps, 6L, 0L), irqrq);
        dataDestinationArray6[18] = this.newValveH(swout, 11L, 0L, ControlSignal.WRAR, ar);
        dataDestinationArray6[19] = this.newValveH(this.mem, 16L, 0L, ControlSignal.LOAD, dr);
        dataDestinationArray6[20] = this.newValveH(dr, 16L, 0L, ControlSignal.STOR, this.mem);
        dataDestinationArray6[21] = this.newValveH(Consts.consts[1], 1L, 0L, ControlSignal.IO, new Valve(cr, 8L, 0L, 0L, ioaddr), new Decoder(cr, 8L, 3L, 0L, ioctrl));
        dataDestinationArray6[22] = this.newValveH(Consts.consts[1], 1L, 0L, ControlSignal.INTS, new DataDestination[0]);
        dataDestinationArray6[23] = this.newValveH(Consts.consts[0], 1L, 0L, ControlSignal.HALT, stateProgram);
        dataDestinationArray5[0] = new Valve(mr, VR_WIDTH, 16L, 0L, dataDestinationArray6);
        dataDestinationArray4[0] = new Not((long)ControlSignal.TYPE.ordinal(), dataDestinationArray5);
        clock1.addDestination(dataDestinationArray4);
        this.valves.put(ControlSignal.SHRF, shrf);
        this.valves.put(ControlSignal.SETV, setv);
        this.valves.put(ControlSignal.SET_PROGRAM, new Valve(Consts.consts[1], 1L, 0L, 0L, stateProgram));
        clock1.addDestination(new DataDestination(){

            @Override
            public void setValue(long value) {
                CPU.this.mp.setValue(CPU.this.vv.getValue() == CPU.this.expected.getValue() ? CPU.this.newmp.getValue() : 0L);
            }
        });
        for (int i = 0; i < this.mc.getMicroCodeLength(); ++i) {
            this.microcode.setValue(i, this.mc.getMicroCommand(i));
        }
        for (RunningCycle cycle : RunningCycle.values()) {
            this.labels.put(cycle, this.findLabel(cycle.name()));
        }
        this.mp.setValue(this.labels.get((Object)RunningCycle.STOP) + 1);
        this.valves.put(ControlSignal.SET_REQUEST_INTERRUPT, irqrq);
        Control ei = new Control(1L, 0L, 0L, new PartWriter(this.ps, 1L, State.EI.ordinal()), irqrq);
        this.valves.put(ControlSignal.SET_EI, ei);
        ioctrl.addDestination(new ValveTwo((long)IOControlSignal.OUT.ordinal(), (long)IOControlSignal.RDY.ordinal(), new Not(0L, new Valve(ac, 8L, 0L, 0L, iodata))), new ValveTwo((long)IOControlSignal.IN.ordinal(), (long)IOControlSignal.RDY.ordinal(), new Valve(iodata, 8L, 0L, 0L, new PartWriter(ac, 8L, 0L))), new Valve(Consts.consts[0], 1L, 0L, IOControlSignal.DI.ordinal(), ei), new Valve(Consts.consts[1], 1L, 0L, IOControlSignal.EI.ordinal(), ei), new Valve(ioaddr, 3L, 0L, IOControlSignal.IRQ.ordinal(), new PartWriter(cr, 8L, 0L)));
    }

    private Control newValve(DataSource input, long width, long startbit, ControlSignal cs, DataDestination ... dsts) {
        Valve valve = new Valve(input, width, startbit, cs.ordinal(), dsts);
        this.valves.put(cs, valve);
        return valve;
    }

    private Control newValveH(DataSource input, long width, long startbit, ControlSignal cs, DataDestination ... dsts) {
        Valve valve = new Valve(input, width, startbit, cs.ordinal() - 16, dsts);
        this.valves.put(cs, valve);
        return valve;
    }

    public EnumMap<Reg, Register> getRegisters() {
        return this.regs;
    }

    public Register getRegister(Reg reg) {
        return this.regs.get((Object)reg);
    }

    public Memory getMemory() {
        return this.mem;
    }

    public Memory getMicroCode() {
        return this.microcode;
    }

    public MicroCode getMicroCodeSource() {
        return this.mc;
    }

    public EnumMap<IOBuses, Bus> getIOBuses() {
        return this.iobuses;
    }

    public void addIRQReqInput(DataSource ... inputs) {
        this.irqreq.addInput(inputs);
    }

    public Control getIRQReqValve() {
        return this.valves.get((Object)ControlSignal.SET_REQUEST_INTERRUPT);
    }

    public synchronized void step() {
        if ((this.debuglevel & 1L) == 1L) {
            System.out.println(MCDecoder.getFormattedMC(this, this.getRegister(Reg.MP).getValue()));
        }
        for (Buses buses : Buses.values()) {
            this.buses.get((Object)buses).resetValue();
        }
        for (Enum enum_ : IOBuses.values()) {
            this.iobuses.get(enum_).resetValue();
        }
        this.valves.get((Object)ControlSignal.CLOCK0).setValue(1L);
        this.valves.get((Object)ControlSignal.CLOCK1).setValue(1L);
    }

    void startCPU() throws InterruptedException {
        this.lock.lock();
        try {
            this.cpu.start();
            this.lockFinish.await();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stopCPU() {
        this.cpu.interrupt();
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }

    public void tickLock() {
        this.tick.lock();
    }

    public void tickUnlock() {
        this.tick.unlock();
    }

    public void addDestination(ControlSignal cs, DataDestination dest) {
        this.valves.get((Object)cs).addDestination(dest);
    }

    public void removeDestination(ControlSignal cs, DataDestination dest) {
        this.valves.get((Object)cs).removeDestination(dest);
    }

    public void setTickStartListener(Runnable tickStartListener) {
        this.tickStartListener = tickStartListener;
    }

    public void setTickFinishListener(Runnable tickFinishListener) {
        this.tickFinishListener = tickFinishListener;
    }

    public void setCPUStartListener(Runnable cpuStartListener) {
        this.cpuStartListener = cpuStartListener;
    }

    public void setCPUStopListener(Runnable cpuStopListener) {
        this.cpuStopListener = cpuStopListener;
    }

    public void setRunState(boolean state) {
        this.tick.lock();
        try {
            this.ps.setValue(state ? 1L : 0L, 1L, State.W.ordinal());
        }
        finally {
            this.tick.unlock();
        }
    }

    public void invertRunState() {
        this.tick.lock();
        try {
            this.ps.invertBit(State.W.ordinal());
        }
        finally {
            this.tick.unlock();
        }
    }

    public long getRegValue(Reg reg) {
        return this.regs.get((Object)reg).getValue();
    }

    public long getRegWidth(Reg reg) {
        return this.regs.get((Object)((Object)reg)).width;
    }

    public long getProgramState(State state) {
        return this.ps.getValue(state.ordinal());
    }

    public boolean getClockState() {
        return this.clock;
    }

    public void setClockState(boolean clock) {
        this.tick.lock();
        try {
            this.clock = clock;
            if (!clock) {
                this.valves.get((Object)ControlSignal.HALT).setValue(1L << ControlSignal.HALT.ordinal() - 16);
            }
        }
        finally {
            this.tick.unlock();
        }
    }

    public boolean invertClockState() {
        this.setClockState(!this.clock);
        return this.clock;
    }

    public void setDebugLevel(long debuglevel) {
        this.debuglevel = debuglevel;
    }

    public final int findLabel(String label) throws Exception {
        return this.mc.findLabel(label);
    }

    private void jump(long addr) {
        if (addr > 0L) {
            this.mp.setValue(addr);
        }
    }

    private boolean startFrom(long addr) {
        if (this.lock.tryLock()) {
            try {
                this.jump(addr);
                this.lockStart.signal();
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
        return false;
    }

    public boolean startSetAddr() {
        return this.startFrom(this.labels.get((Object)RunningCycle.SETIP).intValue());
    }

    public boolean startWrite() {
        return this.startFrom(this.labels.get((Object)RunningCycle.WRITE).intValue());
    }

    public boolean startRead() {
        return this.startFrom(this.labels.get((Object)RunningCycle.READ).intValue());
    }

    public boolean startStart() {
        return this.startFrom(this.labels.get((Object)RunningCycle.START).intValue());
    }

    public boolean startContinue() {
        return this.startFrom(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeFrom(long label) {
        if (this.lock.tryLock()) {
            try {
                this.jump(label);
                this.lockStart.signal();
                this.lockFinish.await();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
        return false;
    }

    public boolean executeSetAddr() {
        return this.executeFrom(this.labels.get((Object)RunningCycle.SETIP).intValue());
    }

    public boolean executeSetAddr(long value) {
        this.ir.setValue(value);
        return this.executeSetAddr();
    }

    public boolean executeWrite() {
        return this.executeFrom(this.labels.get((Object)RunningCycle.WRITE).intValue());
    }

    public boolean executeWrite(long value) {
        this.ir.setValue(value);
        return this.executeWrite();
    }

    public boolean executeRead() {
        return this.executeFrom(this.labels.get((Object)RunningCycle.READ).intValue());
    }

    public boolean executeStart() {
        return this.executeFrom(this.labels.get((Object)RunningCycle.START).intValue());
    }

    public boolean executeContinue() {
        return this.executeFrom(0L);
    }

    public boolean executeSetMP() {
        if (this.lock.tryLock()) {
            try {
                this.mp.setValue(this.ir.getValue());
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
        return false;
    }

    public boolean executeMCWrite(long value) {
        if (this.lock.tryLock()) {
            try {
                this.microcode.setValue(value);
                this.mp.setValue(0L);
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
        return false;
    }

    public boolean executeMCRead() {
        if (this.lock.tryLock()) {
            try {
                this.valves.get((Object)ControlSignal.CLOCK0).setValue(1L);
                this.mp.setValue(0L);
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
        return false;
    }

    public RunningCycle getRunningCycle() {
        int i;
        long addr = this.mp.getValue();
        RunningCycle[] cycles = RunningCycle.values();
        for (i = cycles.length - 1; i > 0; --i) {
            if (addr < (long)this.labels.get((Object)cycles[i]).intValue()) continue;
            return cycles[i];
        }
        return cycles[i];
    }

    private static enum Buses {
        RIGHT_INPUT,
        LEFT_INPUT,
        RIGHT_COMPLEMENT,
        LEFT_COMPLEMENT,
        ALU_OUT,
        SWITCH_OUT,
        VV,
        EXPECTED,
        NEWMP;

    }
}

