/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.IOBuses;
import ru.ifmo.cs.bcomp.IOControlSignal;
import ru.ifmo.cs.components.Bus;
import ru.ifmo.cs.components.Comparer;
import ru.ifmo.cs.components.Control;
import ru.ifmo.cs.components.CtrlBus;
import ru.ifmo.cs.components.DataDestination;
import ru.ifmo.cs.components.Decoder;
import ru.ifmo.cs.components.InputBus;
import ru.ifmo.cs.components.Not;
import ru.ifmo.cs.components.Register;
import ru.ifmo.cs.components.Valve;

public abstract class IOCtrl {
    public final int READYBIT = 6;
    final Bus iodata;
    final Bus ioaddr;
    final CtrlBus ioctrl;
    private final Decoder chkregister;
    private final Control irqrqvalve;

    public IOCtrl(long addr, long width, CPU cpu) {
        Register devaddr = new Register(8L - width);
        devaddr.setValue(addr >> (int)width);
        this.irqrqvalve = cpu.getIRQReqValve();
        this.iodata = cpu.getIOBuses().get((Object)IOBuses.IOData);
        this.ioaddr = cpu.getIOBuses().get((Object)IOBuses.IOAddr);
        this.ioctrl = (CtrlBus)cpu.getIOBuses().get((Object)IOBuses.IOCtrl);
        DataDestination[] dataDestinationArray = new DataDestination[1];
        DataDestination[] dataDestinationArray2 = new DataDestination[1];
        DataDestination[] dataDestinationArray3 = new DataDestination[1];
        DataDestination[] dataDestinationArray4 = new DataDestination[1];
        DataDestination[] dataDestinationArray5 = new DataDestination[1];
        DataDestination[] dataDestinationArray6 = new DataDestination[1];
        DataDestination[] dataDestinationArray7 = new DataDestination[1];
        DataDestination[] dataDestinationArray8 = new DataDestination[1];
        DataDestination[] dataDestinationArray9 = new DataDestination[1];
        DataDestination[] dataDestinationArray10 = new DataDestination[1];
        this.chkregister = new Decoder(this.ioaddr, 0L, width, 0L, new DataDestination[0]);
        dataDestinationArray10[0] = this.chkregister;
        dataDestinationArray9[0] = new Comparer(devaddr, dataDestinationArray10);
        dataDestinationArray8[0] = new Valve(new InputBus(8L - width, width, this.ioaddr), 8L - width, 0L, 0L, dataDestinationArray9);
        dataDestinationArray7[0] = new Not(0L, dataDestinationArray8);
        dataDestinationArray6[0] = new Valve(this.ioctrl, 1L, (long)IOControlSignal.RDY.ordinal(), 0L, dataDestinationArray7);
        dataDestinationArray5[0] = new Not(0L, dataDestinationArray6);
        dataDestinationArray4[0] = new Valve(this.ioctrl, 1L, (long)IOControlSignal.IRQ.ordinal(), 0L, dataDestinationArray5);
        dataDestinationArray3[0] = new Not(0L, dataDestinationArray4);
        dataDestinationArray2[0] = new Valve(this.ioctrl, 1L, (long)IOControlSignal.EI.ordinal(), 0L, dataDestinationArray3);
        dataDestinationArray[0] = new Not((long)IOControlSignal.DI.ordinal(), dataDestinationArray2);
        this.ioctrl.addDestination(dataDestinationArray);
    }

    public void updateStateIRQ() {
        this.irqrqvalve.setValue(1L);
    }

    public final void checkRegister(DataDestination ... dsts) {
        this.chkregister.addDestination(dsts);
    }

    public abstract Register[] getRegisters();

    public abstract DataDestination getIRQSC();

    public abstract void addDestination(int var1, DataDestination ... var2);

    public abstract boolean isReady();

    public abstract void setReady();

    public abstract long getData();

    public abstract void setData(long var1);

    public void addDestination(Register reg, DataDestination ... dsts) {
        Register[] registers = this.getRegisters();
        for (int i = 0; i < registers.length; ++i) {
            if (registers[i] != reg) continue;
            this.addDestination(i, dsts);
            return;
        }
    }
}

