/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.IOControlSignal;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.components.And;
import ru.ifmo.cs.components.Consts;
import ru.ifmo.cs.components.Control;
import ru.ifmo.cs.components.DataDestination;
import ru.ifmo.cs.components.Not;
import ru.ifmo.cs.components.PartWriter;
import ru.ifmo.cs.components.Register;
import ru.ifmo.cs.components.Valve;

public class IOCtrlAdv
extends IOCtrl {
    private final int STATE = 2;
    private final int CONTROL = 3;
    private final Register[] registers = new Register[]{new Register(8L), new Register(8L), new Register(8L), new Register(8L)};
    private final Control[] writeToRegister = new Control[this.registers.length];
    private final DataDestination irqsc;

    public IOCtrlAdv(long addr, CPU cpu, DataDestination ... chainctrl) {
        super(addr, 2L, cpu);
        And reqirq = new And(this.registers[2], 6L, this.registers[3], 3L);
        cpu.addIRQReqInput(reqirq);
        this.irqsc = new Valve(reqirq, 1L, 0L, 0L, new Valve(this.registers[3], 3L, 0L, 0L, this.ioaddr), new Valve(Consts.consts[1], 1L, 0L, 0L, new PartWriter(this.ioctrl, 1L, IOControlSignal.IRQ.ordinal())), new Not(0L, chainctrl));
        Valve rdy = new Valve(Consts.consts[1], 1L, 0L, 0L, new PartWriter(this.ioctrl, 1L, IOControlSignal.RDY.ordinal()));
        for (int i = 0; i < this.registers.length; ++i) {
            DataDestination[] dataDestinationArray = new DataDestination[1];
            DataDestination[] dataDestinationArray2 = new DataDestination[2];
            dataDestinationArray2[0] = new Valve(Consts.consts[1], 1L, 0L, IOControlSignal.IN.ordinal(), new Valve(this.registers[i], 8L, 0L, 0L, this.iodata), rdy);
            DataDestination[] dataDestinationArray3 = new DataDestination[2];
            this.writeToRegister[i] = new Valve(this.iodata, 8L, 0L, 0L, this.registers[i]);
            dataDestinationArray3[0] = this.writeToRegister[i];
            dataDestinationArray3[1] = rdy;
            dataDestinationArray2[1] = new Valve(Consts.consts[1], 1L, 0L, IOControlSignal.OUT.ordinal(), dataDestinationArray3);
            dataDestinationArray[0] = new Valve(this.ioctrl, 8L, 0L, i, dataDestinationArray2);
            this.checkRegister(dataDestinationArray);
        }
        this.writeToRegister[2].addDestination(cpu.getIRQReqValve());
        this.writeToRegister[3].addDestination(cpu.getIRQReqValve());
    }

    @Override
    public boolean isReady() {
        return this.registers[2].getValue(6L) == 1L;
    }

    @Override
    public void setReady() {
        this.registers[2].setValue(1L, 1L, 6L);
        this.updateStateIRQ();
    }

    @Override
    public DataDestination getIRQSC() {
        return this.irqsc;
    }

    @Override
    public Register[] getRegisters() {
        return this.registers;
    }

    @Override
    public void addDestination(int reg, DataDestination ... dsts) {
        this.writeToRegister[reg].addDestination(dsts);
    }

    @Override
    public long getData() {
        return this.registers[0].getValue();
    }

    @Override
    public void setData(long value) {
        this.registers[0].setValue(value);
    }

    public String toString() {
        return "DR0 = " + this.registers[0] + " DR1 = " + this.registers[1] + " State = " + this.registers[2] + " Control = " + this.registers[3];
    }
}

