/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.IOControlSignal;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.components.And;
import ru.ifmo.cs.components.Consts;
import ru.ifmo.cs.components.Control;
import ru.ifmo.cs.components.DataDestination;
import ru.ifmo.cs.components.Not;
import ru.ifmo.cs.components.PartWriter;
import ru.ifmo.cs.components.Register;
import ru.ifmo.cs.components.Valve;

public class IOCtrlBasic
extends IOCtrl {
    private final int DR = 0;
    private final int STATE = 1;
    private final int IRQ = 2;
    private final Register dr = new Register(8L);
    private final Register state = new Register(1L);
    private final Register irqreg = new Register(4L);
    private final Register[] registers = new Register[]{this.dr, this.state, this.irqreg};
    private final Control[] writeToRegister = new Control[this.registers.length];
    private final DataDestination irqsc;

    public IOCtrlBasic(long addr, CPU cpu, TYPE type, DataDestination ... chainctrl) {
        super(addr, 1L, cpu);
        And reqirq = new And(this.state, 0L, this.irqreg, 3L);
        cpu.addIRQReqInput(reqirq);
        this.irqsc = new Valve(reqirq, 1L, 0L, 0L, new Valve(this.irqreg, 3L, 0L, 0L, this.ioaddr), new Valve(Consts.consts[1], 1L, 0L, 0L, new PartWriter(this.ioctrl, 1L, IOControlSignal.IRQ.ordinal())), new Not(0L, chainctrl));
        Valve rdy = new Valve(Consts.consts[1], 1L, 0L, 0L, new PartWriter(this.ioctrl, 1L, IOControlSignal.RDY.ordinal()));
        this.writeToRegister[1] = new Control(1L, 0L, 0L, this.state, cpu.getIRQReqValve());
        Valve clearFlag = new Valve(Consts.consts[0], 1L, 0L, 0L, this.writeToRegister[1]);
        DataDestination[] dataDestinationArray = new DataDestination[2];
        Valve r0 = new Valve(this.ioctrl, 8L, 0L, 0L, new DataDestination[0]);
        dataDestinationArray[0] = r0;
        DataDestination[] dataDestinationArray2 = new DataDestination[2];
        dataDestinationArray2[0] = new Valve(Consts.consts[1], 1L, 0L, IOControlSignal.IN.ordinal(), new Valve(this.state, 1L, 0L, 0L, new PartWriter(this.iodata, 1L, 6L)), rdy);
        DataDestination[] dataDestinationArray3 = new DataDestination[2];
        this.writeToRegister[2] = new Valve(this.iodata, this.irqreg.width, 0L, 0L, this.irqreg, cpu.getIRQReqValve());
        dataDestinationArray3[0] = this.writeToRegister[2];
        dataDestinationArray3[1] = rdy;
        dataDestinationArray2[1] = new Valve(Consts.consts[1], 1L, 0L, IOControlSignal.OUT.ordinal(), dataDestinationArray3);
        dataDestinationArray[1] = new Valve(this.ioctrl, 8L, 0L, 1L, dataDestinationArray2);
        this.checkRegister(dataDestinationArray);
        if (type == TYPE.INPUT || type == TYPE.INPUTOUTPUT) {
            r0.addDestination(new Valve(Consts.consts[1], 1L, 0L, IOControlSignal.IN.ordinal(), new Valve(this.dr, 8L, 0L, 0L, this.iodata), clearFlag, rdy));
        }
        this.writeToRegister[0] = new Valve(this.iodata, 8L, 0L, 0L, this.dr);
        if (type == TYPE.OUTPUT || type == TYPE.INPUTOUTPUT) {
            r0.addDestination(new Valve(Consts.consts[1], 1L, 0L, IOControlSignal.OUT.ordinal(), this.writeToRegister[0], clearFlag, rdy));
        }
    }

    @Override
    public boolean isReady() {
        return this.state.getValue() == 1L;
    }

    @Override
    public void setReady() {
        this.writeToRegister[1].setValue(1L);
    }

    @Override
    public DataDestination getIRQSC() {
        return this.irqsc;
    }

    @Override
    public Register[] getRegisters() {
        return this.registers;
    }

    @Override
    public void addDestination(int reg, DataDestination ... dsts) {
        this.writeToRegister[reg].addDestination(dsts);
    }

    @Override
    public long getData() {
        return this.dr.getValue();
    }

    @Override
    public void setData(long value) {
        this.dr.setValue(value);
    }

    public String toString() {
        return "IRQ = " + this.irqreg + " State = " + this.state + " Data = " + this.dr;
    }

    public static enum TYPE {
        INPUT,
        OUTPUT,
        INPUTOUTPUT;

    }
}

