/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

import java.util.ArrayList;
import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.ControlSignal;
import ru.ifmo.cs.bcomp.MicroCode;
import ru.ifmo.cs.bcomp.State;
import ru.ifmo.cs.components.Utils;

public class MCDecoder {
    private static ControlSignal[] signals = ControlSignal.values();
    private static ControlSignal[] LEFT = new ControlSignal[]{ControlSignal.RDAC, ControlSignal.RDBR, ControlSignal.RDPS, ControlSignal.RDIR};
    private static ControlSignal[] RIGHT = new ControlSignal[]{ControlSignal.RDDR, ControlSignal.RDCR, ControlSignal.RDIP, ControlSignal.RDSP};

    public static final String[] decodeMC(CPU cpu, long addr) {
        int i;
        MicroCode mc = cpu.getMicroCodeSource();
        String[] res = new String[3];
        ArrayList<ControlSignal> cs = new ArrayList<ControlSignal>();
        long cmd = cpu.getMicroCode().getValue(addr);
        res[0] = mc.getLabel((int)addr);
        res[1] = Utils.toHex(cmd, 40L);
        for (i = 0; i < 16; ++i) {
            if ((cmd & 1L << i) == 0L) continue;
            cs.add(signals[i]);
        }
        if ((cmd & 1L << ControlSignal.TYPE.ordinal()) == 0L) {
            for (i = 16; i < ControlSignal.TYPE.ordinal(); ++i) {
                if ((cmd & 1L << i) == 0L) continue;
                cs.add(signals[i]);
            }
            res[2] = MCDecoder.decodeOMC(cs);
        } else {
            res[2] = MCDecoder.decodeCMC(mc, cs, cmd >> 16 & 0xFFL, cmd >> 24 & 0xFFL, cmd >> 32 & 1L);
        }
        return res;
    }

    public static String getFormattedMC(CPU cpu, long addr) {
        String[] decoded = MCDecoder.decodeMC(cpu, addr);
        return Utils.toHex(addr, 8L) + " " + decoded[1] + "\t" + (decoded[0] == null ? "\t\t" : decoded[0] + (decoded[0].length() > 7 ? "\t" : "\t\t")) + (decoded[2] == null ? "No operations" : decoded[2]);
    }

    private static String decodeCMC(MicroCode mc, ArrayList<ControlSignal> cs, long checkbit, long addr, long expected) {
        String label = mc.getLabel((int)addr);
        String aluOutput = MCDecoder.getAluOutput(cs);
        String bit = null;
        String to = (label == null ? "" : label + " @ ") + Utils.toHex(addr, 8L);
        int i = 0;
        while (i < 8 && (checkbit & 1L) != 1L) {
            ++i;
            checkbit >>= 1;
        }
        if (cs.contains((Object)ControlSignal.HTOL)) {
            i += 8;
        }
        if (aluOutput.equals("PS")) {
            if (i == State.PS0.ordinal()) {
                return "GOTO " + to;
            }
            for (State state : State.values()) {
                if (i != state.ordinal()) continue;
                bit = state.name();
            }
        } else {
            bit = "" + i;
        }
        return "if " + aluOutput + "(" + bit + ") = " + expected + " then GOTO " + to;
    }

    private static String decodeOMC(ArrayList<ControlSignal> cs) {
        ArrayList<String> operations = new ArrayList<String>();
        String writelist = MCDecoder.getWriteList(cs);
        String result = null;
        if (writelist != null) {
            String swOutput = MCDecoder.getSwOutput(cs);
            operations.add((swOutput == null ? "0" : swOutput) + " \u2192 " + writelist);
        }
        if (cs.contains((Object)ControlSignal.LOAD)) {
            operations.add("MEM(AR) \u2192 DR");
        }
        if (cs.contains((Object)ControlSignal.STOR)) {
            operations.add("DR \u2192 MEM(AR)");
        }
        if (cs.contains((Object)ControlSignal.IO)) {
            operations.add("IO");
        }
        if (cs.contains((Object)ControlSignal.INTS)) {
            operations.add("INTS");
        }
        if (cs.contains((Object)ControlSignal.HALT)) {
            operations.add("Halt");
        }
        for (String op : operations) {
            result = result == null ? op : result + "; " + op;
        }
        return result;
    }

    private static String getInput(ArrayList<ControlSignal> cs, ControlSignal[] rdsignals) {
        String regs = null;
        boolean addpar = false;
        for (ControlSignal c : rdsignals) {
            if (!cs.contains((Object)c)) continue;
            String name = c.name().substring(2);
            if (regs == null) {
                regs = name;
                continue;
            }
            regs = regs + " | " + name;
            addpar = true;
        }
        return regs == null ? null : (addpar ? "(" : "") + regs + (addpar ? ")" : "");
    }

    private static String getComplement(ArrayList<ControlSignal> cs, ControlSignal[] rdsignals, ControlSignal complement) {
        String input = MCDecoder.getInput(cs, rdsignals);
        if (cs.contains((Object)complement)) {
            if (input == null) {
                return "~0";
            }
            return "~" + input;
        }
        if (input == null) {
            return null;
        }
        return input;
    }

    private static String getAluOutput(ArrayList<ControlSignal> cs) {
        String left = MCDecoder.getComplement(cs, LEFT, ControlSignal.COML);
        String right = MCDecoder.getComplement(cs, RIGHT, ControlSignal.COMR);
        if (cs.contains((Object)ControlSignal.SORA)) {
            return (left == null ? "0" : left) + " & " + (right == null ? "0" : right);
        }
        boolean pls1 = cs.contains((Object)ControlSignal.PLS1);
        if (left == null) {
            if (pls1) {
                return right == null ? "1" : right + " + 1";
            }
            return right == null ? "0" : right;
        }
        return left + (right == null ? "" : " + " + right) + (pls1 ? " + 1" : "");
    }

    private static String getSwOutput(ArrayList<ControlSignal> cs) {
        String alu = MCDecoder.getAluOutput(cs);
        if (cs.contains((Object)ControlSignal.HTOH)) {
            if (cs.contains((Object)ControlSignal.LTOL)) {
                return alu;
            }
            return "HTOH(" + alu + ")";
        }
        if (cs.contains((Object)ControlSignal.LTOL)) {
            if (cs.contains((Object)ControlSignal.SEXT)) {
                return "extend sign " + alu + "(0..7)";
            }
            return "LTOL(" + alu + ")";
        }
        if (cs.contains((Object)ControlSignal.LTOH)) {
            if (cs.contains((Object)ControlSignal.HTOL)) {
                return "SWAB(" + alu + ")";
            }
            return "LTOH(" + alu + ")";
        }
        if (cs.contains((Object)ControlSignal.HTOL)) {
            return "HTOL(" + alu + ")";
        }
        if (cs.contains((Object)ControlSignal.SEXT)) {
            return "SEXT(" + alu + ")";
        }
        if (cs.contains((Object)ControlSignal.SHLT)) {
            if (cs.contains((Object)ControlSignal.SHL0)) {
                return "ROL(" + alu + ")";
            }
            return "SHL(" + alu + ")";
        }
        if (cs.contains((Object)ControlSignal.SHRT)) {
            if (cs.contains((Object)ControlSignal.SHRF)) {
                return "ROR(" + alu + ")";
            }
            return "ASR(" + alu + ")";
        }
        return null;
    }

    private static String getWriteList(ArrayList<ControlSignal> cs) {
        ArrayList<String> dsts = new ArrayList<String>();
        String result = null;
        for (int i = ControlSignal.WRDR.ordinal(); i <= ControlSignal.WRAR.ordinal(); ++i) {
            if (!cs.contains((Object)signals[i])) continue;
            dsts.add(signals[i].name().substring(2));
        }
        if (cs.contains((Object)ControlSignal.STNZ)) {
            dsts.add("N");
            dsts.add("Z");
        }
        if (cs.contains((Object)ControlSignal.SETV)) {
            dsts.add("V");
        }
        if (cs.contains((Object)ControlSignal.SETC)) {
            dsts.add("C");
        }
        for (String dst : dsts) {
            result = result == null ? dst : result + ", " + dst;
        }
        return result;
    }
}

