/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ProgramBinary {
    public static final int UNDEFINED = -1;
    public int load_address = -1;
    public int start_address = -1;
    public List<Integer> binary = null;

    public ProgramBinary() {
    }

    public ProgramBinary(List<Integer> prog) {
        this.loadBinaryFormat(prog);
    }

    public final List<Integer> getBinaryFormat() {
        if (this.start_address == -1 || this.load_address == -1 || this.binary == null || this.binary.isEmpty()) {
            throw new RuntimeException("BcompNG: Program data is corrupted");
        }
        LinkedList<Integer> prog = new LinkedList<Integer>(this.binary);
        prog.add(0, this.start_address);
        prog.add(0, this.load_address);
        return prog;
    }

    public final void loadBinaryFormat(List<Integer> prog) {
        Iterator<Integer> i = prog.iterator();
        if (!i.hasNext()) {
            throw new IndexOutOfBoundsException("BcompNG: \u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u043f\u0443\u0441\u0442\u0430: load_address");
        }
        this.load_address = i.next();
        if (!i.hasNext()) {
            throw new IndexOutOfBoundsException("BcompNG: \u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u043f\u0443\u0441\u0442\u0430: start_address");
        }
        this.start_address = i.next();
        if (prog.size() < 3) {
            throw new IndexOutOfBoundsException("BcompNG: \u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u043f\u0443\u0441\u0442\u0430: binary body");
        }
        this.binary = new LinkedList<Integer>();
        while (i.hasNext()) {
            this.binary.add(i.next());
        }
    }

    public String toBinaryRepresentation(int columns) {
        StringBuilder sb = new StringBuilder();
        int col = 8;
        if (columns >= 1) {
            col = columns;
        }
        int i = 1;
        for (Integer w : this.getBinaryFormat()) {
            sb.append(Integer.toHexString(w + 0x100000).substring(2)).append(' ');
            if (i++ % col != 0) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public String toBinaryRepresentation() {
        return this.toBinaryRepresentation(8);
    }

    public String toString() {
        return this.toBinaryRepresentation();
    }
}

