/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.assembler;

public enum Instruction {
    AND(8192, Type.ADDR),
    OR(12288, Type.ADDR),
    ADD(16384, Type.ADDR),
    ADC(20480, Type.ADDR),
    SUB(24576, Type.ADDR),
    CMP(28672, Type.ADDR),
    LOOP(32768, Type.ADDR),
    LD(40960, Type.ADDR),
    SWAM(45056, Type.ADDR),
    JUMP(49152, Type.ADDR),
    CALL(53248, Type.ADDR),
    ST(57344, Type.ADDR),
    NOP(0, Type.NONADDR),
    HLT(256, Type.NONADDR),
    CLA(512, Type.NONADDR),
    NOT(640, Type.NONADDR),
    CLC(768, Type.NONADDR),
    CMC(896, Type.NONADDR),
    ROL(1024, Type.NONADDR),
    ROR(1152, Type.NONADDR),
    ASL(1280, Type.NONADDR),
    ASR(1408, Type.NONADDR),
    SXTB(1536, Type.NONADDR),
    SWAB(1664, Type.NONADDR),
    INC(1792, Type.NONADDR),
    DEC(1856, Type.NONADDR),
    NEG(1920, Type.NONADDR),
    POP(2048, Type.NONADDR),
    POPF(2304, Type.NONADDR),
    RET(2560, Type.NONADDR),
    IRET(2816, Type.NONADDR),
    PUSH(3072, Type.NONADDR),
    PUSHF(3328, Type.NONADDR),
    SWAP(3584, Type.NONADDR),
    BEQ(61440, Type.BRANCH),
    BNE(61696, Type.BRANCH),
    BMI(61952, Type.BRANCH),
    BPL(62208, Type.BRANCH),
    BCS(62464, Type.BRANCH),
    BCC(62720, Type.BRANCH),
    BVS(62976, Type.BRANCH),
    BVC(63232, Type.BRANCH),
    BLT(63488, Type.BRANCH),
    BGE(63744, Type.BRANCH),
    BR(52736, Type.BRANCH),
    DI(4096, Type.NONADDR),
    EI(4352, Type.NONADDR),
    IN(4608, Type.IO),
    OUT(4864, Type.IO),
    INT(6144, Type.IO),
    END(1, Type.NONADDR);

    public static final Instruction[] values;
    public final int opcode;
    public final String mnemonic;
    public Type type;

    private Instruction(int opcode, Type type) {
        this.opcode = opcode;
        this.mnemonic = this.name();
        this.type = type;
    }

    public String getTypeString() {
        return this.type.name();
    }

    static {
        values = Instruction.values();
    }

    public static enum Type {
        ADDR,
        NONADDR,
        BRANCH,
        IO;

    }
}

