/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ru.ifmo.cs.bcomp.BasicComp;
import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.ui.components.ActivateblePanel;
import ru.ifmo.cs.bcomp.ui.components.AssemblerView;
import ru.ifmo.cs.bcomp.ui.components.BasicView;
import ru.ifmo.cs.bcomp.ui.components.ComponentManager;
import ru.ifmo.cs.bcomp.ui.components.DisplayStyles;

public class GUI
extends JApplet {
    private ComponentManager cmanager;
    private JTabbedPane tabs;
    private ActivateblePanel activePanel = null;
    private final BasicComp bcomp;
    private final CPU cpu;

    public GUI(BasicComp bcomp) {
        this.bcomp = bcomp;
        this.cpu = bcomp.getCPU();
    }

    @Override
    public void init() {
        this.cmanager = new ComponentManager(this);
        final ActivateblePanel[] panels = new ActivateblePanel[]{new BasicView(this), new AssemblerView(this)};
        this.tabs = new JTabbedPane();
        this.tabs.addKeyListener(this.cmanager.getKeyListener());
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (GUI.this.activePanel != null) {
                    GUI.this.activePanel.panelDeactivate();
                }
                GUI.this.activePanel = (ActivateblePanel)GUI.this.tabs.getSelectedComponent();
                GUI.this.activePanel.panelActivate();
            }
        });
        this.tabs.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                super.componentResized(componentEvent);
                for (ActivateblePanel panel : panels) {
                    panel.revalidate();
                    panel.repaint();
                    panel.redrawArrows();
                }
            }
        });
        for (ActivateblePanel pane : panels) {
            pane.setPreferredSize(DisplayStyles.PANE_SIZE);
            this.tabs.addTab(pane.getPanelName(), pane);
        }
        this.add(this.tabs);
    }

    @Override
    public void start() {
        this.cmanager.switchFocus();
    }

    public void gui() throws Exception {
        JFrame frame = new JFrame("\u0411\u042d\u0412\u041c v1.45.09");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(this);
        this.init();
        frame.pack();
        frame.setVisible(true);
        frame.setMinimumSize(frame.getSize());
        this.start();
    }

    public BasicComp getBasicComp() {
        return this.bcomp;
    }

    public CPU getCPU() {
        return this.cpu;
    }

    public IOCtrl[] getIOCtrls() {
        return this.bcomp.getIOCtrls();
    }

    public ComponentManager getComponentManager() {
        return this.cmanager;
    }
}

