/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui;

import ru.ifmo.cs.bcomp.BasicComp;
import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.MCDecoder;
import ru.ifmo.cs.bcomp.MicroCode;
import ru.ifmo.cs.bcomp.RunningCycle;

public class MicroCodeDecoder {
    private final CPU cpu;
    private final MicroCode mc;

    public MicroCodeDecoder(BasicComp bcomp) {
        this.cpu = bcomp.getCPU();
        this.mc = this.cpu.getMicroCodeSource();
        this.cpu.stopCPU();
    }

    public void decode() throws Exception {
        int infetch = this.mc.findLabel(RunningCycle.INFETCH.name());
        int reserved = this.mc.findLabel(RunningCycle.RESERVED.name());
        int addr = infetch;
        while (addr < reserved) {
            System.out.println(MCDecoder.getFormattedMC(this.cpu, addr++));
        }
    }
}

