/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.EnumMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.ifmo.cs.bcomp.BasicComp;
import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.ControlSignal;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.IOCtrlAdv;
import ru.ifmo.cs.bcomp.IOCtrlBasic;
import ru.ifmo.cs.bcomp.Reg;
import ru.ifmo.cs.bcomp.SignalListener;
import ru.ifmo.cs.bcomp.State;
import ru.ifmo.cs.bcomp.ui.io.Keyboard;
import ru.ifmo.cs.bcomp.ui.io.Numpad;
import ru.ifmo.cs.bcomp.ui.io.SevenSegmentDisplay;
import ru.ifmo.cs.bcomp.ui.io.TextPrinter;
import ru.ifmo.cs.bcomp.ui.io.Ticker;
import ru.ifmo.cs.components.DataDestination;
import ru.ifmo.cs.components.Register;

public class Nightmare {
    private static final Color LED_OFF = new Color(128, 128, 128);
    private static final Color LED_ON = new Color(0, 160, 0);
    private static final int BIT_RADIUS = 16;
    private static final Font LABEL_FONT = new Font("Courier New", 1, 24);
    private static final Font HINTS_FONT = new Font("Courier New", 1, 14);
    private final long[] delayPeriods = new long[]{0L, 1L, 5L, 10L, 25L, 50L, 100L, 1000L};
    private volatile int currentDelay = 3;
    private final BasicComp bcomp;
    private final CPU cpu;
    private final IOCtrl[] ioctrls;
    private EnumMap<Reg, RegisterView> regs = new EnumMap(Reg.class);
    private final SignalListener[] listeners;
    private BasicIOView io1 = null;
    private BasicIOView io2 = null;
    private BasicIOView io3 = null;
    private AdvIOView io4 = null;
    private TextPrinter textPrinter = null;
    private Ticker ticker = null;
    private SevenSegmentDisplay ssd = null;
    private Keyboard kbd = null;
    private Numpad numpad = null;

    public Nightmare(BasicComp bcomp) {
        this.bcomp = bcomp;
        this.cpu = bcomp.getCPU();
        this.ioctrls = bcomp.getIOCtrls();
        for (Reg reg : Reg.values()) {
            if (reg == Reg.MP || reg == Reg.MR) continue;
            this.regs.put(reg, new RegisterView(reg.toString(), this.cpu.getRegister(reg)));
        }
        this.listeners = new SignalListener[]{new SignalListener(this.regs.get((Object)Reg.DR), ControlSignal.WRDR, ControlSignal.LOAD), new SignalListener(this.regs.get((Object)Reg.CR), ControlSignal.WRCR, ControlSignal.INTS), new SignalListener(this.regs.get((Object)Reg.IP), ControlSignal.WRIP), new SignalListener(this.regs.get((Object)Reg.SP), ControlSignal.WRSP), new SignalListener(this.regs.get((Object)Reg.AC), ControlSignal.WRAC, ControlSignal.IO), new SignalListener(this.regs.get((Object)Reg.BR), ControlSignal.WRBR), new SignalListener(this.regs.get((Object)Reg.PS), ControlSignal.WRPS, ControlSignal.SETC, ControlSignal.SETV, ControlSignal.STNZ, ControlSignal.SET_EI, ControlSignal.HALT, ControlSignal.SET_PROGRAM, ControlSignal.SET_REQUEST_INTERRUPT), new SignalListener(this.regs.get((Object)Reg.AR), ControlSignal.WRAR)};
        bcomp.addDestination(this.listeners);
        this.cpu.setTickFinishListener(new Runnable(){

            @Override
            public void run() {
                if (Nightmare.this.delayPeriods[Nightmare.this.currentDelay] != 0L) {
                    try {
                        Thread.sleep(Nightmare.this.delayPeriods[Nightmare.this.currentDelay]);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        JFrame frame = new JFrame("\u0411\u042d\u0412\u041c");
        frame.setDefaultCloseOperation(3);
        JPanel panel = new JPanel(new GridLayout(10, 1));
        panel.add(this.regs.get((Object)Reg.DR));
        panel.add(this.regs.get((Object)Reg.CR));
        panel.add(this.regs.get((Object)Reg.IP));
        panel.add(this.regs.get((Object)Reg.SP));
        panel.add(this.regs.get((Object)Reg.AR));
        panel.add(this.regs.get((Object)Reg.AC));
        panel.add(this.regs.get((Object)Reg.BR));
        panel.add(this.regs.get((Object)Reg.PS));
        panel.add(this.regs.get((Object)Reg.IR));
        JLabel hints = new JLabel("F4 \u0412\u0432\u043e\u0434 \u0430\u0434\u0440\u0435\u0441\u0430 F5 \u0417\u0430\u043f\u0438\u0441\u044c F6 \u0427\u0442\u0435\u043d\u0438\u0435 F7 \u041f\u0443\u0441\u043a F8 \u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0435\u043d\u0438\u0435 F9 \u0420\u0430\u0431\u043e\u0442\u0430/\u041e\u0441\u0442\u0430\u043d\u043e\u0432 Shift-F9 \u0422\u0430\u043a\u0442");
        hints.setFont(HINTS_FONT);
        panel.add(hints);
        frame.add(panel);
        frame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isControlDown()) {
                    switch (e.getKeyCode()) {
                        case 81: {
                            System.exit(0);
                            break;
                        }
                        case 49: 
                        case 112: {
                            if (Nightmare.this.io1 == null) {
                                Nightmare.this.io1 = new BasicIOView(Nightmare.this.ioctrls, 1);
                            }
                            Nightmare.this.io1.activate();
                            break;
                        }
                        case 50: 
                        case 113: {
                            if (Nightmare.this.io2 == null) {
                                Nightmare.this.io2 = new BasicIOView(Nightmare.this.ioctrls, 2);
                            }
                            Nightmare.this.io2.activate();
                            break;
                        }
                        case 51: 
                        case 114: {
                            if (Nightmare.this.io3 == null) {
                                Nightmare.this.io3 = new BasicIOView(Nightmare.this.ioctrls, 3);
                            }
                            Nightmare.this.io3.activate();
                            break;
                        }
                        case 52: 
                        case 115: {
                            if (Nightmare.this.io4 == null) {
                                Nightmare.this.io4 = new AdvIOView(Nightmare.this.ioctrls, 4);
                            }
                            Nightmare.this.io4.activate();
                            break;
                        }
                        case 53: 
                        case 116: {
                            if (Nightmare.this.textPrinter == null) {
                                Nightmare.this.textPrinter = new TextPrinter(Nightmare.this.ioctrls[5]);
                            }
                            Nightmare.this.textPrinter.activate();
                            break;
                        }
                        case 54: 
                        case 117: {
                            if (Nightmare.this.ticker == null) {
                                Nightmare.this.ticker = new Ticker(Nightmare.this.ioctrls[6]);
                            }
                            Nightmare.this.ticker.activate();
                            break;
                        }
                        case 55: 
                        case 118: {
                            if (Nightmare.this.ssd == null) {
                                Nightmare.this.ssd = new SevenSegmentDisplay(Nightmare.this.ioctrls[7]);
                            }
                            Nightmare.this.ssd.activate();
                            break;
                        }
                        case 56: 
                        case 119: {
                            if (Nightmare.this.kbd == null) {
                                Nightmare.this.kbd = new Keyboard(Nightmare.this.ioctrls[8]);
                            }
                            Nightmare.this.kbd.activate();
                            break;
                        }
                        case 57: 
                        case 120: {
                            if (Nightmare.this.numpad == null) {
                                Nightmare.this.numpad = new Numpad(Nightmare.this.ioctrls[9]);
                            }
                            Nightmare.this.numpad.activate();
                        }
                    }
                    return;
                }
                if (e.isShiftDown()) {
                    switch (e.getKeyCode()) {
                        case 120: {
                            Nightmare.this.cpu.invertClockState();
                        }
                    }
                    return;
                }
                switch (e.getKeyCode()) {
                    case 48: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(0);
                        break;
                    }
                    case 49: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(1);
                        break;
                    }
                    case 50: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(2);
                        break;
                    }
                    case 51: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(3);
                        break;
                    }
                    case 52: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(4);
                        break;
                    }
                    case 53: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(5);
                        break;
                    }
                    case 54: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(6);
                        break;
                    }
                    case 55: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(7);
                        break;
                    }
                    case 56: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(8);
                        break;
                    }
                    case 57: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(9);
                        break;
                    }
                    case 65: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(10);
                        break;
                    }
                    case 66: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(11);
                        break;
                    }
                    case 67: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(12);
                        break;
                    }
                    case 68: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(13);
                        break;
                    }
                    case 69: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(14);
                        break;
                    }
                    case 70: {
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.IR)).invertBit(15);
                        break;
                    }
                    case 115: {
                        Nightmare.this.cpu.startSetAddr();
                        break;
                    }
                    case 116: {
                        Nightmare.this.cpu.startWrite();
                        break;
                    }
                    case 117: {
                        Nightmare.this.cpu.startRead();
                        break;
                    }
                    case 118: {
                        Nightmare.this.cpu.startStart();
                        break;
                    }
                    case 119: {
                        Nightmare.this.cpu.startContinue();
                        break;
                    }
                    case 120: {
                        Nightmare.this.cpu.invertRunState();
                        ((RegisterView)Nightmare.this.regs.get((Object)Reg.PS)).bits[State.W.ordinal()].repaint();
                        break;
                    }
                    case 122: {
                        Nightmare.this.currentDelay = (Nightmare.this.currentDelay > 0 ? Nightmare.this.currentDelay : Nightmare.this.delayPeriods.length) - 1;
                        break;
                    }
                    case 123: {
                        Nightmare.this.currentDelay = Nightmare.this.currentDelay < Nightmare.this.delayPeriods.length - 1 ? Nightmare.this.currentDelay + 1 : 0;
                    }
                }
            }
        });
        frame.pack();
        frame.setVisible(true);
        frame.requestFocus();
    }

    private class AdvIOView {
        private final String[] REGNAMES = new String[]{"DR#0", "DR#1", "State", "Mgmt"};
        private final IOCtrlAdv ioctrl;
        private final JFrame frame;
        private final RegisterView[] regview;
        private final int COUNT;
        private volatile int active = 0;

        private AdvIOView(IOCtrl[] ioctrls, int number) {
            this.ioctrl = (IOCtrlAdv)ioctrls[number];
            Register[] registers = this.ioctrl.getRegisters();
            this.COUNT = registers.length;
            this.regview = new RegisterView[this.COUNT];
            JPanel panel = new JPanel(new GridLayout(this.COUNT, 1));
            for (int i = 0; i < this.COUNT; ++i) {
                this.regview[i] = new RegisterView(this.REGNAMES[i], registers[i]);
                this.regview[i].label.setForeground(i == this.active ? LED_ON : LED_OFF);
                panel.add(this.regview[i]);
                this.ioctrl.addDestination(i, this.regview[i]);
            }
            this.frame = new JFrame("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440 \u0412\u0423" + number);
            this.frame.setFocusTraversalKeys(0, Collections.EMPTY_SET);
            this.frame.setFocusTraversalKeys(1, Collections.EMPTY_SET);
            this.frame.add(panel);
            this.frame.pack();
            this.frame.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 9: {
                            AdvIOView.this.regview[AdvIOView.this.active].label.setForeground(LED_OFF);
                            AdvIOView.this.regview[AdvIOView.this.active = (AdvIOView.this.active + (e.isShiftDown() ? AdvIOView.this.COUNT - 1 : 1)) % AdvIOView.this.COUNT].label.setForeground(LED_ON);
                            break;
                        }
                        case 48: {
                            AdvIOView.this.invertBit(0);
                            break;
                        }
                        case 49: {
                            AdvIOView.this.invertBit(1);
                            break;
                        }
                        case 50: {
                            AdvIOView.this.invertBit(2);
                            break;
                        }
                        case 51: {
                            AdvIOView.this.invertBit(3);
                            break;
                        }
                        case 52: {
                            AdvIOView.this.invertBit(4);
                            break;
                        }
                        case 53: {
                            AdvIOView.this.invertBit(5);
                            break;
                        }
                        case 54: {
                            AdvIOView.this.invertBit(6);
                            break;
                        }
                        case 55: {
                            AdvIOView.this.invertBit(7);
                        }
                    }
                }
            });
        }

        private void invertBit(int startbit) {
            this.regview[this.active].invertBit(startbit);
            this.ioctrl.updateStateIRQ();
        }

        private void activate() {
            this.frame.setVisible(true);
            this.frame.requestFocus();
        }
    }

    private class BasicIOView {
        private final IOCtrlBasic ioctrl;
        private final JFrame frame;
        private final RegisterView data;
        private final RegisterView flag;
        private final RegisterView irq;

        private BasicIOView(IOCtrl[] ioctrls, int number) {
            this.ioctrl = (IOCtrlBasic)ioctrls[number];
            this.data = new RegisterView("DR", this.ioctrl.getRegisters()[0]);
            this.flag = new RegisterView("SR", this.ioctrl.getRegisters()[1]);
            this.irq = new RegisterView("IRQ", this.ioctrl.getRegisters()[2]);
            this.ioctrl.addDestination(0, this.data);
            this.ioctrl.addDestination(1, this.flag);
            this.ioctrl.addDestination(2, this.irq);
            JPanel panel = new JPanel(new FlowLayout(2, 0, 0));
            panel.add(this.irq);
            panel.add(this.flag);
            panel.add(this.data);
            this.frame = new JFrame("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440 \u0412\u0423" + number);
            this.frame.add(panel);
            this.frame.pack();
            this.frame.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 70: 
                        case 82: 
                        case 112: 
                        case 113: 
                        case 114: {
                            BasicIOView.this.ioctrl.setReady();
                            break;
                        }
                        case 48: {
                            BasicIOView.this.invertBit(0);
                            break;
                        }
                        case 49: {
                            BasicIOView.this.invertBit(1);
                            break;
                        }
                        case 50: {
                            BasicIOView.this.invertBit(2);
                            break;
                        }
                        case 51: {
                            BasicIOView.this.invertBit(3);
                            break;
                        }
                        case 52: {
                            BasicIOView.this.invertBit(4);
                            break;
                        }
                        case 53: {
                            BasicIOView.this.invertBit(5);
                            break;
                        }
                        case 54: {
                            BasicIOView.this.invertBit(6);
                            break;
                        }
                        case 55: {
                            BasicIOView.this.invertBit(7);
                        }
                    }
                }
            });
        }

        private void invertBit(int startbit) {
            this.data.invertBit(startbit);
        }

        private void activate() {
            this.frame.setVisible(true);
            this.frame.requestFocus();
        }
    }

    private class RegisterView
    extends JPanel
    implements DataDestination {
        private final JLabel label;
        private final Register reg;
        private final BitView[] bits;

        private RegisterView(String name, Register reg) {
            super(new FlowLayout(2, 0, 0));
            this.reg = reg;
            this.label = new JLabel(name);
            this.label.setFont(LABEL_FONT);
            this.add(this.label);
            this.bits = new BitView[(int)reg.width];
            for (long i = reg.width - 1L; i >= 0L; --i) {
                BitView bitView = new BitView(reg, (int)i);
                this.bits[(int)i] = bitView;
                this.add(bitView);
            }
        }

        @Override
        public void setValue(long value) {
            int i = 0;
            while ((long)i < this.reg.width) {
                this.bits[i++].repaint();
            }
        }

        private void invertBit(int startbit) {
            this.reg.invertBit(startbit);
            this.bits[startbit].repaint();
        }
    }

    private class BitView
    extends JComponent {
        private final Register reg;
        private final int startbit;

        protected BitView(Register reg, int startbit) {
            this.reg = reg;
            this.startbit = startbit;
            Dimension DIMS = new Dimension(36, 36);
            this.setMinimumSize(DIMS);
            this.setMaximumSize(DIMS);
            this.setPreferredSize(DIMS);
            this.setSize(DIMS);
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(this.reg.getValue(this.startbit) == 1L ? LED_ON : LED_OFF);
            g.fillOval(2, 2, 32, 32);
        }
    }
}

