/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.JToggleButton;
import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.ControlSignal;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.Reg;
import ru.ifmo.cs.bcomp.SignalListener;
import ru.ifmo.cs.bcomp.State;
import ru.ifmo.cs.bcomp.ui.GUI;
import ru.ifmo.cs.bcomp.ui.components.ALUView;
import ru.ifmo.cs.bcomp.ui.components.BCompPanel;
import ru.ifmo.cs.bcomp.ui.components.BusNames;
import ru.ifmo.cs.bcomp.ui.components.BusView;
import ru.ifmo.cs.bcomp.ui.components.CommutView;
import ru.ifmo.cs.bcomp.ui.components.DisplayStyles;
import ru.ifmo.cs.bcomp.ui.components.RegisterProperties;
import ru.ifmo.cs.bcomp.ui.components.RegisterView;
import ru.ifmo.cs.bcomp.ui.components.RunningCycleView;
import ru.ifmo.cs.bcomp.ui.io.FirstIO;
import ru.ifmo.cs.bcomp.ui.io.IODevice;
import ru.ifmo.cs.bcomp.ui.io.Keyboard;
import ru.ifmo.cs.bcomp.ui.io.Numpad;
import ru.ifmo.cs.bcomp.ui.io.SecondIO;
import ru.ifmo.cs.bcomp.ui.io.SevenSegmentDisplay;
import ru.ifmo.cs.bcomp.ui.io.TextPrinter;
import ru.ifmo.cs.bcomp.ui.io.ThirdIO;
import ru.ifmo.cs.bcomp.ui.io.Ticker;
import ru.ifmo.cs.components.DataDestination;

public class BasicView
extends BCompPanel {
    private final CPU cpu;
    private final RunningCycleView cycleview;
    private final ALUView alu;
    private final CommutView commutView;
    private IOCtrl[] ioctrls;
    private FirstIO firstIO;
    private SecondIO secondIO;
    private TextPrinter textPrinter = null;
    private Ticker ticker = null;
    private SevenSegmentDisplay ssd = null;
    private Keyboard kbd = null;
    private Numpad numpad = null;
    private ThirdIO thirdIO;
    private JToggleButton[] ioButtons = new JToggleButton[9];
    private ItemListener[] actionListeners = new ItemListener[]{new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            switch (e.getStateChange()) {
                case 1: {
                    if (BasicView.this.firstIO == null) {
                        BasicView.this.firstIO = new FirstIO(BasicView.this.ioctrls[1]);
                        BasicView.this.activateAndAddListener(BasicView.this.firstIO, 0);
                        break;
                    }
                    BasicView.this.firstIO.activate();
                    break;
                }
                case 2: {
                    BasicView.this.firstIO.getFrame().setVisible(false);
                }
            }
        }
    }, new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            switch (e.getStateChange()) {
                case 1: {
                    if (BasicView.this.secondIO == null) {
                        BasicView.this.secondIO = new SecondIO(BasicView.this.ioctrls[2], BasicView.this.cmanager);
                        BasicView.this.activateAndAddListener(BasicView.this.secondIO, 1);
                        break;
                    }
                    BasicView.this.secondIO.activate();
                    break;
                }
                case 2: {
                    BasicView.this.secondIO.getFrame().setVisible(false);
                }
            }
        }
    }, new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            switch (e.getStateChange()) {
                case 1: {
                    if (BasicView.this.thirdIO == null) {
                        BasicView.this.thirdIO = new ThirdIO(BasicView.this.ioctrls[3]);
                        BasicView.this.activateAndAddListener(BasicView.this.thirdIO, 2);
                        break;
                    }
                    BasicView.this.thirdIO.activate();
                    break;
                }
                case 2: {
                    BasicView.this.thirdIO.getFrame().setVisible(false);
                }
            }
        }
    }, null, new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            switch (e.getStateChange()) {
                case 1: {
                    if (BasicView.this.textPrinter == null) {
                        BasicView.this.textPrinter = new TextPrinter(BasicView.this.ioctrls[5]);
                        BasicView.this.activateAndAddListener(BasicView.this.textPrinter, 4);
                        break;
                    }
                    BasicView.this.textPrinter.activate();
                    break;
                }
                case 2: {
                    BasicView.this.textPrinter.getFrame().setVisible(false);
                }
            }
        }
    }, new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            switch (e.getStateChange()) {
                case 1: {
                    if (BasicView.this.ticker == null) {
                        BasicView.this.ticker = new Ticker(BasicView.this.ioctrls[6]);
                        BasicView.this.activateAndAddListener(BasicView.this.ticker, 5);
                        break;
                    }
                    BasicView.this.ticker.activate();
                    break;
                }
                case 2: {
                    BasicView.this.ticker.getFrame().setVisible(false);
                }
            }
        }
    }, new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            switch (e.getStateChange()) {
                case 1: {
                    if (BasicView.this.ssd == null) {
                        BasicView.this.ssd = new SevenSegmentDisplay(BasicView.this.ioctrls[7]);
                        BasicView.this.activateAndAddListener(BasicView.this.ssd, 6);
                        break;
                    }
                    BasicView.this.ssd.activate();
                    break;
                }
                case 2: {
                    BasicView.this.ssd.getFrame().setVisible(false);
                }
            }
        }
    }, new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            switch (e.getStateChange()) {
                case 1: {
                    if (BasicView.this.kbd == null) {
                        BasicView.this.kbd = new Keyboard(BasicView.this.ioctrls[8]);
                        BasicView.this.activateAndAddListener(BasicView.this.kbd, 7);
                        break;
                    }
                    BasicView.this.kbd.activate();
                    break;
                }
                case 2: {
                    BasicView.this.kbd.getFrame().setVisible(false);
                }
            }
        }
    }, new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            switch (e.getStateChange()) {
                case 1: {
                    if (BasicView.this.numpad == null) {
                        BasicView.this.numpad = new Numpad(BasicView.this.ioctrls[9]);
                        BasicView.this.activateAndAddListener(BasicView.this.numpad, 8);
                        break;
                    }
                    BasicView.this.numpad.activate();
                    break;
                }
                case 2: {
                    BasicView.this.numpad.getFrame().setVisible(false);
                }
            }
        }
    }};

    public BasicView(GUI gui) {
        super(gui.getComponentManager(), new RegisterProperties[]{new RegisterProperties(Reg.AR, DisplayStyles.REG_ACCUM_X_BV, 168, false, false, new GridBagConstraints(){
            {
                this.fill = 0;
                this.gridy = 5;
                this.gridx = 5;
                this.weightx = 0.0;
                this.weighty = 0.0;
                this.gridwidth = 1;
                this.gridheight = 1;
                this.anchor = 18;
                this.insets = new Insets(156, 0, 0, 0);
            }
        }), new RegisterProperties(Reg.DR, DisplayStyles.REG_ACCUM_X_BV, 212, false, false, new GridBagConstraints(){
            {
                this.fill = 0;
                this.gridy = 1;
                this.gridx = 4;
                this.weightx = 0.5;
                this.weighty = 0.5;
                this.insets = new Insets(60, 40, 0, 0);
            }
        }), new RegisterProperties(Reg.IP, DisplayStyles.REG_IP_X_BV, 256, false, false, new GridBagConstraints(){
            {
                this.fill = 0;
                this.gridy = 3;
                this.gridx = 4;
                this.weightx = 0.5;
                this.weighty = 0.5;
                this.insets = new Insets(0, 0, 0, 33);
            }
        }), new RegisterProperties(Reg.CR, DisplayStyles.REG_INSTR_X_BV, 168, false, false, new GridBagConstraints(){
            {
                this.fill = 0;
                this.gridy = 2;
                this.gridx = 4;
                this.weightx = 0.5;
                this.weighty = 0.5;
                this.insets = new Insets(0, 40, 0, 0);
            }
        }), new RegisterProperties(Reg.AC, DisplayStyles.REG_ACCUM_X_BV, 442, false, true, new GridBagConstraints(){
            {
                this.fill = 0;
                this.gridy = 1;
                this.gridx = 3;
                this.weighty = 0.5;
                this.weightx = 0.5;
                this.insets = new Insets(60, 23, 0, 60);
            }
        }), new RegisterProperties(Reg.SP, DisplayStyles.REG_ACCUM_X_BV, 0, false, false, new GridBagConstraints(){
            {
                this.fill = 0;
                this.gridy = 4;
                this.gridx = 4;
                this.weighty = 0.5;
                this.insets = new Insets(0, 0, 80, 33);
            }
        }), new RegisterProperties(Reg.BR, 0, 0, false, true, new GridBagConstraints(){
            {
                this.gridy = 2;
                this.gridx = 3;
                this.insets = new Insets(0, 3, 0, 40);
            }
        }), new RegisterProperties(Reg.PS, 0, 0, false, true, new GridBagConstraints(){
            {
                this.gridy = 3;
                this.gridx = 3;
                this.insets = new Insets(0, 3, 0, 40 - DisplayStyles.REG_16_WIDTH + DisplayStyles.REG_9_WIDTH);
            }
        }), new RegisterProperties(Reg.IR, 0, 0, false, true, new GridBagConstraints(){
            {
                this.gridy = 4;
                this.gridx = 3;
                this.insets = new Insets(0, 3, 80, 40);
            }
        })}, (Map<BusNames, BusView>)new EnumMap<BusNames, BusView>(BusNames.class){
            {
                this.put(BusNames.BR_ALU, new BusView(ControlSignal.RDBR));
                this.put(BusNames.COMM_BR, new BusView(ControlSignal.WRBR));
                this.put(BusNames.PS_ALU, new BusView(ControlSignal.RDPS));
                this.put(BusNames.COMM_PS, new BusView(ControlSignal.WRPS));
                this.put(BusNames.COMM_ALL, new BusView(ControlSignal.WRBR, ControlSignal.WRAC, ControlSignal.WRIP, ControlSignal.WRCR, ControlSignal.WRDR, ControlSignal.WRAR, ControlSignal.WRPS, ControlSignal.WRSP));
                this.put(BusNames.ALU_COMM, new BusView(ControlSignal.WRBR, ControlSignal.WRAC, ControlSignal.WRIP, ControlSignal.WRCR, ControlSignal.WRDR, ControlSignal.WRAR, ControlSignal.WRPS, ControlSignal.WRSP, ControlSignal.TYPE));
                this.put(BusNames.DR_ALU, new BusView(ControlSignal.RDDR));
                this.put(BusNames.CR_ALU, new BusView(ControlSignal.RDCR));
                this.put(BusNames.IP_ALU, new BusView(ControlSignal.RDIP));
                this.put(BusNames.SP_ALU, new BusView(ControlSignal.RDSP));
                this.put(BusNames.AC_ALU, new BusView(ControlSignal.RDAC));
                this.put(BusNames.IR_ALU, new BusView(ControlSignal.RDIR));
                this.put(BusNames.COMM_AR, new BusView(ControlSignal.WRAR));
                this.put(BusNames.COMM_DR, new BusView(ControlSignal.WRDR));
                this.put(BusNames.COMM_CR, new BusView(ControlSignal.WRCR));
                this.put(BusNames.COMM_IP, new BusView(ControlSignal.WRIP));
                this.put(BusNames.COMM_SP, new BusView(ControlSignal.WRSP));
                this.put(BusNames.COMM_AC, new BusView(ControlSignal.WRAC));
                this.put(BusNames.MEM_IO, new BusView(ControlSignal.LOAD, ControlSignal.STOR));
                this.put(BusNames.MEM_R, new BusView(ControlSignal.LOAD));
                this.put(BusNames.MEM_W, new BusView(ControlSignal.STOR));
                this.put(BusNames.CU, new BusView(ControlSignal.TYPE));
            }
        });
        this.cpu = gui.getCPU();
        this.ioctrls = gui.getIOCtrls();
        this.add((Component)this.regPanel, "Center");
        this.setSignalListeners(new SignalListener[]{new SignalListener(new DataDestination(){

            @Override
            public void setValue(long value) {
                BasicView.this.cycleview.updateProg(BasicView.this.cpu.getProgramState(State.P) == 1L);
            }
        }, ControlSignal.HALT, ControlSignal.SET_PROGRAM)});
        GridBagConstraints constraintsALU = new GridBagConstraints(){
            {
                this.gridx = 3;
                this.gridy = 5;
                this.gridwidth = 2;
                this.weightx = 0.5;
                this.weighty = 0.5;
                this.anchor = 11;
                this.insets = new Insets(0, 30, 100, 0);
            }
        };
        this.alu = new ALUView(DisplayStyles.REG_C_X_BV, 321, 181, 80);
        this.alu.setPreferredSize(this.alu.getSize());
        this.regPanel.add((Component)this.alu, constraintsALU);
        GridBagConstraints constraintsComm = new GridBagConstraints(){
            {
                this.gridx = 3;
                this.gridy = 5;
                this.gridwidth = 2;
                this.weightx = 0.5;
                this.weighty = 0.5;
                this.anchor = 11;
                this.insets = new Insets(97, 30, 0, 0);
            }
        };
        this.commutView = new CommutView(0, 0, 150, 30);
        this.commutView.setPreferredSize(this.commutView.getSize());
        this.regPanel.add((Component)this.commutView, constraintsComm);
        GridBagConstraints constraintsCycle = new GridBagConstraints(){
            {
                this.gridx = 4;
                this.gridy = 4;
                this.gridheight = 2;
                this.anchor = 10;
                this.insets = new Insets(0, 90, 0, 0);
            }
        };
        this.cycleview = new RunningCycleView(this.cpu, DisplayStyles.REG_INSTR_X_BV, 321);
        this.cycleview.setPreferredSize(this.cycleview.getSize());
        this.regPanel.add((Component)this.cycleview, constraintsCycle);
        GridBagConstraints constraintMem = new GridBagConstraints(){
            {
                this.gridx = 5;
                this.gridy = 1;
                this.gridheight = 5;
                this.weighty = 0.0;
                this.anchor = 17;
                this.insets = new Insets(0, 40, 60, 0);
            }
        };
        this.regPanel.add((Component)this.cmanager.getMem(), constraintMem);
        GridBagConstraints constraintsF = new GridBagConstraints(){
            {
                this.fill = 0;
                this.gridy = 5;
                this.gridx = 3;
                this.gridwidth = 2;
                this.weightx = 0.5;
                this.weighty = 0.0;
                this.anchor = 11;
                this.insets = new Insets(126, 0, 0, 20);
            }
        };
        this.regPanel.add((Component)this.cmanager.getFlagView(1), constraintsF);
        constraintsF.insets.right += 60;
        this.regPanel.add((Component)this.cmanager.getFlagView(0), constraintsF);
        constraintsF.insets.right = 0;
        constraintsF.insets.left = 140;
        this.regPanel.add((Component)this.cmanager.getFlagView(3), constraintsF);
        constraintsF.insets = new Insets(126, 80, 0, 0);
        this.regPanel.add((Component)this.cmanager.getFlagView(2), constraintsF);
        GridBagConstraints constraintsButton = new GridBagConstraints(){
            {
                this.fill = 0;
                this.gridy = 0;
                this.gridx = 0;
                this.insets = new Insets(0, 0, 50, 0);
            }
        };
        GridBagConstraints constraintsButtonPanel = new GridBagConstraints(){
            {
                this.fill = 0;
                this.gridy = 0;
                this.gridx = 0;
                this.gridheight = 2;
                this.gridwidth = 5;
                this.insets = new Insets(30, 0, 0, 50);
            }
        };
        BCompPanel.RegPanel buttonsPanel = new BCompPanel.RegPanel(this);
        for (int i = 1; i < 10; ++i) {
            this.ioButtons[i - 1] = new JToggleButton(this.cmanager.getRes().getString("DEV-" + i));
            this.ioButtons[i - 1].setFont(DisplayStyles.FONT_COURIER_PLAIN_12);
            this.ioButtons[i - 1].setFocusable(false);
            this.ioButtons[i - 1].addItemListener(this.actionListeners[i - 1]);
            buttonsPanel.add((Component)this.ioButtons[i - 1], constraintsButton);
            ++constraintsButton.gridx;
        }
        this.regPanel.add((Component)buttonsPanel, constraintsButtonPanel);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                BasicView.this.redrawArrows();
            }
        });
        this.redrawArrows();
    }

    @Override
    public void stepStart() {
        this.cycleview.update();
        super.stepStart();
    }

    @Override
    public String getPanelName() {
        return this.cmanager.getRes().getString("basename");
    }

    @Override
    public void stepFinish() {
        super.stepFinish();
    }

    @Override
    public void redrawArrows() {
        for (BusNames key : this.busesMap.keySet()) {
            BusView bus = (BusView)this.busesMap.get((Object)key);
            RegisterView data = this.cmanager.getRegisterView(Reg.DR);
            RegisterView addr = this.cmanager.getRegisterView(Reg.AR);
            RegisterView instr = this.cmanager.getRegisterView(Reg.CR);
            RegisterView accum = this.cmanager.getRegisterView(Reg.AC);
            RegisterView irReg = this.cmanager.getRegisterView(Reg.IR);
            RegisterView ipReg = this.cmanager.getRegisterView(Reg.IP);
            RegisterView spReg = this.cmanager.getRegisterView(Reg.SP);
            RegisterView buf = this.cmanager.getRegisterView(Reg.BR);
            RegisterView rs = this.cmanager.getRegisterView(Reg.PS);
            int regPanelX = this.regPanel.getX();
            int aluX = this.alu.getX();
            int aluY = this.alu.getY();
            int commY = this.commutView.getY();
            int accumX = accum.getX();
            switch (key) {
                case DR_ALU: {
                    bus.calcBounds(new int[][]{{regPanelX + data.getX() - 5, data.getY() + 14}, {regPanelX + aluX + 135, data.getY() + 14}, {regPanelX + aluX + 135, aluY - 13}});
                    break;
                }
                case CR_ALU: {
                    bus.calcBounds(new int[][]{{regPanelX + instr.getX() - 5, instr.getY() + 14}, {regPanelX + aluX + 135, instr.getY() + 14}, {regPanelX + aluX + 135, aluY - 13}});
                    break;
                }
                case IP_ALU: {
                    bus.calcBounds(new int[][]{{regPanelX + ipReg.getX() - 5, ipReg.getY() + 14}, {regPanelX + aluX + 135, ipReg.getY() + 14}, {regPanelX + aluX + 135, aluY - 13}});
                    break;
                }
                case SP_ALU: {
                    bus.calcBounds(new int[][]{{regPanelX + spReg.getX() - 5, spReg.getY() + 14}, {regPanelX + aluX + 135, spReg.getY() + 14}, {regPanelX + aluX + 135, aluY - 13}});
                    break;
                }
                case AC_ALU: {
                    bus.calcBounds(new int[][]{{regPanelX + accumX + DisplayStyles.REG_16_WIDTH - 6, accum.getY() + 14}, {regPanelX + aluX + 45, accum.getY() + 14}, {regPanelX + aluX + 45, aluY - 13}});
                    break;
                }
                case BR_ALU: {
                    bus.calcBounds(new int[][]{{regPanelX + buf.getX() + DisplayStyles.REG_16_WIDTH - 6, buf.getY() + 14}, {regPanelX + aluX + 45, buf.getY() + 14}, {regPanelX + aluX + 45, aluY - 13}});
                    break;
                }
                case PS_ALU: {
                    bus.calcBounds(new int[][]{{regPanelX + rs.getX() + DisplayStyles.REG_9_WIDTH - 6, rs.getY() + 14}, {regPanelX + aluX + 45, rs.getY() + 14}, {regPanelX + aluX + 45, aluY - 13}});
                    break;
                }
                case IR_ALU: {
                    bus.calcBounds(new int[][]{{regPanelX + irReg.getX() + DisplayStyles.REG_16_WIDTH - 6, irReg.getY() + 14}, {regPanelX + aluX + 45, irReg.getY() + 14}, {regPanelX + aluX + 45, aluY - 13}});
                    break;
                }
                case COMM_AR: {
                    bus.calcBounds(new int[][]{{regPanelX + aluX + 90, commY + this.commutView.getHeight() + 4}, {regPanelX + aluX + 90, addr.getY() + 14}, {addr.getX() - 13, addr.getY() + 14}});
                    break;
                }
                case COMM_DR: {
                    bus.calcBounds(new int[][]{{regPanelX + aluX + 90, commY + this.commutView.getHeight() + 4}, {regPanelX + aluX + 90, aluY + 80 + 90}, {regPanelX + data.getX() + DisplayStyles.REG_16_WIDTH + 10, aluY + 80 + 90}, {regPanelX + data.getX() + DisplayStyles.REG_16_WIDTH + 10, data.getY() + 14}, {regPanelX + data.getX() + DisplayStyles.REG_16_WIDTH + 3, data.getY() + 14}});
                    break;
                }
                case COMM_CR: {
                    bus.calcBounds(new int[][]{{regPanelX + aluX + 90, commY + this.commutView.getHeight() + 4}, {regPanelX + aluX + 90, aluY + 80 + 90}, {regPanelX + instr.getX() + DisplayStyles.REG_16_WIDTH + 10, aluY + 80 + 90}, {regPanelX + instr.getX() + DisplayStyles.REG_16_WIDTH + 10, instr.getY() + 14}, {regPanelX + instr.getX() + DisplayStyles.REG_16_WIDTH + 3, instr.getY() + 14}});
                    break;
                }
                case COMM_IP: {
                    bus.calcBounds(new int[][]{{regPanelX + aluX + 90, commY + this.commutView.getHeight() + 4}, {regPanelX + aluX + 90, aluY + 80 + 90}, {regPanelX + instr.getX() + DisplayStyles.REG_16_WIDTH + 10, aluY + 80 + 90}, {regPanelX + instr.getX() + DisplayStyles.REG_16_WIDTH + 10, ipReg.getY() + 14}, {regPanelX + ipReg.getX() + DisplayStyles.REG_11_WIDTH + 3, ipReg.getY() + 14}});
                    break;
                }
                case COMM_SP: {
                    bus.calcBounds(new int[][]{{regPanelX + aluX + 90, commY + this.commutView.getHeight() + 4}, {regPanelX + aluX + 90, aluY + 80 + 90}, {regPanelX + instr.getX() + DisplayStyles.REG_16_WIDTH + 10, aluY + 80 + 90}, {regPanelX + instr.getX() + DisplayStyles.REG_16_WIDTH + 10, spReg.getY() + 14}, {regPanelX + spReg.getX() + DisplayStyles.REG_11_WIDTH + 3, spReg.getY() + 14}});
                    break;
                }
                case COMM_ALL: {
                    bus.calcBounds(new int[][]{{regPanelX + aluX + 90, commY + this.commutView.getHeight() + 4}, {regPanelX + aluX + 90, aluY + 80 + 74}});
                    break;
                }
                case COMM_AC: {
                    bus.calcBounds(new int[][]{{regPanelX + aluX + 90, commY + this.commutView.getHeight() + 4}, {regPanelX + aluX + 90, aluY + 80 + 90}, {regPanelX + accumX - 20, aluY + 80 + 90}, {regPanelX + accumX - 20, accum.getY() + 14}, {regPanelX + accumX - 13, accum.getY() + 14}});
                    break;
                }
                case ALU_COMM: {
                    bus.calcBounds(new int[][]{{regPanelX + aluX + 90, aluY + 80 + 4}, {regPanelX + aluX + 90, commY - 13}});
                    break;
                }
                case COMM_BR: {
                    bus.calcBounds(new int[][]{{regPanelX + aluX + 90, commY + this.commutView.getHeight() + 4}, {regPanelX + aluX + 90, aluY + 80 + 90}, {regPanelX + accumX - 20, aluY + 80 + 90}, {regPanelX + accumX - 20, buf.getY() + 14}, {regPanelX + accumX - 13, buf.getY() + 14}});
                    break;
                }
                case COMM_PS: {
                    bus.calcBounds(new int[][]{{regPanelX + aluX + 90, commY + this.commutView.getHeight() + 4}, {regPanelX + aluX + 90, aluY + 80 + 90}, {regPanelX + accumX - 20, aluY + 80 + 90}, {regPanelX + accumX - 20, rs.getY() + 14}, {regPanelX + rs.getX() - 13, rs.getY() + 14}});
                    break;
                }
                case MEM_IO: {
                    bus.calcBounds(new int[][]{{regPanelX + this.cmanager.getMem().getX() + DisplayStyles.MEM_WIDTH / 4, addr.getY() - 5}, {regPanelX + this.cmanager.getMem().getX() + DisplayStyles.MEM_WIDTH / 4, this.cmanager.getMem().getY() + 425 + 15}});
                    break;
                }
                case MEM_R: {
                    int[][] nArrayArray;
                    if (this.cmanager.getMem().getY() < 45) {
                        int[][] nArrayArray2 = new int[3][];
                        nArrayArray2[0] = new int[]{regPanelX + this.cmanager.getMem().getX() - 5, this.cmanager.getMem().getY() + 10};
                        nArrayArray2[1] = new int[]{regPanelX + data.getX() + 3 * DisplayStyles.REG_16_WIDTH / 4 - 10, this.cmanager.getMem().getY() + 10};
                        nArrayArray = nArrayArray2;
                        nArrayArray2[2] = new int[]{regPanelX + data.getX() + 3 * DisplayStyles.REG_16_WIDTH / 4 - 10, data.getY() - 13};
                    } else {
                        int[][] nArrayArray3 = new int[4][];
                        nArrayArray3[0] = new int[]{regPanelX + this.cmanager.getMem().getX() + DisplayStyles.MEM_WIDTH / 2 + 10, this.cmanager.getMem().getY() - 5};
                        nArrayArray3[1] = new int[]{regPanelX + this.cmanager.getMem().getX() + DisplayStyles.MEM_WIDTH / 2 + 10, data.getY() - 65};
                        nArrayArray3[2] = new int[]{regPanelX + data.getX() + 3 * DisplayStyles.REG_16_WIDTH / 4 - 10, data.getY() - 65};
                        nArrayArray = nArrayArray3;
                        nArrayArray3[3] = new int[]{regPanelX + data.getX() + 3 * DisplayStyles.REG_16_WIDTH / 4 - 10, data.getY() - 13};
                    }
                    bus.calcBounds(nArrayArray);
                    break;
                }
                case MEM_W: {
                    int[][] nArrayArray;
                    if (this.cmanager.getMem().getY() < 45) {
                        int[][] nArrayArray4 = new int[3][];
                        nArrayArray4[0] = new int[]{regPanelX + data.getX() + 3 * DisplayStyles.REG_16_WIDTH / 4 + 10, data.getY() - 5};
                        nArrayArray4[1] = new int[]{regPanelX + data.getX() + 3 * DisplayStyles.REG_16_WIDTH / 4 + 10, this.cmanager.getMem().getY() + 25};
                        nArrayArray = nArrayArray4;
                        nArrayArray4[2] = new int[]{regPanelX + this.cmanager.getMem().getX() - 13, this.cmanager.getMem().getY() + 25};
                    } else {
                        int[][] nArrayArray5 = new int[4][];
                        nArrayArray5[0] = new int[]{regPanelX + data.getX() + 3 * DisplayStyles.REG_16_WIDTH / 4 + 10, data.getY() - 5};
                        nArrayArray5[1] = new int[]{regPanelX + data.getX() + 3 * DisplayStyles.REG_16_WIDTH / 4 + 10, data.getY() - 50};
                        nArrayArray5[2] = new int[]{regPanelX + this.cmanager.getMem().getX() + DisplayStyles.MEM_WIDTH / 2 - 10, data.getY() - 50};
                        nArrayArray = nArrayArray5;
                        nArrayArray5[3] = new int[]{regPanelX + this.cmanager.getMem().getX() + DisplayStyles.MEM_WIDTH / 2 - 10, this.cmanager.getMem().getY() - 13};
                    }
                    bus.calcBounds(nArrayArray);
                    break;
                }
                case CU: {
                    bus.calcBounds(new int[][]{{regPanelX + aluX + 90, commY + this.commutView.getHeight() + 4}, {regPanelX + aluX + 90, aluY + 80 + 90}, {regPanelX + this.cycleview.getX() + this.cycleview.getWidth() / 2, aluY + 80 + 90}, {regPanelX + this.cycleview.getX() + this.cycleview.getWidth() / 2, this.cycleview.getY() + 200 + 15}});
                }
            }
        }
    }

    private void activateAndAddListener(IODevice ioDevice, final int i) {
        ioDevice.activate();
        ioDevice.getFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                BasicView.this.ioButtons[i].setSelected(false);
            }
        });
    }
}

