/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui.components;

import java.awt.Graphics;
import java.util.EnumMap;
import javax.swing.JLabel;
import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.RunningCycle;
import ru.ifmo.cs.bcomp.ui.components.BCompComponent;
import ru.ifmo.cs.bcomp.ui.components.DisplayStyles;

public class RunningCycleView
extends BCompComponent {
    private CPU cpu;
    private static final String[] cycleslabels = new String[]{"Instruction fetch", "Address fetch", "Operand fetch", "Execution", "Interrupt", "Operator panel", "Program"};
    private EnumMap<RunningCycle, Integer> cycles = new EnumMap(RunningCycle.class);
    private final JLabel[] labels = new JLabel[cycleslabels.length];
    private RunningCycle lastcycle = RunningCycle.STOP;

    public RunningCycleView(CPU cpu, int x, int y) {
        super("Control Unit", cycleslabels.length);
        this.cpu = cpu;
        this.setBounds(x, y, 7 * DisplayStyles.MEM_WIDTH / 4);
        for (int i = 0; i < cycleslabels.length; ++i) {
            this.labels[i] = this.addValueLabel(cycleslabels[i]);
            this.labels[i].setBounds(1, this.getValueY(i), this.width - 2, 25);
        }
        this.cycles.put(RunningCycle.INFETCH, 0);
        this.cycles.put(RunningCycle.ADFETCH, 1);
        this.cycles.put(RunningCycle.OPFETCH, 2);
        this.cycles.put(RunningCycle.EXEC, 3);
        this.cycles.put(RunningCycle.INT, 4);
        this.cycles.put(RunningCycle.START, 5);
        this.cycles.put(RunningCycle.READ, 5);
        this.cycles.put(RunningCycle.WRITE, 5);
        this.cycles.put(RunningCycle.SETIP, 5);
    }

    public void update() {
        RunningCycle newcycle = this.cpu.getRunningCycle();
        if (newcycle != this.lastcycle) {
            if (this.lastcycle != RunningCycle.STOP && this.lastcycle != RunningCycle.RESERVED) {
                this.labels[this.cycles.get((Object)this.lastcycle)].setForeground(DisplayStyles.COLOR_TEXT);
            }
            if (newcycle != RunningCycle.STOP && newcycle != RunningCycle.RESERVED) {
                this.labels[this.cycles.get((Object)newcycle)].setForeground(DisplayStyles.COLOR_ACTIVE);
            }
            this.lastcycle = newcycle;
        }
    }

    public void updateProg(boolean prog) {
        this.labels[this.labels.length - 1].setForeground(prog ? DisplayStyles.COLOR_ACTIVE : DisplayStyles.COLOR_TEXT);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawLine(1, 26, this.width - 2, 26);
    }

    @Override
    protected JLabel addValueLabel(String value) {
        return this.addLabel(value, DisplayStyles.FONT_COURIER_BOLD_18, DisplayStyles.COLOR_VALUE);
    }
}

