/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui.io;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.components.DataDestination;

class FlagIndicator
extends JComponent {
    private static final Color LED_OFF = new Color(128, 128, 128);
    private static final Color LED_ON = new Color(0, 160, 0);
    private final Dimension DIMS;
    private final IOCtrl ioctrl;

    protected FlagIndicator(IOCtrl ioctrl, int size) {
        this.ioctrl = ioctrl;
        this.DIMS = new Dimension(size, size);
        this.setMinimumSize(this.DIMS);
        this.setMaximumSize(this.DIMS);
        this.setPreferredSize(this.DIMS);
        this.setSize(this.DIMS);
        this.setToolTipText("\u0413\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u044c");
        ioctrl.addDestination(ioctrl.getRegisters()[1], new DataDestination(){

            @Override
            public void setValue(long value) {
                FlagIndicator.this.repaint();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.ioctrl.isReady() ? LED_ON : LED_OFF);
        g.fillOval(this.DIMS.width / 4, this.DIMS.height / 4, this.DIMS.width / 2, this.DIMS.height / 2);
    }
}

