/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.ui.components.DisplayStyles;
import ru.ifmo.cs.bcomp.ui.io.FlagIndicator;
import ru.ifmo.cs.bcomp.ui.io.IODevice;

public class Keyboard
extends IODevice {
    static final Dimension DIMS = new Dimension(45, 30);
    private static final String[][][] KEYS = new String[][][]{{{"`", "~", "\u0451", "\u0401"}, {"1", "!", "1", "!"}, {"2", "@", "2", "\""}, {"3", "#", "3", "#"}, {"4", "$", "4", "*"}, {"5", "%", "5", ":"}, {"6", "^", "6", ","}, {"7", "&", "7", "."}, {"8", "*", "8", ";"}, {"9", "(", "9", "("}, {"0", ")", "0", ")"}, {"-", "_", "-", "_"}, {"=", "+", "=", "+"}}, {{"q", "Q", "\u0439", "\u0419"}, {"w", "W", "\u0446", "\u0426"}, {"e", "E", "\u0443", "\u0423"}, {"r", "R", "\u043a", "\u041a"}, {"t", "T", "\u0435", "\u0415"}, {"y", "Y", "\u043d", "\u041d"}, {"u", "U", "\u0433", "\u0413"}, {"i", "I", "\u0448", "\u0428"}, {"o", "O", "\u0449", "\u0429"}, {"p", "P", "\u0437", "\u0417"}, {"[", "{", "\u0445", "\u0425"}, {"]", "}", "\u044a", "\u042a"}, {"\\", "|", "\\", "|"}}, {{"a", "A", "\u0444", "\u0424"}, {"s", "S", "\u044b", "\u042b"}, {"d", "D", "\u0432", "\u0412"}, {"f", "F", "\u0430", "\u0410"}, {"g", "G", "\u043f", "\u041f"}, {"h", "H", "\u0440", "\u0420"}, {"j", "J", "\u043e", "\u041e"}, {"k", "K", "\u043b", "\u041b"}, {"l", "L", "\u0434", "\u0414"}, {";", ":", "\u0436", "\u0416"}, {"'", "\"", "\u044d", "\u042d"}}, {{"z", "Z", "\u044f", "\u042f"}, {"x", "X", "\u0447", "\u0427"}, {"c", "C", "\u0441", "\u0421"}, {"v", "V", "\u043c", "\u041c"}, {"b", "B", "\u0438", "\u0418"}, {"n", "N", "\u0442", "\u0422"}, {"m", "M", "\u044c", "\u042c"}, {",", "<", "\u0431", "\u0411"}, {".", ">", "\u044e", "\u042e"}, {"/", "?", "/", "?"}}};
    private final ArrayList<Key> keys = new ArrayList();
    private String charset;

    public Keyboard(IOCtrl ioctrl) {
        super(ioctrl, "kbd");
    }

    @Override
    protected Component getContent() {
        JPanel content = new JPanel(new GridLayout(5, 1, 0, 0));
        for (int line = 0; line < KEYS.length; ++line) {
            JPanel jrow = new JPanel(new FlowLayout(1, 0, 0));
            block9: for (int row = 0; row < KEYS[line].length; ++row) {
                if (row == 0) {
                    switch (line) {
                        case 1: {
                            SizedButton b = new SizedButton("<html>&rarr;</html>");
                            b.buttonSetSize(new Dimension(60, 30));
                            b.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Keyboard.this.buttonPressed("\t");
                                }
                            });
                            jrow.add(b);
                            break;
                        }
                        case 2: {
                            SizedButton b = new SizedButton("Caps");
                            b.buttonSetSize(new Dimension(75, 30));
                            b.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Iterator iterator = Keyboard.this.keys.iterator();
                                    while (iterator.hasNext()) {
                                        Key key;
                                        key.caps = !(key = (Key)iterator.next()).caps;
                                        key.setActiveLayout();
                                    }
                                }
                            });
                            jrow.add(b);
                        }
                    }
                }
                Key k = new Key(KEYS[line][row]);
                jrow.add(k);
                this.keys.add(k);
                if (row != KEYS[line].length - 1) continue;
                switch (line) {
                    case 0: {
                        SizedButton b = new SizedButton("<html>&larr;</html>");
                        b.buttonSetSize(new Dimension(60, 30));
                        b.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Keyboard.this.buttonPressed("\b");
                            }
                        });
                        jrow.add(b);
                        continue block9;
                    }
                    case 2: {
                        SizedButton b = new SizedButton("Enter");
                        b.buttonSetSize(new Dimension(75, 30));
                        b.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Keyboard.this.buttonPressed("\n");
                            }
                        });
                        jrow.add(b);
                    }
                }
            }
            content.add(jrow);
        }
        JPanel jrow = new JPanel(new FlowLayout(1, 0, 0));
        jrow.add(new FlagIndicator(this.ioctrl, 30));
        SizedButton latrus = new SizedButton("Lat/\u0420\u0443\u0441");
        latrus.buttonSetSize(new Dimension(120, 30));
        latrus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Iterator iterator = Keyboard.this.keys.iterator();
                while (iterator.hasNext()) {
                    Key key;
                    key.lang = (key = (Key)iterator.next()).lang == Lang.EN ? Lang.RU : Lang.EN;
                    key.setActiveLayout();
                }
            }
        });
        jrow.add(latrus);
        SizedButton space = new SizedButton(" ");
        space.buttonSetSize(new Dimension(300, 30));
        space.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Keyboard.this.buttonPressed(" ");
            }
        });
        jrow.add(space);
        String[] stringArray = new String[4];
        this.charset = "KOI8-R";
        stringArray[0] = "KOI8-R";
        stringArray[1] = "ISO8859-5";
        stringArray[2] = "CP866";
        stringArray[3] = "CP1251";
        JComboBox<String> charsetbox = new JComboBox<String>(stringArray);
        charsetbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox source = (JComboBox)e.getSource();
                Keyboard.this.charset = (String)source.getSelectedItem();
            }
        });
        jrow.add(charsetbox);
        content.add(jrow);
        return content;
    }

    private void buttonPressed(String s) {
        try {
            int c = s.getBytes(this.charset)[0] & 0xFF;
            this.ioctrl.setData(c);
            this.ioctrl.setReady();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private class Key
    extends SizedButton {
        private final String[] values;
        private String active;
        private Lang lang;
        private boolean caps;

        public Key(String[] values) {
            super(values[0]);
            this.lang = Lang.EN;
            this.caps = false;
            this.values = values;
            this.active = values[0];
            this.buttonSetSize(DIMS);
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Keyboard.this.buttonPressed(Key.this.active);
                }
            });
        }

        private void setActiveLayout() {
            switch (this.lang) {
                case EN: {
                    this.active = this.caps ? this.values[1] : this.values[0];
                    break;
                }
                case RU: {
                    this.active = this.caps ? this.values[3] : this.values[2];
                }
            }
            this.setText(this.active);
        }
    }

    private class SizedButton
    extends JButton {
        public SizedButton(String title) {
            super(title);
        }

        public final void buttonSetSize(Dimension d) {
            this.setFont(DisplayStyles.FONT_COURIER_PLAIN_12);
            this.setSize(d);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setPreferredSize(d);
        }
    }

    private static enum Lang {
        EN,
        RU;

    }
}

