/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.UnsupportedEncodingException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.ui.components.DisplayStyles;
import ru.ifmo.cs.bcomp.ui.io.FlagIndicator;
import ru.ifmo.cs.bcomp.ui.io.OutputDevice;

public class TextPrinter
extends OutputDevice {
    private JTextArea text = null;
    private String charset = null;

    public TextPrinter(IOCtrl ioctrl) {
        super(ioctrl, "printer");
    }

    @Override
    protected Component getContent() {
        JPanel content = new JPanel(new BorderLayout());
        this.text = new JTextArea(10, 40);
        this.text.setFont(DisplayStyles.FONT_COURIER_BOLD_21);
        this.text.setEditable(false);
        JScrollPane sp = new JScrollPane(this.text);
        content.add("Center", sp);
        JPanel north = new JPanel(new FlowLayout(0));
        String[] stringArray = new String[4];
        this.charset = "KOI8-R";
        stringArray[0] = "KOI8-R";
        stringArray[1] = "ISO8859-5";
        stringArray[2] = "CP866";
        stringArray[3] = "CP1251";
        JComboBox<String> charsetbox = new JComboBox<String>(stringArray);
        charsetbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox source = (JComboBox)e.getSource();
                TextPrinter.this.charset = (String)source.getSelectedItem();
            }
        });
        north.add(new JLabel("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430"));
        north.add(charsetbox);
        north.add(new JLabel("\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430"));
        north.add(this.getSleepSlider());
        north.add(this.getPowerChkBox());
        north.add(new FlagIndicator(this.ioctrl, 30));
        content.add("North", north);
        return content;
    }

    @Override
    protected void actionPerformed(long value) {
        if (value == 0L) {
            this.text.setText("");
        } else if (value == 8L) {
            try {
                this.text.setText(this.text.getText(0, this.text.getText().length() - 1));
            }
            catch (BadLocationException badLocationException) {}
        } else {
            byte[] array = new byte[]{(byte)value};
            try {
                this.text.append(new String(array, this.charset));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }
}

