/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.components;

import ru.ifmo.cs.components.BasicComponent;
import ru.ifmo.cs.components.DataDestination;
import ru.ifmo.cs.components.DataSource;
import ru.ifmo.cs.components.Register;

public class Memory
extends BasicComponent
implements DataSource,
DataDestination {
    private final long[] memory;
    private final Register ar;
    private volatile long lastaccessed;

    public Memory(long width, Register ar) {
        super(width);
        this.ar = ar;
        this.memory = new long[1 << (int)this.ar.width];
        int i = 0;
        while (i < this.memory.length) {
            this.memory[i++] = 0L;
        }
    }

    public synchronized long getValue(long addr) {
        return this.memory[(int)addr];
    }

    @Override
    public synchronized long getValue() {
        this.lastaccessed = this.ar.getValue();
        return this.getValue(this.lastaccessed);
    }

    public synchronized void setValue(long addr, long value) {
        this.memory[(int)addr] = value & this.mask;
    }

    @Override
    public synchronized void setValue(long value) {
        this.lastaccessed = this.ar.getValue();
        this.setValue(this.lastaccessed, value);
    }

    public long getAddrWidth() {
        return this.ar.width;
    }

    public long getLastAccessedAddress() {
        return this.lastaccessed;
    }
}

