/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.components;

import ru.ifmo.cs.components.Control;
import ru.ifmo.cs.components.DataDestination;
import ru.ifmo.cs.components.DataSource;

public class Xor
extends Control {
    private final DataSource input;
    private final long inputwidth;
    private final long inputstartbit;

    public Xor(DataSource input, long width, long startbit, long ctrlbit, DataDestination ... dsts) {
        super(1L, 0L, ctrlbit, dsts);
        this.input = input;
        this.inputwidth = width;
        this.inputstartbit = startbit;
    }

    @Override
    public void setValue(long value) {
        if (this.isOpen(value)) {
            long src = this.input.getValue() >> (int)this.inputstartbit;
            long res = src & 1L;
            for (long i = 1L; i < this.inputwidth; ++i) {
                res ^= (src >>= 1) & 1L;
            }
            super.setValue(res);
        }
    }
}

