/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.IOCtrlBasic;
import ru.ifmo.cs.components.Register;

public class IODevTimer {
    private final IOCtrlBasic ctrl;
    private final Register dr;
    private Thread timer;
    private volatile boolean running = true;

    public IODevTimer(IOCtrl ctrl) {
        this.ctrl = (IOCtrlBasic)ctrl;
        this.dr = ctrl.getRegisters()[0];
    }

    public void start(String name) {
        this.timer = new Thread(new Runnable(){

            @Override
            public void run() {
                long countdown = 0L;
                while (IODevTimer.this.running) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    long value = IODevTimer.this.dr.getValue();
                    if (countdown != 0L && countdown <= value) {
                        if (--countdown != 0L) continue;
                        IODevTimer.this.ctrl.setReady();
                    }
                    countdown = value;
                }
            }
        }, name);
        this.timer.start();
    }

    public void done() {
        this.running = false;
        try {
            this.timer.join();
        }
        catch (Exception ex) {
            System.out.println("Can't join thread: " + ex.getMessage());
        }
    }
}

