/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui;

import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import ru.ifmo.cs.bcomp.BasicComp;
import ru.ifmo.cs.bcomp.ProgramBinary;
import ru.ifmo.cs.bcomp.assembler.AsmNg;
import ru.ifmo.cs.bcomp.assembler.Program;
import ru.ifmo.cs.bcomp.ui.CLI;
import ru.ifmo.cs.bcomp.ui.GUI;
import ru.ifmo.cs.bcomp.ui.MicroCodeDecoder;
import ru.ifmo.cs.bcomp.ui.Nightmare;

public class BCompApp {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CLI cli;
        String app;
        BasicComp bcomp = new BasicComp();
        try {
            app = System.getProperty("mode", "gui");
        }
        catch (Exception e) {
            app = "gui";
        }
        try {
            String code = System.getProperty("code", null);
            File file = new File(code);
            try (FileInputStream fin = null;){
                fin = new FileInputStream(file);
                byte[] content = new byte[(int)file.length()];
                fin.read(content);
                code = new String(content, Charset.forName("UTF-8"));
                AsmNg asm = new AsmNg(code);
                Program pobj = asm.compile();
                if (asm.getErrors().isEmpty()) {
                    ProgramBinary prog = new ProgramBinary(pobj.getBinaryFormat());
                    bcomp.loadProgram(prog);
                } else {
                    for (String err : asm.getErrors()) {
                        System.out.println(err);
                    }
                }
            }
        }
        catch (Exception code) {
            // empty catch block
        }
        try {
            String debuglevel = System.getProperty("debuglevel", "0");
            bcomp.getCPU().setDebugLevel(Long.parseLong(debuglevel));
        }
        catch (Exception debuglevel) {
            // empty catch block
        }
        if (app.equals("decoder")) {
            MicroCodeDecoder mpdecoder = new MicroCodeDecoder(bcomp);
            mpdecoder.decode();
            return;
        }
        bcomp.startTimer();
        if (app.equals("gui")) {
            GUI gui = new GUI(bcomp);
            gui.gui();
            return;
        }
        if (app.equals("cli")) {
            cli = new CLI(bcomp);
            cli.cli();
            return;
        }
        if (app.equals("dual")) {
            cli = new CLI(bcomp);
            GUI gui = new GUI(bcomp);
            gui.gui();
            cli.cli();
            return;
        }
        if (app.equals("nightmare")) {
            Nightmare nightmare = new Nightmare(bcomp);
            return;
        }
        System.err.println("Invalid mode selected");
    }
}

