/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.components;

import java.util.ArrayList;
import java.util.Arrays;
import ru.ifmo.cs.components.BasicComponent;
import ru.ifmo.cs.components.DataDestination;

public class Control
extends BasicComponent
implements DataDestination {
    private final ArrayList<DataDestination> dsts = new ArrayList();
    protected final long startbit;
    protected final long ctrlbit;

    public Control(long width, long startbit, long ctrlbit, DataDestination ... dsts) {
        super(width);
        this.startbit = startbit;
        this.ctrlbit = ctrlbit;
        this.dsts.addAll(Arrays.asList(dsts));
    }

    public synchronized void addDestination(DataDestination ... dsts) {
        this.dsts.addAll(Arrays.asList(dsts));
    }

    public synchronized void removeDestination(DataDestination dst) {
        int index = this.dsts.indexOf(dst);
        if (index >= 0) {
            this.dsts.remove(index);
        }
    }

    protected boolean isOpen(long value) {
        return (value >> (int)this.ctrlbit & 1L) == 1L;
    }

    @Override
    public synchronized void setValue(long value) {
        value = value >> (int)this.startbit & this.mask;
        for (DataDestination dst : this.dsts) {
            dst.setValue(value);
        }
    }
}

