/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.components;

import java.util.ArrayList;
import java.util.Arrays;
import ru.ifmo.cs.components.BasicComponent;
import ru.ifmo.cs.components.DataSource;

public class InputBus
extends BasicComponent
implements DataSource {
    private final ArrayList<DataSource> inputs = new ArrayList();
    private final long startbit;

    public InputBus(long width, long startbit, DataSource ... inputs) {
        super(width);
        this.startbit = startbit;
        this.addInput(inputs);
    }

    public InputBus(long width, DataSource ... inputs) {
        this(width, 0L, inputs);
    }

    public final synchronized void addInput(DataSource ... inputs) {
        this.inputs.addAll(Arrays.asList(inputs));
    }

    @Override
    public long getValue() {
        long value = 0L;
        for (DataSource input : this.inputs) {
            value |= input.getValue() >> (int)this.startbit;
        }
        return value & this.mask;
    }
}

