/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.ControlSignal;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.IOCtrlAdv;
import ru.ifmo.cs.bcomp.IOCtrlBasic;
import ru.ifmo.cs.bcomp.IODevTimer;
import ru.ifmo.cs.bcomp.ProgramBinary;
import ru.ifmo.cs.bcomp.SignalListener;
import ru.ifmo.cs.components.DataDestination;

public class BasicComp {
    private final CPU cpu;
    private final IOCtrl[] ioctrls = new IOCtrl[10];
    private final IODevTimer timer;

    public BasicComp() throws Exception {
        this.cpu = new CPU();
        this.cpu.startCPU();
        DataDestination[] dataDestinationArray = new DataDestination[1];
        DataDestination[] dataDestinationArray2 = new DataDestination[1];
        DataDestination[] dataDestinationArray3 = new DataDestination[1];
        DataDestination[] dataDestinationArray4 = new DataDestination[1];
        DataDestination[] dataDestinationArray5 = new DataDestination[1];
        DataDestination[] dataDestinationArray6 = new DataDestination[1];
        DataDestination[] dataDestinationArray7 = new DataDestination[1];
        DataDestination[] dataDestinationArray8 = new DataDestination[1];
        DataDestination[] dataDestinationArray9 = new DataDestination[1];
        this.ioctrls[9] = new IOCtrlBasic(28L, this.cpu, IOCtrlBasic.TYPE.INPUT, new DataDestination[0]);
        dataDestinationArray9[0] = this.ioctrls[9].getIRQSC();
        this.ioctrls[8] = new IOCtrlBasic(24L, this.cpu, IOCtrlBasic.TYPE.INPUT, dataDestinationArray9);
        dataDestinationArray8[0] = this.ioctrls[8].getIRQSC();
        this.ioctrls[7] = new IOCtrlBasic(20L, this.cpu, IOCtrlBasic.TYPE.OUTPUT, dataDestinationArray8);
        dataDestinationArray7[0] = this.ioctrls[7].getIRQSC();
        this.ioctrls[6] = new IOCtrlBasic(16L, this.cpu, IOCtrlBasic.TYPE.OUTPUT, dataDestinationArray7);
        dataDestinationArray6[0] = this.ioctrls[6].getIRQSC();
        this.ioctrls[5] = new IOCtrlBasic(12L, this.cpu, IOCtrlBasic.TYPE.OUTPUT, dataDestinationArray6);
        dataDestinationArray5[0] = this.ioctrls[5].getIRQSC();
        this.ioctrls[4] = new IOCtrlAdv(8L, this.cpu, dataDestinationArray5);
        dataDestinationArray4[0] = this.ioctrls[4].getIRQSC();
        this.ioctrls[3] = new IOCtrlBasic(6L, this.cpu, IOCtrlBasic.TYPE.INPUTOUTPUT, dataDestinationArray4);
        dataDestinationArray3[0] = this.ioctrls[3].getIRQSC();
        this.ioctrls[2] = new IOCtrlBasic(4L, this.cpu, IOCtrlBasic.TYPE.INPUT, dataDestinationArray3);
        dataDestinationArray2[0] = this.ioctrls[2].getIRQSC();
        this.ioctrls[1] = new IOCtrlBasic(2L, this.cpu, IOCtrlBasic.TYPE.OUTPUT, dataDestinationArray2);
        dataDestinationArray[0] = this.ioctrls[1].getIRQSC();
        this.ioctrls[0] = new IOCtrlBasic(0L, this.cpu, IOCtrlBasic.TYPE.INPUTOUTPUT, dataDestinationArray);
        this.cpu.addDestination(ControlSignal.INTS, this.ioctrls[0].getIRQSC());
        this.timer = new IODevTimer(this.ioctrls[0]);
    }

    public CPU getCPU() {
        return this.cpu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDestination(SignalListener[] listeners) {
        this.cpu.tickLock();
        try {
            for (SignalListener listener : listeners) {
                for (ControlSignal signal : listener.signals) {
                    this.cpu.addDestination(signal, listener.dest);
                }
            }
        }
        finally {
            this.cpu.tickUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestination(SignalListener[] listeners) {
        this.cpu.tickLock();
        try {
            for (SignalListener listener : listeners) {
                for (ControlSignal signal : listener.signals) {
                    this.cpu.removeDestination(signal, listener.dest);
                }
            }
        }
        finally {
            this.cpu.tickUnlock();
        }
    }

    public void loadProgram(ProgramBinary prog) throws RuntimeException {
        if (this.cpu.isLocked()) {
            throw new RuntimeException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430: \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430");
        }
        if (!this.cpu.executeSetAddr(prog.load_address)) {
            throw new RuntimeException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u0430: \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430");
        }
        for (Integer cmd : prog.binary) {
            if (this.cpu.executeWrite(cmd.intValue())) continue;
            throw new RuntimeException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u0430: \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430");
        }
        if (!this.cpu.executeSetAddr(prog.start_address)) {
            throw new RuntimeException("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u0430: \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430");
        }
    }

    public IOCtrl[] getIOCtrls() {
        return this.ioctrls;
    }

    public void startTimer() {
        this.timer.start("IO0");
    }

    public void stopTimer() {
        this.timer.done();
    }
}

