/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.assembler;

public class AddressingMode {
    public volatile int number = -559038737;
    public volatile String reference = null;
    public AddressingType addressation;

    public String toString() {
        String s = "";
        if (this.addressation == null) {
            return s;
        }
        switch (this.addressation) {
            case DIRECT_ABSOLUTE: {
                if (this.number != -559038737) {
                    s = s + "0d" + this.number;
                    break;
                }
                if (this.reference != null) {
                    s = '$' + this.reference;
                    break;
                }
                s = "$undef";
                break;
            }
            case INDIRECT: {
                if (this.reference != null) {
                    s = '(' + this.reference + ')';
                    break;
                }
                s = "(undef)";
                break;
            }
            case POST_INCREMENT: {
                if (this.reference != null) {
                    s = '(' + this.reference + ")+";
                    break;
                }
                s = "(undef)+";
                break;
            }
            case PRE_DECREMENT: {
                if (this.reference != null) {
                    s = "-(" + this.reference + ')';
                    break;
                }
                s = "-(undef)";
                break;
            }
            case DISPLACEMENT_SP: {
                if (this.number != -559038737) {
                    s = "&" + this.number;
                    break;
                }
                s = "&undef";
                break;
            }
            case DIRECT_RELATIVE: {
                if (this.reference != null) {
                    s = this.reference;
                    break;
                }
                s = "undef";
                break;
            }
            case DIRECT_LOAD: {
                if (this.number != -559038737) {
                    s = "#" + this.number;
                    break;
                }
                s = "#undef";
                break;
            }
            default: {
                s = "UNDEF";
            }
        }
        return s;
    }

    public static enum AddressingType {
        DIRECT_ABSOLUTE,
        INDIRECT,
        POST_INCREMENT,
        PRE_DECREMENT,
        DISPLACEMENT_SP,
        DIRECT_RELATIVE,
        DIRECT_LOAD;

    }
}

