/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.assembler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import ru.ifmo.cs.bcomp.assembler.AddressingMode;
import ru.ifmo.cs.bcomp.assembler.AsmNGErrorListener;
import ru.ifmo.cs.bcomp.assembler.AssemblerAntlrErrorStrategy;
import ru.ifmo.cs.bcomp.assembler.AssemblerException;
import ru.ifmo.cs.bcomp.assembler.Instruction;
import ru.ifmo.cs.bcomp.assembler.InstructionWord;
import ru.ifmo.cs.bcomp.assembler.Label;
import ru.ifmo.cs.bcomp.assembler.MemoryWord;
import ru.ifmo.cs.bcomp.assembler.Program;
import ru.ifmo.cs.bcomp.grammar.BCompNGBaseListener;
import ru.ifmo.cs.bcomp.grammar.BCompNGLexer;
import ru.ifmo.cs.bcomp.grammar.BCompNGParser;

public class AsmNg {
    public static final int BASE_ADDRESS = 16;
    private CodePointCharStream program;
    private BCompNGLexer lexer;
    private CommonTokenStream tokens;
    private BCompNGParser parser;
    private AssemblerAntlrErrorStrategy errHandler;
    private HashMap<String, Label> labels;
    private HashMap<Integer, MemoryWord> memory;
    private List<String> errors;

    public static void main(String[] args) throws Exception {
        AsmNg asmng = new AsmNg("ORG FF\nSTART: LOOP START\nLD   #FF\nIN \nad: and ad\nORG 030h\n    OR $ad\nbc:\n    WORD \u0431\u044f\u043a\u0430\n    LD #0xFF\n    LD #-0x10\n    LD #0x-10\n    ST &0\n    \u0412\u0416\u0423\u0425 \u0431\u044f\u043a\u0430\neb:    WORD 44H,33,49,50\n\u0431\u044f\u043a\u0430: WORD 22H\n    BR \u0431\u044f\u043a\u0430\n    \u041f\u0420\u042b\u0413 (bc)\n    WORD 1 dup(-0x10)\n    WORD 0x12,?,0x13 ; komment\n");
        Program prog = asmng.compile();
        System.out.println("-------errors--------");
        System.out.println(asmng.getErrors());
        if (prog != null) {
            System.out.println("-------words--------");
            System.out.println(prog.toCompiledWords());
            System.out.println("-------binary--------");
            System.out.println(prog.toBinaryRepresentation());
        } else {
            System.out.println("Program is not compiled");
        }
    }

    protected AsmNg(CodePointCharStream program) {
        this.program = program;
        this.labels = new HashMap();
        this.memory = new HashMap();
        this.lexer = new BCompNGLexer(program);
        this.tokens = new CommonTokenStream(this.lexer);
        this.parser = new BCompNGParser(this.tokens);
        this.errHandler = new AssemblerAntlrErrorStrategy();
        this.parser.setErrorHandler(this.errHandler);
        this.errors = new ArrayList<String>();
        AsmNGErrorListener lsnr = new AsmNGErrorListener(this.errors);
        this.lexer.removeErrorListeners();
        this.parser.removeErrorListeners();
        this.lexer.addErrorListener(lsnr);
        this.parser.addErrorListener(lsnr);
    }

    public AsmNg(String program) {
        this(CharStreams.fromString(program + "\n"));
    }

    public BCompNGParser getParser() {
        return this.parser;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Program compile() {
        Program prog = null;
        try {
            this.firstPass();
            prog = this.secondPass();
        }
        catch (AssemblerException e) {
            this.reportAndRecoverFromError(e);
        }
        return prog;
    }

    protected void firstPass() {
        BCompNGParser.ProgContext tree = this.getParser().prog();
        ParseTreeWalker walker = new ParseTreeWalker();
        BCompNGBaseListener fp = new BCompNGBaseListener(){
            private int address = 16;

            @Override
            public void enterLine(BCompNGParser.LineContext ctx) {
            }

            @Override
            public void exitInstructionLine(BCompNGParser.InstructionLineContext ctx) {
                BCompNGParser.InstructionContext ICtx;
                BCompNGParser.LblContext LCtx = ctx.lbl();
                Label label = null;
                if (LCtx != null) {
                    String labelname = LCtx.label().getText();
                    label = (Label)AsmNg.this.labels.get(labelname);
                }
                if ((ICtx = ctx.instruction()) != null) {
                    AddressingMode am;
                    BCompNGParser.OperandContext OCtx;
                    TerminalNode t = AsmNg.getTerminalNode(ICtx);
                    if (t == null) {
                        AsmNg.this.reportAndRecoverFromError(new AssemblerException("Internal error: TerminalNode occasionally is null", AsmNg.this.parser, (ParserRuleContext)ICtx));
                        return;
                    }
                    InstructionWord i = new InstructionWord();
                    Instruction instr = AsmNg.this.instructionByParserType(t.getSymbol().getType());
                    if (instr == null) {
                        AsmNg.this.reportAndRecoverFromError(new AssemblerException("Internal error: Parser has instruction but assebler hasn't", AsmNg.this.parser, (ParserRuleContext)ICtx));
                        return;
                    }
                    i.instruction = instr;
                    i.address = this.address;
                    if (label != null) {
                        i.label = label;
                    }
                    if ((OCtx = ICtx.operand()) != null) {
                        i.operand = am = AsmNg.this.addressingModeByParserContext(OCtx);
                    }
                    if (instr.type == Instruction.Type.BRANCH && ICtx.label() != null) {
                        i.operand = am = new AddressingMode();
                        i.operand.reference = new String(ICtx.label().getText());
                    }
                    if (instr.type == Instruction.Type.IO) {
                        AssemblerException ae = new AssemblerException("Device or vector shall be valid number", AsmNg.this.parser, (ParserRuleContext)ICtx);
                        if (ICtx.dev() == null) {
                            AsmNg.this.reportAndRecoverFromError(ae);
                            return;
                        }
                        BCompNGParser.NumberContext nc = ICtx.dev().number();
                        if (nc == null) {
                            AsmNg.this.reportAndRecoverFromError(ae);
                            return;
                        }
                        Integer devnum = AsmNg.parseIntFromNumberContext(nc, AsmNg.this.parser);
                        if (devnum == null) {
                            AsmNg.this.reportAndRecoverFromError(ae);
                            return;
                        }
                        i.device = devnum;
                    }
                    AsmNg.this.memory.put(i.address, i);
                    ++this.address;
                }
            }

            @Override
            public void exitWordArgument(BCompNGParser.WordArgumentContext ctx) {
                BCompNGParser.DupArgumentContext dactx;
                Label l;
                BCompNGParser.WordDirectiveContext wdctx;
                BCompNGParser.LabelContext lc;
                MemoryWord m = new MemoryWord();
                m.address = this.address;
                BCompNGParser.NumberContext nc = ctx.number();
                if (nc != null) {
                    Integer i = AsmNg.parseIntFromNumberContext(nc, AsmNg.this.parser);
                    m.value = i;
                }
                if ("?".equals(ctx.getText())) {
                    m.value = 0;
                }
                if ((lc = ctx.label()) != null) {
                    m.value_addr_reference = new String(lc.getText());
                }
                if (ctx.getParent().getParent() instanceof BCompNGParser.WordDirectiveContext && (wdctx = (BCompNGParser.WordDirectiveContext)ctx.getParent().getParent()).lbl() != null && (l = (Label)AsmNg.this.labels.get(wdctx.lbl().label().getText())) != null && l.address == this.address) {
                    m.label = l;
                }
                if ((dactx = ctx.dupArgument()) != null) {
                    Integer count = AsmNg.parseIntFromNumberContext(dactx.count().number(), AsmNg.this.parser);
                    if (count <= 1) {
                        AsmNg.this.reportError(new AssemblerException("DUP count should be greater than 1", AsmNg.this.parser, (ParserRuleContext)dactx));
                        return;
                    }
                    BCompNGParser.WordArgumentContext what = dactx.wordArgument();
                    int whatnum = 0;
                    if (!"?".equals(what.getText())) {
                        whatnum = AsmNg.parseIntFromNumberContext(what.number(), AsmNg.this.parser);
                    }
                    for (int mm = 1; mm < count; ++mm) {
                        MemoryWord dupm = new MemoryWord();
                        ++this.address;
                        dupm.address = dupm.address;
                        dupm.value = whatnum;
                        AsmNg.this.memory.put(dupm.address, dupm);
                    }
                    return;
                }
                AsmNg.this.memory.put(m.address, m);
                ++this.address;
            }

            @Override
            public void exitLbl(BCompNGParser.LblContext ctx) {
                Label lab = new Label();
                lab.name = new String(ctx.label().getText().trim());
                lab.address = this.address;
                if (AsmNg.this.labels.containsKey(lab.name)) {
                    AsmNg.this.reportAndRecoverFromError(new AssemblerException("Error: already defined label " + lab.name, AsmNg.this.parser, (ParserRuleContext)ctx));
                    return;
                }
                if ("START".equalsIgnoreCase(lab.name)) {
                    AsmNg.this.labels.put(lab.name, lab);
                    lab.name = "START";
                }
                AsmNg.this.labels.put(lab.name, lab);
            }

            @Override
            public void exitOrgAddress(BCompNGParser.OrgAddressContext ctx) {
                BCompNGParser.NumberContext n = ctx.address().number();
                Integer i = AsmNg.parseIntFromNumberContext(n, AsmNg.this.parser);
                this.address = i;
            }
        };
        walker.walk(fp, tree);
    }

    protected Program secondPass() {
        if (this.memory.keySet().isEmpty()) {
            AssemblerException ae = new AssemblerException("Second pass failed: no instruction was compiled on first pass.", this.parser);
            this.reportError(ae);
            return null;
        }
        LinkedList<Integer> addresses = new LinkedList<Integer>(this.memory.keySet());
        LinkedList<Integer> binary = new LinkedList<Integer>();
        Program prog = new Program();
        Collections.sort(addresses);
        prog.start_address = prog.load_address = addresses.getFirst().intValue();
        if (this.labels.containsKey("START")) {
            prog.start_address = this.labels.get((Object)"START").address;
        }
        int prev = addresses.getFirst();
        for (Integer addr : addresses) {
            MemoryWord w = this.memory.get(addr);
            if (w instanceof InstructionWord) {
                InstructionWord iw = (InstructionWord)w;
                iw.value = iw.instruction.opcode;
                switch (iw.instruction.type) {
                    case NONADDR: {
                        break;
                    }
                    case ADDR: {
                        this.compileOperand(iw);
                        break;
                    }
                    case BRANCH: {
                        iw.value = iw.instruction.opcode | this.convertReferenceToDisplacement(iw);
                        break;
                    }
                    case IO: {
                        if (iw.instruction.opcode == Instruction.INT.opcode) {
                            if (iw.device < 0 || iw.device > 7) {
                                this.reportError(new AssemblerException("Second pass: vector exceed limits [0..7]", this.parser));
                            }
                            iw.value = iw.instruction.opcode | iw.device;
                            break;
                        }
                        if (iw.device < 0 || iw.device > 255) {
                            this.reportError(new AssemblerException("Second pass: device number exceed limits [0..0xff]", this.parser));
                        }
                        iw.value = iw.instruction.opcode | iw.device;
                    }
                }
            }
            if (w.value_addr_reference != null) {
                Label l = this.labels.get(w.value_addr_reference);
                if (l == null) {
                    this.reportError(new AssemblerException("Second pass: Label " + w.value_addr_reference + " not found", this.parser));
                } else {
                    w.value = l.address;
                }
            }
            while (w.address - prev > 1) {
                binary.add(0);
                ++prev;
            }
            binary.add(w.value);
            prev = w.address;
        }
        prog.binary = binary;
        prog.labels = this.labels;
        prog.content = this.memory;
        return prog;
    }

    private static Integer parseIntFromNumberContext(BCompNGParser.NumberContext nc, Parser parser) {
        Integer number = null;
        String text = null;
        if (nc.DECIMAL() != null) {
            text = nc.DECIMAL().getText();
            text = text.replaceAll("0[dD]", "");
            number = Integer.parseInt(text);
            return number;
        }
        if (nc.HEX() != null) {
            text = nc.HEX().getText();
            text = text.replaceAll("(0[xX])|[hH]", "");
            number = Integer.parseInt(text, 16);
            return number;
        }
        if (number == null) {
            throw new AssemblerException("Could not recognize valid number while parsing " + nc.getText() + " operand", parser);
        }
        return number;
    }

    private static TerminalNode getTerminalNode(ParseTree p) {
        TerminalNode t = null;
        for (int i = 0; i < p.getChildCount(); ++i) {
            ParseTree internal = p.getChild(i);
            if (internal instanceof TerminalNode) {
                t = (TerminalNode)internal;
                break;
            }
            t = AsmNg.getTerminalNode(internal);
            if (t != null) break;
        }
        return t;
    }

    public final Instruction instructionByParserType(int parserType) {
        Instruction i = null;
        switch (parserType) {
            case 15: {
                i = Instruction.AND;
                break;
            }
            case 16: {
                i = Instruction.OR;
                break;
            }
            case 17: {
                i = Instruction.ADD;
                break;
            }
            case 18: {
                i = Instruction.ADC;
                break;
            }
            case 19: {
                i = Instruction.SUB;
                break;
            }
            case 20: {
                i = Instruction.CMP;
                break;
            }
            case 21: {
                i = Instruction.LOOP;
                break;
            }
            case 22: {
                i = Instruction.LD;
                break;
            }
            case 23: {
                i = Instruction.SWAM;
                break;
            }
            case 24: {
                i = Instruction.JUMP;
                break;
            }
            case 25: {
                i = Instruction.CALL;
                break;
            }
            case 26: {
                i = Instruction.ST;
                break;
            }
            case 27: {
                i = Instruction.NOP;
                break;
            }
            case 28: {
                i = Instruction.HLT;
                break;
            }
            case 29: {
                i = Instruction.CLA;
                break;
            }
            case 30: {
                i = Instruction.NOT;
                break;
            }
            case 31: {
                i = Instruction.CLC;
                break;
            }
            case 32: {
                i = Instruction.CMC;
                break;
            }
            case 33: {
                i = Instruction.ROL;
                break;
            }
            case 34: {
                i = Instruction.ROR;
                break;
            }
            case 35: {
                i = Instruction.ASL;
                break;
            }
            case 36: {
                i = Instruction.ASR;
                break;
            }
            case 37: {
                i = Instruction.SXTB;
                break;
            }
            case 38: {
                i = Instruction.SWAB;
                break;
            }
            case 39: {
                i = Instruction.INC;
                break;
            }
            case 40: {
                i = Instruction.DEC;
                break;
            }
            case 41: {
                i = Instruction.NEG;
                break;
            }
            case 42: {
                i = Instruction.POP;
                break;
            }
            case 43: {
                i = Instruction.POPF;
                break;
            }
            case 44: {
                i = Instruction.RET;
                break;
            }
            case 45: {
                i = Instruction.IRET;
                break;
            }
            case 46: {
                i = Instruction.PUSH;
                break;
            }
            case 47: {
                i = Instruction.PUSHF;
                break;
            }
            case 48: {
                i = Instruction.SWAP;
                break;
            }
            case 49: {
                i = Instruction.BEQ;
                break;
            }
            case 50: {
                i = Instruction.BNE;
                break;
            }
            case 51: {
                i = Instruction.BMI;
                break;
            }
            case 52: {
                i = Instruction.BPL;
                break;
            }
            case 53: {
                i = Instruction.BCS;
                break;
            }
            case 54: {
                i = Instruction.BCC;
                break;
            }
            case 55: {
                i = Instruction.BVS;
                break;
            }
            case 56: {
                i = Instruction.BVC;
                break;
            }
            case 57: {
                i = Instruction.BLT;
                break;
            }
            case 58: {
                i = Instruction.BGE;
                break;
            }
            case 59: {
                i = Instruction.BR;
                break;
            }
            case 61: {
                i = Instruction.EI;
                break;
            }
            case 60: {
                i = Instruction.DI;
                break;
            }
            case 62: {
                i = Instruction.IN;
                break;
            }
            case 63: {
                i = Instruction.OUT;
                break;
            }
            case 64: {
                i = Instruction.INT;
                break;
            }
        }
        return i;
    }

    private AddressingMode addressingModeByParserContext(BCompNGParser.OperandContext octx) {
        AddressingMode am = new AddressingMode();
        ParseTree pt = octx.getChild(0);
        if (pt == null | !(pt instanceof RuleContext)) {
            throw new AssemblerException("Internal error: after parser addressing mode cant be null and should be RuleContext", this.parser);
        }
        switch (((RuleContext)pt).getRuleIndex()) {
            case 15: {
                am.addressation = AddressingMode.AddressingType.DIRECT_ABSOLUTE;
                BCompNGParser.DirectAbsoluteContext dactx = octx.directAbsolute();
                if (dactx.address() != null) {
                    am.number = AsmNg.parseIntFromNumberContext(dactx.address().number(), this.parser);
                }
                if (dactx.label() == null) break;
                am.reference = this.referenceByLabelContext(dactx.label());
                break;
            }
            case 16: {
                am.addressation = AddressingMode.AddressingType.INDIRECT;
                am.reference = this.referenceByLabelContext(octx.indirect().label());
                break;
            }
            case 17: {
                am.addressation = AddressingMode.AddressingType.POST_INCREMENT;
                am.reference = this.referenceByLabelContext(octx.postIncrement().label());
                break;
            }
            case 18: {
                am.addressation = AddressingMode.AddressingType.PRE_DECREMENT;
                am.reference = this.referenceByLabelContext(octx.preDecrement().label());
                break;
            }
            case 19: {
                am.addressation = AddressingMode.AddressingType.DISPLACEMENT_SP;
                Integer number_sp = AsmNg.parseIntFromNumberContext(octx.displacementSP().number(), this.parser);
                am.number = number_sp;
                break;
            }
            case 20: {
                am.addressation = AddressingMode.AddressingType.DIRECT_RELATIVE;
                am.reference = this.referenceByLabelContext(octx.directRelative().label());
                break;
            }
            case 21: {
                am.addressation = AddressingMode.AddressingType.DIRECT_LOAD;
                Integer number_dl = AsmNg.parseIntFromNumberContext(octx.directLoad().number(), this.parser);
                am.number = number_dl;
                break;
            }
            default: {
                throw new AssemblerException("Internal error: Wrong OperandContext while parsing addressing mode", this.parser);
            }
        }
        return am;
    }

    private String referenceByLabelContext(BCompNGParser.LabelContext lctx) {
        if (lctx == null) {
            AssemblerException ae = new AssemblerException("Internal error: LabelContex cant be null here", this.parser);
            this.reportError(ae);
        }
        return new String(lctx.getText());
    }

    private void compileOperand(InstructionWord iw) {
        if (iw.operand == null) {
            return;
        }
        int num = -559038737;
        switch (iw.operand.addressation) {
            case DIRECT_ABSOLUTE: {
                if (iw.operand.number != -559038737) {
                    num = iw.operand.number;
                }
                if (iw.operand.reference != null) {
                    Label l = this.labels.get(iw.operand.reference);
                    if (l == null) {
                        this.reportError(new AssemblerException("Second pass: label refference " + iw.operand.reference + " not found", this.parser));
                    } else {
                        num = l.address;
                    }
                }
                if (num > 2047 || num < 0) {
                    this.reportError(new AssemblerException("Second pass: memory address 0x" + Integer.toHexString(num) + " out of range [0..0x7FF]", this.parser));
                }
                iw.value = iw.instruction.opcode | num & 0x7FF;
                break;
            }
            case INDIRECT: {
                iw.value = iw.instruction.opcode | 0x800 | this.convertReferenceToDisplacement(iw);
                break;
            }
            case POST_INCREMENT: {
                iw.value = iw.instruction.opcode | 0xA00 | this.convertReferenceToDisplacement(iw);
                break;
            }
            case PRE_DECREMENT: {
                iw.value = iw.instruction.opcode | 0xB00 | this.convertReferenceToDisplacement(iw);
                break;
            }
            case DISPLACEMENT_SP: {
                if (iw.operand.number != -559038737) {
                    num = iw.operand.number;
                } else {
                    this.reportError(new AssemblerException("Second pass: number shoud present in command", this.parser));
                }
                if (num > 127 || num < -128) {
                    this.reportError(new AssemblerException("Second pass: stack displasment exceed limits [-127..128]", this.parser));
                }
                iw.value = iw.instruction.opcode | 0xC00 | num & 0xFF;
                break;
            }
            case DIRECT_RELATIVE: {
                iw.value = iw.instruction.opcode | 0xE00 | this.convertReferenceToDisplacement(iw);
                break;
            }
            case DIRECT_LOAD: {
                if (iw.operand.number != -559038737) {
                    num = iw.operand.number;
                } else {
                    this.reportError(new AssemblerException("Second pass: number shoud present in command", this.parser));
                }
                if (num > 255 || num < -128) {
                    throw new AssemblerException("Second pass: direct load operand exceed limits [-128..255]", this.parser);
                }
                iw.value = iw.instruction.opcode | 0xF00 | num & 0xFF;
                break;
            }
            default: {
                this.reportError(new AssemblerException("Second pass: addressing mode is not properly defined", this.parser));
            }
        }
    }

    private int convertReferenceToDisplacement(InstructionWord iw) {
        Label l;
        int num = -559038737;
        String reference = null;
        if (iw.operand.reference != null) {
            reference = iw.operand.reference;
        }
        if ((l = this.labels.get(reference)) == null) {
            AssemblerException ae = new AssemblerException("Second pass: label refference " + reference + " not found", this.parser);
            this.reportError(ae);
            return 0;
        }
        l.referenced = true;
        num = l.address - iw.address - 1;
        if (num > 127 || num < -128) {
            AssemblerException ae = new AssemblerException("Second pass: label " + reference + " displacement exceed limits [-127..128]", this.parser);
            this.reportError(ae);
            num = 0;
        }
        return num & 0xFF;
    }

    private void reportError(AssemblerException ae) {
        this.errHandler.reportError(this.parser, ae);
    }

    private void reportAndRecoverFromError(AssemblerException ae) {
        this.errHandler.reportError(this.parser, ae);
        this.errHandler.recover(this.parser, ae);
    }
}

