/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.assembler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ru.ifmo.cs.bcomp.assembler.Label;
import ru.ifmo.cs.bcomp.assembler.MemoryWord;

public class Program {
    public static final int UNDEFINED = -1;
    public int load_address = -1;
    public int start_address = -1;
    public List<Integer> binary = null;
    public HashMap<String, Label> labels = null;
    public HashMap<Integer, MemoryWord> content = null;

    public List<Integer> getBinaryFormat() {
        if (this.start_address == -1 || this.load_address == -1 || this.binary == null || this.binary.isEmpty()) {
            throw new RuntimeException("AsmNG Program.getBinaryFormat: Program data is corrupted");
        }
        LinkedList<Integer> prog = new LinkedList<Integer>(this.binary);
        prog.add(0, this.start_address);
        prog.add(0, this.load_address);
        return prog;
    }

    public void loadBinaryFormat(List<Integer> prog) {
        Iterator<Integer> i = prog.iterator();
        if (!i.hasNext()) {
            throw new IndexOutOfBoundsException("AsmNG Program.loadBinaryFormat: \u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u043f\u0443\u0441\u0442\u0430: load_address");
        }
        this.load_address = i.next();
        if (!i.hasNext()) {
            throw new IndexOutOfBoundsException("AsmNG Program.loadBinaryFormat: \u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u043f\u0443\u0441\u0442\u0430: start_address");
        }
        this.start_address = i.next();
        if (prog.size() < 3) {
            throw new IndexOutOfBoundsException("AsmNG Program.loadBinaryFormat: \u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u043f\u0443\u0441\u0442\u0430: binary body");
        }
        this.binary = new LinkedList<Integer>();
        while (i.hasNext()) {
            this.binary.add(i.next());
        }
    }

    public int getLabelAddr(String label) {
        if (this.labels == null) {
            throw new RuntimeException("AsmNG Program.getLabelAddr: Labels are not set up");
        }
        if (!this.labels.containsKey(label)) {
            throw new IllegalArgumentException("AsmNG Program.getLabelAddr: Label " + label + " not found");
        }
        return this.labels.get((Object)label).address;
    }

    public String toBinaryRepresentation(int columns) {
        StringBuilder sb = new StringBuilder();
        int col = 8;
        if (columns >= 1) {
            col = columns;
        }
        int i = 1;
        for (Integer w : this.getBinaryFormat()) {
            String s = "0000" + Integer.toHexString(w);
            s = s.substring(s.length() - 4, s.length());
            sb.append(s).append(' ');
            if (i++ % col != 0) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public String toBinaryRepresentation() {
        return this.toBinaryRepresentation(8);
    }

    public String toCompiledWords() {
        if (this.content == null) {
            return "UnSet";
        }
        StringBuilder sb = new StringBuilder();
        LinkedList<Integer> addresses = new LinkedList<Integer>(this.content.keySet());
        Collections.sort(addresses);
        for (Integer addr : addresses) {
            MemoryWord w = this.content.get(addr);
            sb.append(w).append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        return this.toBinaryRepresentation();
    }
}

