/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.ProgramBinary;
import ru.ifmo.cs.bcomp.assembler.AsmNg;
import ru.ifmo.cs.bcomp.assembler.Program;
import ru.ifmo.cs.bcomp.ui.GUI;
import ru.ifmo.cs.bcomp.ui.components.BCompPanel;
import ru.ifmo.cs.bcomp.ui.components.ComponentManager;
import ru.ifmo.cs.bcomp.ui.components.DisplayStyles;

public class AssemblerView
extends BCompPanel
implements ActionListener {
    private final GUI gui;
    private final CPU cpu;
    private final ComponentManager cmanager;
    private final JTextArea text;
    private final JTextArea errorarea;

    public AssemblerView(GUI gui) {
        super(gui.getComponentManager(), null, null);
        this.gui = gui;
        this.cpu = gui.getCPU();
        this.cmanager = gui.getComponentManager();
        JPanel pane = new JPanel(new BorderLayout());
        this.text = new JTextArea();
        this.text.setFont(DisplayStyles.FONT_COURIER_BOLD_21);
        JScrollPane scroll = new JScrollPane(this.text);
        pane.add((Component)scroll, "Center");
        JButton button = new JButton(this.cmanager.getRes().getString("compile"));
        button.setForeground(DisplayStyles.COLOR_TEXT);
        button.setFont(DisplayStyles.FONT_COURIER_PLAIN_12);
        button.setFocusable(false);
        button.addActionListener(this);
        JPanel buttonpane = new JPanel();
        buttonpane.add(button);
        pane.add((Component)buttonpane, "First");
        this.errorarea = new JTextArea();
        this.errorarea.setEditable(false);
        JScrollPane errscroll = new JScrollPane(this.errorarea);
        pane.add((Component)errscroll, "South");
        JSplitPane splitpane = new JSplitPane(0, pane, errscroll);
        splitpane.setDividerSize(4);
        splitpane.setDividerLocation(464);
        this.add(splitpane);
    }

    @Override
    public void panelActivate() {
        this.text.requestFocus();
    }

    @Override
    public void panelDeactivate() {
    }

    @Override
    public String getPanelName() {
        return this.cmanager.getRes().getString("assembler");
    }

    private void showError(String msg) {
        JOptionPane.showMessageDialog(this.gui, msg, this.cmanager.getRes().getString("error"), 0);
    }

    @Override
    public void redrawArrows() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.cpu.isLocked()) {
            this.showError(this.cmanager.getRes().getString("stopRunning"));
            return;
        }
        this.cmanager.saveDelay();
        boolean clock = this.cpu.getClockState();
        this.cpu.setClockState(true);
        long starttime = System.currentTimeMillis();
        AsmNg asm = new AsmNg(this.text.getText());
        Program pobj = asm.compile();
        long finishtime = System.currentTimeMillis();
        String errors = new String();
        String st = "Start compilation at " + new Date(starttime) + "\n";
        String ft = "Finish compilation at " + new Date(finishtime) + "\n";
        errors = st;
        for (String err : asm.getErrors()) {
            errors = errors + err + '\n';
        }
        errors = errors + ft;
        this.errorarea.setText(errors);
        if (pobj != null) {
            this.gui.getBasicComp().loadProgram(new ProgramBinary(pobj.getBinaryFormat()));
        }
        this.cpu.setClockState(clock);
        this.cmanager.clearActiveSignals();
        this.cmanager.restoreDelay();
    }

    @Override
    public void paintComponent(Graphics g) {
    }
}

