/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JComponent;
import ru.ifmo.cs.bcomp.ControlSignal;
import ru.ifmo.cs.bcomp.SignalListener;
import ru.ifmo.cs.bcomp.ui.components.ActivateblePanel;
import ru.ifmo.cs.bcomp.ui.components.BusNames;
import ru.ifmo.cs.bcomp.ui.components.BusView;
import ru.ifmo.cs.bcomp.ui.components.ComponentManager;
import ru.ifmo.cs.bcomp.ui.components.DisplayStyles;
import ru.ifmo.cs.bcomp.ui.components.RegisterProperties;
import ru.ifmo.cs.bcomp.ui.components.RegisterView;

public abstract class BCompPanel
extends ActivateblePanel {
    protected final ComponentManager cmanager;
    private final RegisterProperties[] regProps;
    protected Map<BusNames, BusView> busesMap;
    private SignalListener[] listeners;
    protected RegPanel regPanel;

    public BCompPanel(ComponentManager cmanager, RegisterProperties[] regProps, Map<BusNames, BusView> baseMap) {
        this.setLayout(new BorderLayout());
        this.cmanager = cmanager;
        this.regProps = regProps;
        this.busesMap = baseMap;
        this.regPanel = new RegPanel();
    }

    protected void setSignalListeners(SignalListener[] listeners) {
        this.listeners = listeners;
    }

    protected SignalListener[] getSignalListeners() {
        return this.listeners;
    }

    private void drawBuses(Graphics g) {
        ArrayList<BusView> openbuses = new ArrayList<BusView>();
        ArrayList<ControlSignal> signals = this.cmanager.getActiveSignals();
        for (BusView bus : this.busesMap.values()) {
            for (ControlSignal signal : bus.getSignals()) {
                if (!signals.contains((Object)signal)) continue;
                openbuses.add(bus);
            }
            bus.draw(g, DisplayStyles.COLOR_BUS);
        }
        for (BusView bus : openbuses) {
            bus.draw(g, DisplayStyles.COLOR_ACTIVE);
        }
    }

    private void drawOpenBuses(Color color) {
        Graphics g = this.getGraphics();
        ArrayList<ControlSignal> signals = this.cmanager.getActiveSignals();
        for (BusView bus : this.busesMap.values()) {
            for (ControlSignal signal : bus.getSignals()) {
                if (!signals.contains((Object)signal)) continue;
                bus.draw(g, color);
            }
        }
    }

    public void stepStart() {
        this.drawOpenBuses(DisplayStyles.COLOR_BUS);
    }

    public void stepFinish() {
        this.drawOpenBuses(DisplayStyles.COLOR_ACTIVE);
    }

    @Override
    public void panelActivate() {
        this.cmanager.panelActivate(this);
        for (RegisterProperties prop : this.regProps) {
            RegisterView reg = this.cmanager.getRegisterView(prop.reg);
            reg.setProperties(prop.x, prop.y, prop.hex, prop.isLeft);
            reg.setPreferredSize(reg.getSize());
            reg.setTitle(prop.reg.toString());
            this.regPanel.add((Component)reg, prop.constraints);
        }
    }

    @Override
    public void panelDeactivate() {
        this.cmanager.panelDeactivate();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.drawBuses(g);
    }

    protected class RegPanel
    extends JComponent {
        RegPanel() {
            this.setLayout(new GridBagLayout());
        }
    }
}

