/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import ru.ifmo.cs.bcomp.BasicComp;
import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.ControlSignal;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.Reg;
import ru.ifmo.cs.bcomp.SignalListener;
import ru.ifmo.cs.bcomp.State;
import ru.ifmo.cs.bcomp.ui.GUI;
import ru.ifmo.cs.bcomp.ui.components.ActiveBitView;
import ru.ifmo.cs.bcomp.ui.components.BCompPanel;
import ru.ifmo.cs.bcomp.ui.components.DisplayStyles;
import ru.ifmo.cs.bcomp.ui.components.FlagView;
import ru.ifmo.cs.bcomp.ui.components.InputRegisterView;
import ru.ifmo.cs.bcomp.ui.components.MemoryView;
import ru.ifmo.cs.bcomp.ui.components.RegisterView;
import ru.ifmo.cs.components.DataDestination;
import ru.ifmo.cs.components.Utils;

public class ComponentManager {
    private JRadioButton rbRanStop;
    private JRadioButton rbTact;
    private ResourceBundle res = ResourceBundle.getBundle("ru.ifmo.cs.bcomp.ui.components.loc", Locale.getDefault());
    private Color[] buttonColors = new Color[]{DisplayStyles.COLOR_TEXT, DisplayStyles.COLOR_ACTIVE};
    private ButtonProperties[] buttonProperties = new ButtonProperties[]{new ButtonProperties(new String[]{this.res.getString("setip")}, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComponentManager.this.cmdEnterAddr();
        }
    }), new ButtonProperties(new String[]{this.res.getString("read")}, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComponentManager.this.cmdRead();
        }
    }), new ButtonProperties(new String[]{this.res.getString("write")}, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComponentManager.this.cmdWrite();
        }
    }), new ButtonProperties(new String[]{this.res.getString("start")}, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComponentManager.this.cmdStart();
        }
    }), new ButtonProperties(new String[]{this.res.getString("continue")}, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComponentManager.this.cmdContinue();
        }
    }), new ButtonProperties(new String[]{this.res.getString("stop"), this.res.getString("run")}, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComponentManager.this.cmdInvertRunState();
        }
    }), new ButtonProperties(new String[]{this.res.getString("tick")}, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ComponentManager.this.cmdInvertClockState();
        }
    })};
    private final KeyAdapter keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 115: {
                    ComponentManager.this.cmdEnterAddr();
                    break;
                }
                case 116: {
                    ComponentManager.this.cmdWrite();
                    break;
                }
                case 117: {
                    ComponentManager.this.cmdRead();
                    break;
                }
                case 118: {
                    ComponentManager.this.cmdStart();
                    break;
                }
                case 119: {
                    ComponentManager.this.cmdContinue();
                    break;
                }
                case 120: {
                    if (e.isShiftDown()) {
                        ComponentManager.this.cmdInvertClockState();
                        break;
                    }
                    ComponentManager.this.cmdInvertRunState();
                    break;
                }
                case 121: {
                    System.exit(0);
                    break;
                }
                case 122: {
                    ComponentManager.this.cmdPrevDelay();
                    break;
                }
                case 123: {
                    ComponentManager.this.cmdNextDelay();
                    break;
                }
                case 81: {
                    if (!e.isControlDown()) break;
                    System.exit(0);
                }
            }
        }
    };
    private static final int BUTTON_RUN = 5;
    private static final int BUTTON_CLOCK = 6;
    private JButton[] buttons;
    private ButtonsPanel buttonsPanel = new ButtonsPanel();
    private final GUI gui;
    private final BasicComp bcomp;
    private final CPU cpu;
    private final IOCtrl[] ioctrls;
    private final MemoryView mem;
    private FlagView[] flagViews = new FlagView[4];
    private EnumMap<Reg, RegisterView> regs = new EnumMap(Reg.class);
    private InputRegisterView input;
    private ActiveBitView activeBit = new ActiveBitView(DisplayStyles.ACTIVE_BIT_X, 486);
    private volatile BCompPanel activePanel;
    private final long[] delayPeriods = new long[]{0L, 1L, 5L, 10L, 25L, 50L, 100L, 1000L};
    private volatile int currentDelay = 3;
    private volatile int savedDelay;
    private final Object lockActivePanel = new Object();
    private volatile boolean cuswitch = false;
    private final SignalListener[] listeners;
    private ArrayList<ControlSignal> openBuses = new ArrayList();
    private static final ControlSignal[] busSignals = new ControlSignal[]{ControlSignal.RDDR, ControlSignal.RDCR, ControlSignal.RDIP, ControlSignal.RDAC, ControlSignal.RDPS, ControlSignal.RDIR, ControlSignal.RDBR, ControlSignal.RDSP, ControlSignal.WRDR, ControlSignal.WRCR, ControlSignal.WRIP, ControlSignal.WRAC, ControlSignal.WRPS, ControlSignal.WRAR, ControlSignal.WRBR, ControlSignal.WRSP, ControlSignal.LOAD, ControlSignal.STOR, ControlSignal.IO, ControlSignal.TYPE};

    public ComponentManager(GUI gui) {
        this.gui = gui;
        this.bcomp = gui.getBasicComp();
        this.cpu = gui.getCPU();
        this.input = new InputRegisterView(this, this.cpu.getRegister(Reg.IR)){

            @Override
            protected void setValue(String val) {
                super.setValue(val);
                ComponentManager.this.getRegisterView(Reg.IR).setValue(Utils.toBinary(ComponentManager.this.cpu.getRegister(Reg.IR).getValue(), (int)ComponentManager.this.input.getRegWidth()));
            }
        };
        this.ioctrls = gui.getIOCtrls();
        this.cpu.setTickStartListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ComponentManager.this.lockActivePanel;
                synchronized (object) {
                    if (ComponentManager.this.activePanel != null) {
                        ComponentManager.this.activePanel.stepStart();
                    }
                }
                ComponentManager.this.openBuses.clear();
            }
        });
        this.cpu.setTickFinishListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ComponentManager.this.lockActivePanel;
                synchronized (object) {
                    if (ComponentManager.this.activePanel != null) {
                        ComponentManager.this.activePanel.stepFinish();
                    }
                }
                if (ComponentManager.this.delayPeriods[ComponentManager.this.currentDelay] != 0L) {
                    try {
                        Thread.sleep(ComponentManager.this.delayPeriods[ComponentManager.this.currentDelay]);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        for (ControlSignal cs : busSignals) {
            this.cpu.addDestination(cs, new SignalHandler(cs));
        }
        for (int i = 0; i < 4; ++i) {
            this.flagViews[i] = new FlagView(0, 0, 25, 25);
            this.flagViews[i].setPreferredSize(this.flagViews[i].getSize());
        }
        this.flagViews[0].setTitle("N");
        this.flagViews[1].setTitle("Z");
        this.flagViews[2].setTitle("V");
        this.flagViews[3].setTitle("C");
        for (Reg reg : Reg.values()) {
            this.regs.put(reg, new RegisterView(this.cpu.getRegister(reg)));
        }
        this.listeners = new SignalListener[]{new SignalListener(this.regs.get((Object)Reg.AR), ControlSignal.WRAR), new SignalListener(this.regs.get((Object)Reg.DR), ControlSignal.WRDR, ControlSignal.LOAD), new SignalListener(this.regs.get((Object)Reg.CR), ControlSignal.WRCR, ControlSignal.INTS), new SignalListener(this.regs.get((Object)Reg.IP), ControlSignal.WRIP), new SignalListener(this.regs.get((Object)Reg.AC), ControlSignal.WRAC, ControlSignal.IO), new SignalListener(this.regs.get((Object)Reg.PS), ControlSignal.RDPS, ControlSignal.WRPS, ControlSignal.SETC, ControlSignal.SETV, ControlSignal.STNZ, ControlSignal.SET_EI, ControlSignal.HALT, ControlSignal.SET_PROGRAM), new SignalListener(this.regs.get((Object)Reg.SP), ControlSignal.WRSP), new SignalListener(this.regs.get((Object)Reg.BR), ControlSignal.WRBR)};
        this.mem = new MemoryView(this.cpu.getMemory(), 1, 1);
        this.cpu.addDestination(ControlSignal.LOAD, new DataDestination(){

            @Override
            public void setValue(long value) {
                if (ComponentManager.this.activePanel != null) {
                    ComponentManager.this.mem.eventRead();
                } else {
                    ComponentManager.this.mem.updateLastAddr();
                }
            }
        });
        this.cpu.addDestination(ControlSignal.SETC, new DataDestination(){

            @Override
            public void setValue(long value) {
                ComponentManager.this.flagViews[3].setActive(ComponentManager.this.cpu.getProgramState(State.C) == 1L);
            }
        });
        this.cpu.addDestination(ControlSignal.SETV, new DataDestination(){

            @Override
            public void setValue(long value) {
                ComponentManager.this.flagViews[2].setActive(ComponentManager.this.cpu.getProgramState(State.V) == 1L);
            }
        });
        this.cpu.addDestination(ControlSignal.STNZ, new DataDestination(){

            @Override
            public void setValue(long value) {
                ComponentManager.this.flagViews[1].setActive(ComponentManager.this.cpu.getProgramState(State.Z) != 0L);
                ComponentManager.this.flagViews[0].setActive(ComponentManager.this.cpu.getProgramState(State.N) != 0L);
            }
        });
        this.cpu.addDestination(ControlSignal.STOR, new DataDestination(){

            @Override
            public void setValue(long value) {
                if (ComponentManager.this.activePanel != null) {
                    ComponentManager.this.mem.eventWrite();
                } else {
                    ComponentManager.this.mem.updateLastAddr();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelActivate(BCompPanel component) {
        Object object = this.lockActivePanel;
        synchronized (object) {
            this.activePanel = component;
            this.bcomp.addDestination(this.listeners);
            this.bcomp.addDestination(this.activePanel.getSignalListeners());
        }
        this.buttonsPanel.setPreferredSize(this.buttonsPanel.getSize());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 10;
        constraints.fill = 0;
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridheight = 2;
        constraints.insets = new Insets(0, 0, 0, 30);
        this.input.setProperties(0, 0, false, true);
        this.input.setTitle("IR");
        this.input.setPreferredSize(this.input.getSize());
        this.input.setMinimumSize(this.input.getSize());
        this.buttonsPanel.add((Component)this.input, constraints);
        constraints.anchor = 10;
        constraints.insets = new Insets(0, DisplayStyles.REG_16_WIDTH + 26, 0, 20);
        this.activeBit.setPreferredSize(this.activeBit.getSize());
        this.activeBit.setMinimumSize(this.activeBit.getSize());
        this.buttonsPanel.add((Component)this.activeBit, constraints);
        this.mem.setPreferredSize(this.mem.getSize());
        component.add((Component)this.buttonsPanel, "South");
        this.mem.updateMemory();
        this.cuswitch = false;
        this.switchFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelDeactivate() {
        Object object = this.lockActivePanel;
        synchronized (object) {
            this.bcomp.removeDestination(this.listeners);
            this.bcomp.removeDestination(this.activePanel.getSignalListeners());
            this.activePanel = null;
        }
    }

    public void keyPressed(KeyEvent e) {
        this.keyListener.keyPressed(e);
    }

    public void switchFocus() {
        this.input.setActive();
    }

    public RegisterView getRegisterView(Reg reg) {
        return this.regs.get((Object)reg);
    }

    public FlagView getFlagView(int i) {
        return this.flagViews[i];
    }

    public void cmdContinue() {
        this.cpu.startContinue();
    }

    public void cmdEnterAddr() {
        this.cpu.startSetAddr();
    }

    public void cmdWrite() {
        this.cpu.startWrite();
    }

    public void cmdRead() {
        this.cpu.startRead();
    }

    public void cmdStart() {
        this.cpu.startStart();
    }

    public void cmdInvertRunState() {
        this.cpu.invertRunState();
        long state = this.cpu.getProgramState(State.W);
        this.rbRanStop.setSelected(state == 1L);
        this.rbRanStop.setText(this.buttonProperties[5].texts[(int)state]);
        this.regs.get((Object)Reg.PS).setValue();
    }

    public void cmdInvertClockState() {
        boolean state = this.cpu.invertClockState();
        this.rbTact.setSelected(!state);
    }

    public void cmdNextDelay() {
        this.currentDelay = this.currentDelay < this.delayPeriods.length - 1 ? this.currentDelay + 1 : 0;
    }

    public void cmdPrevDelay() {
        this.currentDelay = (this.currentDelay > 0 ? this.currentDelay : this.delayPeriods.length) - 1;
    }

    public void saveDelay() {
        this.savedDelay = this.currentDelay;
        this.currentDelay = 0;
    }

    public void restoreDelay() {
        this.currentDelay = this.savedDelay;
    }

    public ActiveBitView getActiveBit() {
        return this.activeBit;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public ArrayList<ControlSignal> getActiveSignals() {
        return this.openBuses;
    }

    public void clearActiveSignals() {
        this.openBuses.clear();
    }

    public MemoryView getMem() {
        return this.mem;
    }

    public ResourceBundle getRes() {
        return this.res;
    }

    static /* synthetic */ JButton[] access$102(ComponentManager x0, JButton[] x1) {
        x0.buttons = x1;
        return x1;
    }

    private class ButtonsPanel
    extends JComponent {
        public ButtonsPanel() {
            this.setBounds(0, 530, DisplayStyles.PANE_WIDTH, 50);
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints(){
                {
                    this.anchor = 17;
                    this.fill = 2;
                    this.gridx = 0;
                    this.gridy = 0;
                    this.weightx = 1.0;
                    this.insets = new Insets(1, 1, 1, 1);
                }
            };
            ComponentManager.access$102(ComponentManager.this, new JButton[ComponentManager.this.buttonProperties.length]);
            for (int i = 0; i < ComponentManager.this.buttons.length - 2; ++i) {
                ((ComponentManager)ComponentManager.this).buttons[i] = new JButton(((ComponentManager)ComponentManager.this).buttonProperties[i].texts[0]);
                ComponentManager.this.buttons[i].setForeground(ComponentManager.this.buttonColors[0]);
                ComponentManager.this.buttons[i].setFont(DisplayStyles.FONT_COURIER_PLAIN_12);
                ComponentManager.this.buttons[i].setFocusable(false);
                ComponentManager.this.buttons[i].addActionListener(((ComponentManager)ComponentManager.this).buttonProperties[i].listener);
                ComponentManager.this.buttons[i].setCursor(new Cursor(12));
                int n = constraints.gridwidth = i == 0 ? 2 : 1;
                if (i > 0) {
                    constraints.gridy = 1;
                }
                if (i == 2) {
                    constraints.gridx = 0;
                }
                this.add((Component)ComponentManager.this.buttons[i], constraints);
                if (i == 2) {
                    constraints.gridx += 3;
                    continue;
                }
                ++constraints.gridx;
            }
            constraints.gridy = 0;
            constraints.gridx = 3;
            constraints.fill = 0;
            constraints.anchor = 10;
            ComponentManager.this.rbRanStop = new JRadioButton(((ComponentManager)ComponentManager.this).buttonProperties[5].texts[0]);
            ComponentManager.this.rbRanStop.setFont(DisplayStyles.FONT_COURIER_PLAIN_12);
            ComponentManager.this.rbRanStop.setBackground(new Color(200, 221, 242));
            ComponentManager.this.rbRanStop.setBorderPainted(false);
            ComponentManager.this.rbRanStop.addActionListener(((ComponentManager)ComponentManager.this).buttonProperties[5].listener);
            ComponentManager.this.rbRanStop.setCursor(new Cursor(12));
            ComponentManager.this.rbRanStop.setFocusPainted(false);
            ComponentManager.this.rbRanStop.setFocusable(false);
            this.add((Component)ComponentManager.this.rbRanStop, constraints);
            ++constraints.gridx;
            ComponentManager.this.rbTact = new JRadioButton(((ComponentManager)ComponentManager.this).buttonProperties[6].texts[0]);
            ComponentManager.this.rbTact.setFont(DisplayStyles.FONT_COURIER_PLAIN_12);
            ComponentManager.this.rbTact.setBackground(new Color(200, 221, 242));
            ComponentManager.this.rbTact.setBorderPainted(false);
            ComponentManager.this.rbTact.addActionListener(((ComponentManager)ComponentManager.this).buttonProperties[6].listener);
            ComponentManager.this.rbTact.setCursor(new Cursor(12));
            ComponentManager.this.rbTact.setFocusPainted(false);
            ComponentManager.this.rbTact.setFocusable(false);
            this.add((Component)ComponentManager.this.rbTact, constraints);
        }
    }

    private class ButtonProperties {
        final String[] texts;
        public final ActionListener listener;

        public ButtonProperties(String[] texts, ActionListener listener) {
            this.texts = texts;
            this.listener = listener;
        }
    }

    private class SignalHandler
    implements DataDestination {
        private final ControlSignal signal;

        public SignalHandler(ControlSignal signal) {
            this.signal = signal;
        }

        @Override
        public void setValue(long value) {
            ComponentManager.this.openBuses.add(this.signal);
        }
    }
}

