/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.components;

import ru.ifmo.cs.components.Control;
import ru.ifmo.cs.components.DataDestination;
import ru.ifmo.cs.components.DataSource;

public class DataAdd
extends Control {
    private final DataSource left;
    private final DataSource right;
    private final DataSource carry;
    private final long vmask;

    public DataAdd(DataSource left, DataSource right, DataSource carry, long width, long ctrlbit, DataDestination ... dsts) {
        super(width + 2L, 0L, ctrlbit, dsts);
        this.left = left;
        this.right = right;
        this.carry = carry;
        this.vmask = DataAdd.calculateMask(width - 1L);
    }

    @Override
    public synchronized void setValue(long value) {
        if (this.isOpen(value)) {
            long l = this.left.getValue();
            long r = this.right.getValue();
            long c = this.carry.getValue();
            super.setValue(l + r + c + ((l & this.vmask) + (r & this.vmask) + c << 2 & (long)(1 << (int)(this.width - 1L))) & this.mask);
        }
    }
}

