/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp;

import java.util.EnumMap;
import ru.ifmo.cs.bcomp.CPU2IO;
import ru.ifmo.cs.elements.Consts;
import ru.ifmo.cs.elements.DataComparer;
import ru.ifmo.cs.elements.DataDestination;
import ru.ifmo.cs.elements.DataHandler;
import ru.ifmo.cs.elements.DataSource;
import ru.ifmo.cs.elements.Register;
import ru.ifmo.cs.elements.Valve;
import ru.ifmo.cs.elements.ValveDecoder;
import ru.ifmo.cs.elements.ValveOnce;

public class IOCtrl {
    private final Register flag;
    private final Register data;
    private final int addr;
    private final Direction dir;
    private final Valve valveSetFlag = new Valve(Consts.consts[1], new DataSource[0]);
    private final EnumMap<ControlSignal, DataHandler[]> signals = new EnumMap(ControlSignal.class);

    public IOCtrl(int addr, Direction dir, CPU2IO cpu2io) {
        this.addr = addr;
        this.dir = dir;
        String name = "ED DR" + Integer.toString(addr);
        this.data = new Register(name, name, 8, new DataSource[0]);
        DataComparer dc = new DataComparer(cpu2io.getAddr(), addr, cpu2io.getValveIO());
        ValveDecoder order = new ValveDecoder(cpu2io.getOrder(), dc);
        Valve valveClearFlag = new Valve(Consts.consts[0], 0, order);
        this.signals.put(ControlSignal.SETFLAG, new DataHandler[]{this.valveSetFlag, valveClearFlag});
        this.flag = new Register("ED F" + Integer.toString(addr), "ED flag" + Integer.toString(addr), 1, this.valveSetFlag, valveClearFlag);
        cpu2io.addIntrBusInput(this.flag);
        cpu2io.addIntrCtrlInput(valveClearFlag);
        cpu2io.addIntrCtrlInput(this.valveSetFlag);
        cpu2io.addValveClearFlag(valveClearFlag);
        ValveOnce checkFlag = new ValveOnce(this.flag, 1, order);
        cpu2io.addFlagInput(checkFlag);
        this.signals.put(ControlSignal.CHKFLAG, new DataHandler[]{checkFlag});
        if (dir != Direction.IN) {
            Valve valveOut = new Valve((DataSource)cpu2io.getOut(), 3, order);
            valveOut.addDestination(this.data);
            this.signals.put(ControlSignal.OUT, new DataHandler[]{valveOut});
        }
        if (dir != Direction.OUT) {
            ValveOnce valveIn = new ValveOnce(this.data, 2, order);
            cpu2io.addInInput(valveIn);
            this.signals.put(ControlSignal.IN, new DataHandler[]{valveIn});
        }
    }

    public Direction getDirection() {
        return this.dir;
    }

    public int getFlag() {
        return this.flag.getValue();
    }

    public Register getRegFlag() {
        return this.flag;
    }

    public void setFlag() {
        this.valveSetFlag.setValue(1);
    }

    public int getData() {
        return this.data.getValue();
    }

    public Register getRegData() {
        return this.data;
    }

    public void setData(int value) throws Exception {
        if (this.dir == Direction.OUT) {
            throw new Exception("Attempt to write to the output device " + this.addr);
        }
        this.data.setValue(value);
    }

    public void addDestination(ControlSignal cs, DataDestination dest) {
        for (DataHandler valve : this.signals.get((Object)cs)) {
            valve.addDestination(dest);
        }
    }

    public void removeDestination(ControlSignal cs, DataDestination dest) {
        for (DataHandler valve : this.signals.get((Object)cs)) {
            valve.removeDestination(dest);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ControlSignal {
        SETFLAG,
        CHKFLAG,
        IN,
        OUT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        IN,
        OUT,
        INOUT;

    }
}

