/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui;

import java.util.ArrayList;
import ru.ifmo.cs.bcomp.Assembler;
import ru.ifmo.cs.bcomp.BasicComp;
import ru.ifmo.cs.bcomp.CPU;
import ru.ifmo.cs.bcomp.ControlSignal;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.MicroProgram;
import ru.ifmo.cs.bcomp.Utils;
import ru.ifmo.cs.elements.DataDestination;

public class CLI {
    private final BasicComp bcomp;
    private final MicroProgram mp;
    private final CPU cpu;
    private final IOCtrl[] ioctrls;
    private final Assembler asm;
    private final ArrayList<Integer> writelist = new ArrayList();
    private int sleeptime = 1;
    private volatile int addr;
    private volatile boolean printOnStop = true;
    private volatile boolean printRegsTitle = false;
    private volatile boolean printMicroTitle = false;
    private volatile int sleep = 0;

    public CLI(MicroProgram mp) throws Exception {
        this.mp = mp;
        this.bcomp = new BasicComp(this.mp);
        this.cpu = this.bcomp.getCPU();
        this.bcomp.addDestination(ControlSignal.MEMORY_WRITE, new DataDestination(){

            public void setValue(int value) {
                int addr = CLI.this.cpu.getRegValue(CPU.Reg.ADDR);
                if (!CLI.this.writelist.contains(addr)) {
                    CLI.this.writelist.add(addr);
                }
            }
        });
        this.cpu.setCPUStartListener(new Runnable(){

            public void run() {
                if (CLI.this.printOnStop) {
                    CLI.this.writelist.clear();
                    CLI.this.addr = CLI.this.getIP();
                    CLI.this.printRegsTitle();
                }
            }
        });
        this.cpu.setCPUStopListener(new Runnable(){

            public void run() {
                CLI.this.sleep = 0;
                if (CLI.this.printOnStop) {
                    String add;
                    if (CLI.this.writelist.isEmpty()) {
                        add = "";
                    } else {
                        add = " " + CLI.this.getMemory((Integer)CLI.this.writelist.get(0));
                        CLI.this.writelist.remove(0);
                    }
                    CLI.this.printRegs(add);
                    for (Integer wraddr : CLI.this.writelist) {
                        System.out.println(String.format("%1$34s", " ") + CLI.this.getMemory(wraddr));
                    }
                }
            }
        });
        this.cpu.setTickFinishListener(new Runnable(){

            public void run() {
                if (CLI.this.sleep > 0) {
                    try {
                        Thread.sleep(CLI.this.sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        this.asm = new Assembler(this.cpu.getInstructionSet());
        this.ioctrls = this.bcomp.getIOCtrls();
    }

    private String getReg(CPU.Reg reg) {
        return Utils.toHex(this.cpu.getRegValue(reg), this.cpu.getRegWidth(reg));
    }

    private String getFormattedState(int flag) {
        return Utils.toBinaryFlag(this.cpu.getStateValue(flag));
    }

    private void printRegsTitle() {
        if (this.printRegsTitle) {
            System.out.println(this.cpu.getClockState() ? "\u0410\u0434\u0440 \u0417\u043d\u0447\u043d  \u0421\u041a  \u0420\u0410  \u0420\u041a   \u0420\u0414    \u0410  C \u0410\u0434\u0440 \u0417\u043d\u0447\u043d" : "\u0410\u0434\u0440 \u041c\u041a   \u0421\u041a  \u0420\u0410  \u0420\u041a   \u0420\u0414    \u0410  C   \u0411\u0420  N Z \u0421\u0447\u041c\u041a");
            this.printRegsTitle = false;
        }
    }

    private String getMemory(int addr) {
        return Utils.toHex(addr, 11) + " " + Utils.toHex(this.cpu.getMemoryValue(addr), 16);
    }

    private String getMicroMemory(int addr) {
        return Utils.toHex(addr, 8) + " " + Utils.toHex(this.cpu.getMicroMemoryValue(addr), 16);
    }

    private void printMicroMemory(int addr) {
        if (this.printMicroTitle) {
            System.out.println("\u0410\u0434\u0440 \u041c\u041a");
            this.printMicroTitle = false;
        }
        System.out.println(this.getMicroMemory(addr) + " " + this.mp.decodeCmd(this.cpu.getMicroMemoryValue(addr)));
    }

    private String getRegs() {
        return this.getReg(CPU.Reg.IP) + " " + this.getReg(CPU.Reg.ADDR) + " " + this.getReg(CPU.Reg.INSTR) + " " + this.getReg(CPU.Reg.DATA) + " " + this.getReg(CPU.Reg.ACCUM) + " " + this.getFormattedState(0);
    }

    private void printRegs(String add) {
        System.out.println(this.cpu.getClockState() ? this.getMemory(this.addr) + " " + this.getRegs() + add : this.getMicroMemory(this.addr) + " " + this.getRegs() + " " + this.getReg(CPU.Reg.BUF) + " " + this.getFormattedState(2) + " " + this.getFormattedState(1) + "  " + this.getReg(CPU.Reg.MIP));
    }

    private void printIO(int ioaddr) {
        System.out.println("\u0412\u0423" + ioaddr + ": \u0424\u043b\u0430\u0433 = " + Utils.toBinaryFlag(this.ioctrls[ioaddr].getFlag()) + " \u0420\u0414\u0412\u0423 = " + Utils.toHex(this.ioctrls[ioaddr].getData(), 8));
    }

    private int getIP() {
        return this.cpu.getClockState() ? this.cpu.getRegValue(CPU.Reg.IP) : this.cpu.getRegValue(CPU.Reg.MIP);
    }

    private boolean checkCmd(String cmd, String check) {
        return cmd.equalsIgnoreCase(check.substring(0, Math.min(check.length(), cmd.length())));
    }

    private void checkResult(boolean result) throws Exception {
        if (!result) {
            throw new Exception("\u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430: \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430");
        }
    }

    private void printHelp() {
        System.out.println("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b:\na[ddress]\t- \u041f\u0443\u043b\u044c\u0442\u043e\u0432\u0430\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \"\u0412\u0432\u043e\u0434 \u0430\u0434\u0440\u0435\u0441\u0430\"\nw[rite]\t\t- \u041f\u0443\u043b\u044c\u0442\u043e\u0432\u0430\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \"\u0417\u0430\u043f\u0438\u0441\u044c\"\nr[ead]\t\t- \u041f\u0443\u043b\u044c\u0442\u043e\u0432\u0430\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \"\u0427\u0442\u0435\u043d\u0438\u0435\"\ns[tart]\t\t- \u041f\u0443\u043b\u044c\u0442\u043e\u0432\u0430\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \"\u041f\u0443\u0441\u043a\"\nc[continue]\t- \u041f\u0443\u043b\u044c\u0442\u043e\u0432\u0430\u044f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \"\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c\"\nru[n]\t\t- \u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0436\u0438\u043c\u0430 \u0420\u0430\u0431\u043e\u0442\u0430/\u041e\u0441\u0442\u0430\u043d\u043e\u0432\ncl[ock]\t\t- \u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0436\u0438\u043c\u0430 \u043f\u043e\u0442\u0430\u043a\u0442\u043e\u0432\u043e\u0433\u043e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f\nma[ddress]\t- \u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u043d\u0430 \u043c\u0438\u043a\u0440\u043e\u043a\u043e\u043c\u0430\u043d\u0434\u0443\nmw[rite]\t- \u0417\u0430\u043f\u0438\u0441\u044c \u043c\u0438\u043a\u0440\u043e\u043a\u043e\u043c\u0430\u043d\u0434\u044b\nmr[ead]\t\t- \u0427\u0442\u0435\u043d\u0438\u0435 \u043c\u0438\u043a\u0440\u043e\u043a\u043e\u043c\u0430\u043d\u0434\u044b\nio\t\t- \u0412\u044b\u0432\u043e\u0434 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u0432\u0441\u0435\u0445 \u0412\u0423\nio addr\t\t- \u0412\u044b\u0432\u043e\u0434 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u0412\u0423\nio addr value\t- \u0417\u0430\u043f\u0438\u0441\u044c value \u0432 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0435 \u0412\u0423\nflag addr\t- \u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0444\u043b\u0430\u0433\u0430 \u0433\u043e\u0442\u043e\u0432\u043d\u043e\u0441\u0442\u0438 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u0412\u0423\nasm\t\t- \u0412\u0432\u043e\u0434 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u043d\u0430 \u0430\u0441\u0441\u0435\u043c\u0431\u043b\u0435\u0440\u0435\nsleep value\t- \u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430 \u043c\u0435\u0436\u0434\u0443 \u0442\u0430\u043a\u0442\u0430\u043c\u0438 \u043f\u0440\u0438 \u0444\u043e\u043d\u043e\u0432\u043e\u043c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438\n{exit|quit}\t- \u0412\u044b\u0445\u043e\u0434 \u0438\u0437 \u044d\u043c\u0443\u043b\u044f\u0442\u043e\u0440\u0430\nvalue\t\t- \u0412\u0432\u043e\u0434 \u0448\u0435\u0441\u0442\u043d\u0430\u0434\u0446\u0430\u0442\u0435\u0440\u0438\u0447\u043d\u043e\u0433\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0432 \u043a\u043b\u0430\u0432\u0438\u0448\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\nlabel\t\t- \u0412\u0432\u043e\u0434 \u0430\u0434\u0440\u0435\u0441\u0430 \u043c\u0435\u0442\u043a\u0438 \u0432 \u043a\u043b\u0430\u0432\u0438\u0448\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u0441\u0442\u0440");
    }

    /*
     * Exception decompiling
     */
    public void cli() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 16[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

