/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui.io;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.ui.io.IODevice;
import ru.ifmo.cs.elements.DataDestination;

public class Numpad
extends IODevice {
    private final NumButton[] buttons = new NumButton[16];

    public Numpad(IOCtrl ioctrl) {
        super(ioctrl, "Numpad");
    }

    protected Component getContent() {
        JPanel content = new JPanel(new GridLayout(4, 4, 0, 0));
        this.buttons[0] = new NumButton("7", 7);
        content.add(this.buttons[0]);
        this.buttons[1] = new NumButton("8", 8);
        content.add(this.buttons[1]);
        this.buttons[2] = new NumButton("9", 9);
        content.add(this.buttons[2]);
        this.buttons[3] = new NumButton("/", 12);
        content.add(this.buttons[3]);
        this.buttons[4] = new NumButton("4", 4);
        content.add(this.buttons[4]);
        this.buttons[5] = new NumButton("5", 5);
        content.add(this.buttons[5]);
        this.buttons[6] = new NumButton("6", 6);
        content.add(this.buttons[6]);
        this.buttons[7] = new NumButton("*", 13);
        content.add(this.buttons[7]);
        this.buttons[8] = new NumButton("1", 1);
        content.add(this.buttons[8]);
        this.buttons[9] = new NumButton("2", 2);
        content.add(this.buttons[9]);
        this.buttons[10] = new NumButton("3", 3);
        content.add(this.buttons[10]);
        this.buttons[11] = new NumButton("-", 10);
        content.add(this.buttons[11]);
        this.buttons[12] = new NumButton("0", 0);
        content.add(this.buttons[12]);
        this.buttons[13] = new NumButton(".", 14);
        content.add(this.buttons[13]);
        this.buttons[14] = new NumButton("=", 15);
        content.add(this.buttons[14]);
        this.buttons[15] = new NumButton("+", 11);
        content.add(this.buttons[15]);
        this.ioctrl.addDestination(IOCtrl.ControlSignal.SETFLAG, new DataDestination(){

            public void setValue(int value) {
                for (NumButton button : Numpad.this.buttons) {
                    button.setForeground(value == 0 ? Color.black : Color.red);
                }
            }
        });
        return content;
    }

    private void buttonPressed(int value) {
        try {
            this.ioctrl.setData(value);
            this.ioctrl.setFlag();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class NumButton
    extends JButton {
        private final int value;

        public NumButton(String title, final int value) {
            super(title);
            this.value = value;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Numpad.this.buttonPressed(value);
                }
            });
        }
    }
}

