/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.cs.bcomp.ui.io;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ru.ifmo.cs.bcomp.IOCtrl;
import ru.ifmo.cs.bcomp.ui.io.FlagIndicator;
import ru.ifmo.cs.bcomp.ui.io.OutputDevice;

public class SevenSegmentDisplay
extends OutputDevice {
    private static final Color LED_OFF = new Color(224, 224, 224);
    private static final Color LED_ON = new Color(0, 160, 0);
    private static final int COUNT = 8;
    private static final int SEGMENT_LENGTH = 16;
    private static final int SEGMENT_WIDTH = 2;
    private static final Dimension DIMS = new Dimension(24, 42);
    private static final boolean[][] NUMBERS = new boolean[][]{{true, false, true, true, true, true, true}, {false, false, false, false, false, true, true}, {true, true, true, false, true, true, false}, {true, true, true, false, false, true, true}, {false, true, false, true, false, true, true}, {true, true, true, true, false, false, true}, {true, true, true, true, true, false, true}, {true, false, false, false, false, true, true}, {true, true, true, true, true, true, true}, {true, true, true, true, false, true, true}, {false, true, false, false, false, false, false}, {false, false, false, false, false, false, false}, {false, false, false, false, false, false, false}, {false, false, false, false, false, false, false}, {false, false, false, false, false, false, false}, {false, false, false, false, false, false, false}};
    private static final int[][] COORDINATES = new int[][]{{SevenSegmentDisplay.pos(0, 2), SevenSegmentDisplay.pos(0, 1), 16, 2}, {SevenSegmentDisplay.pos(0, 2), SevenSegmentDisplay.pos(1, 2), 16, 2}, {SevenSegmentDisplay.pos(0, 2), SevenSegmentDisplay.pos(2, 3), 16, 2}, {SevenSegmentDisplay.pos(0, 1), SevenSegmentDisplay.pos(0, 2), 2, 16}, {SevenSegmentDisplay.pos(0, 1), SevenSegmentDisplay.pos(1, 3), 2, 16}, {SevenSegmentDisplay.pos(1, 2), SevenSegmentDisplay.pos(0, 2), 2, 16}, {SevenSegmentDisplay.pos(1, 2), SevenSegmentDisplay.pos(1, 3), 2, 16}};
    private final SSD[] ssd = new SSD[8];

    public SevenSegmentDisplay(IOCtrl ioctrl) {
        super(ioctrl, "Segment Indicator");
    }

    private static int pos(int length, int width) {
        return length * 16 + width * 2;
    }

    protected Component getContent() {
        JPanel content = new JPanel(new BorderLayout());
        JPanel center = new JPanel(new FlowLayout());
        int i = 8;
        while (i > 0) {
            this.ssd[--i] = new SSD();
            center.add(this.ssd[--i]);
        }
        content.add("Center", center);
        JPanel north = new JPanel(new FlowLayout(0));
        north.add(this.getSleepSlider());
        north.add(this.getPowerChkBox());
        north.add(new FlagIndicator(this.ioctrl, 30));
        content.add("North", north);
        return content;
    }

    protected void actionPerformed(int value) {
        int pos = value >> 4 & 7;
        this.ssd[pos].value = value & 0xF;
        this.ssd[pos].repaint();
    }

    private class SSD
    extends JComponent {
        private int value = 15;

        public SSD() {
            this.setMinimumSize(DIMS);
            this.setMaximumSize(DIMS);
            this.setPreferredSize(DIMS);
            this.setSize(DIMS);
        }

        public void paintComponent(Graphics g) {
            for (int i = 0; i < COORDINATES.length; ++i) {
                g.setColor(NUMBERS[this.value][i] ? LED_ON : LED_OFF);
                g.fillRect(COORDINATES[i][0], COORDINATES[i][1], COORDINATES[i][2], COORDINATES[i][3]);
            }
        }
    }
}

