/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.se.pokemon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.ifmo.se.pokemon.FireMove;
import ru.ifmo.se.pokemon.Messages;
import ru.ifmo.se.pokemon.Pokemon;
import ru.ifmo.se.pokemon.Stat;
import ru.ifmo.se.pokemon.Team;
import ru.ifmo.se.pokemon.Type;

public final class Battle {
    private Team allies;
    private Team foes;
    private String allyName;
    private String foeName;

    public Battle() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll((List)Messages.getObj("teams"));
        Collections.shuffle(arrayList);
        this.allies = new Team((String)arrayList.get(0));
        this.foes = new Team((String)arrayList.get(1));
    }

    public void addAlly(Pokemon pokemon) {
        this.allies.add(pokemon);
    }

    public void addFoe(Pokemon pokemon) {
        this.foes.add(pokemon);
    }

    private boolean checkFirst(Pokemon pokemon, Pokemon pokemon2) {
        if (pokemon.getPreparedMove().getPriority() == pokemon2.getPreparedMove().getPriority()) {
            if (pokemon.getStat(Stat.SPEED) == pokemon2.getStat(Stat.SPEED)) {
                return Math.random() >= 0.5;
            }
            return pokemon.getStat(Stat.SPEED) > pokemon2.getStat(Stat.SPEED);
        }
        return pokemon.getPreparedMove().getPriority() > pokemon2.getPreparedMove().getPriority();
    }

    public void go() {
        Object object;
        Object object2;
        block0: do {
            this.allies.next();
            this.foes.next();
            do {
                this.allies.poke().prepareMove();
                this.foes.poke().prepareMove();
                object2 = this.checkFirst(this.allies.poke(), this.foes.poke()) ? this.allies.poke() : this.foes.poke();
                Object object3 = object = this.checkFirst(this.allies.poke(), this.foes.poke()) ? this.foes.poke() : this.allies.poke();
                if (((Pokemon)object2).attack((Pokemon)object) || ((Pokemon)object).attack((Pokemon)object2)) continue block0;
                this.allies.poke().turn();
                if (!this.allies.poke().isAlive()) continue block0;
                this.foes.poke().turn();
            } while (this.foes.poke().isAlive());
        } while (this.allies.hasNext() && this.foes.hasNext());
        if (!this.allies.hasNext() && !this.foes.hasNext()) {
            System.out.println(Messages.get("tie"));
        } else {
            object2 = (this.allies.hasNext() ? this.allies : this.foes).getName();
            object = (this.foes.hasNext() ? this.allies : this.foes).getName();
            System.out.println(Messages.get("inTeam") + " " + (String)object + " " + Messages.get("empty"));
            System.out.println(Messages.get("team") + " " + (String)object2 + " " + Messages.get("wins"));
        }
    }

    public static void main(String[] stringArray) {
        Battle battle = new Battle();
        battle.addAlly(new Pokemon("\u0412\u0435\u0441\u0435\u043b\u044c\u0447\u0430\u043a \u0423", 20){
            {
                this.setStats(10.0, 20.0, 10.0, 10.0, 10.0, 20.0);
                this.setMove(new FireMove(Type.DRAGON, 5.0, 1.0));
            }
        });
        battle.addFoe(new Pokemon("\u0422\u0443\u0442\u0430\u043d \u0425\u0430\u043c\u043e\u043d", 25){
            {
                this.setStats(10.0, 10.0, 20.0, 10.0, 10.0, 10.0);
                this.addMove(new FireMove(Type.DARK, 4.0, 0.8));
            }
        });
        battle.go();
    }
}

