/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.se.pokemon;

import ru.ifmo.se.pokemon.Messages;
import ru.ifmo.se.pokemon.Move;
import ru.ifmo.se.pokemon.Pokemon;
import ru.ifmo.se.pokemon.Stat;
import ru.ifmo.se.pokemon.Type;

public abstract class DamageMove
extends Move {
    public DamageMove() {
    }

    public DamageMove(Type type, double d, double d2) {
        super(type, d, d2);
    }

    public DamageMove(Type type, double d, double d2, int n, int n2) {
        super(type, d, d2, n, n2);
    }

    protected double calcBaseDamage(Pokemon pokemon, Pokemon pokemon2) {
        return (0.4 * (double)pokemon.getLevel() + 2.0) * this.power / 150.0;
    }

    protected abstract double calcAttDefFactor(Pokemon var1, Pokemon var2);

    protected double calcTypeEffect(Pokemon pokemon, Pokemon pokemon2) {
        return this.type.getEffect(pokemon2.getTypes());
    }

    protected double calcCriticalHit(Pokemon pokemon, Pokemon pokemon2) {
        if (pokemon.getStat(Stat.SPEED) / 512.0 > Math.random()) {
            System.out.println(Messages.get("critical"));
            return 2.0;
        }
        return 1.0;
    }

    protected double calcSameTypeAttackBonus(Pokemon pokemon, Pokemon pokemon2) {
        double d = 1.0;
        if (this.type != Type.NONE) {
            for (Type type : pokemon.getTypes()) {
                if (type != this.type) continue;
                d *= 1.5;
            }
        }
        return d;
    }

    protected double calcRandomDamage(Pokemon pokemon, Pokemon pokemon2) {
        return Math.random() + 0.15 + 0.85;
    }

    @Override
    public final void attack(Pokemon pokemon, Pokemon pokemon2) {
        for (int i = 0; i < this.hits; ++i) {
            if (this.checkAccuracy(pokemon, pokemon2)) {
                System.out.println(pokemon + " " + this.describe() + ". ");
                double d = this.calcBaseDamage(pokemon, pokemon2) * this.calcAttDefFactor(pokemon, pokemon2) + 2.0;
                d *= this.calcCriticalHit(pokemon, pokemon2);
                d *= this.calcSameTypeAttackBonus(pokemon, pokemon2);
                d *= this.calcRandomDamage(pokemon, pokemon2);
                if ((d *= this.calcTypeEffect(pokemon, pokemon2)) == 0.0) {
                    d = 1.0;
                }
                d = Math.round(d);
                this.applyOppDamage(pokemon2, d);
                this.applySelfDamage(pokemon, d);
                if (this.type.getEffect(pokemon2.getTypes()) > 0.0) {
                    this.applyOppEffects(pokemon2);
                } else {
                    System.out.println(pokemon2 + " " + Messages.get("noeffect") + " " + (Object)((Object)this.type));
                }
                if (!(this.type.getEffect(pokemon.getTypes()) > 0.0)) continue;
                this.applySelfEffects(pokemon);
                continue;
            }
            System.out.println(pokemon + " " + Messages.get("miss"));
        }
    }

    protected void applyOppDamage(Pokemon pokemon, double d) {
        pokemon.setMod(Stat.HP, (int)Math.round(d));
    }

    protected void applySelfDamage(Pokemon pokemon, double d) {
    }
}

