/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.se.pokemon;

import ru.ifmo.se.pokemon.Pokemon;
import ru.ifmo.se.pokemon.Stat;
import ru.ifmo.se.pokemon.Status;
import ru.ifmo.se.pokemon.Type;

public final class Effect {
    private int[] mods = new int[Stat.values().length];
    private int turns = 0;
    private double effectChance = 1.0;
    private double attackChance = 1.0;
    private Status condition = Status.NORMAL;

    public final Effect turns(int n) {
        this.turns = n;
        return this;
    }

    public final Effect chance(double d) {
        this.effectChance = d;
        return this;
    }

    public final Effect attack(double d) {
        this.attackChance = d;
        return this;
    }

    public final double attack() {
        return this.attackChance;
    }

    public final Effect condition(Status status) {
        this.condition = status;
        return this;
    }

    public final void clear() {
        for (Stat stat : Stat.values()) {
            this.mods[stat.ordinal()] = 0;
        }
        this.condition = Status.NORMAL;
        this.turns = 0;
        this.effectChance = 1.0;
        this.attackChance = 1.0;
    }

    public final Status condition() {
        return this.condition;
    }

    public final int stat(Stat stat) {
        return this.mods[stat.ordinal()];
    }

    public final Effect stat(Stat stat, int n) {
        if (stat != Stat.HP) {
            if (n >= 0 & n > 6) {
                n = 6;
            }
            if (n < 0 & n < -6) {
                n = -6;
            }
        }
        this.mods[stat.ordinal()] = n;
        return this;
    }

    public final boolean success() {
        return this.effectChance > Math.random();
    }

    public final boolean immediate() {
        return this.turns == 0;
    }

    public final boolean turn() {
        return --this.turns == 0;
    }

    public static void burn(Pokemon pokemon) {
        if (!pokemon.hasType(Type.FIRE)) {
            Effect effect = new Effect().condition(Status.BURN).turns(-1);
            effect.stat(Stat.ATTACK, -2).stat(Stat.HP, (int)pokemon.getStat(Stat.HP) / 16);
            pokemon.setCondition(effect);
        }
    }

    public static void paralyze(Pokemon pokemon) {
        if (!pokemon.hasType(Type.ELECTRIC)) {
            Effect effect = new Effect().condition(Status.PARALYZE).attack(0.75).turns(-1);
            effect.stat(Stat.SPEED, -2);
            pokemon.setCondition(effect);
        }
    }

    public static void freeze(Pokemon pokemon) {
        if (!pokemon.hasType(Type.ICE)) {
            Effect effect = new Effect().condition(Status.FREEZE).attack(0.0).turns(-1);
            pokemon.setCondition(effect);
        }
    }

    public static void poison(Pokemon pokemon) {
        if (!pokemon.hasType(Type.POISON) && !pokemon.hasType(Type.STEEL)) {
            Effect effect = new Effect().condition(Status.POISON).turns(-1);
            effect.stat(Stat.HP, (int)pokemon.getStat(Stat.HP) / 8);
            pokemon.setCondition(effect);
        }
    }

    public static void sleep(Pokemon pokemon) {
        Effect effect = new Effect().condition(Status.SLEEP).attack(0.0).turns((int)(Math.random() * 3.0 + 1.0));
        pokemon.setCondition(effect);
    }

    public static void flinch(Pokemon pokemon) {
        Effect effect = new Effect().attack(0.0).turns((int)(Math.random() * 4.0 + 1.0));
        pokemon.addEffect(effect);
    }

    public static void confuse(Pokemon pokemon) {
        pokemon.confuse();
    }
}

