/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.se.pokemon;

import ru.ifmo.se.pokemon.Messages;
import ru.ifmo.se.pokemon.PhysicalMove;
import ru.ifmo.se.pokemon.Pokemon;
import ru.ifmo.se.pokemon.Stat;
import ru.ifmo.se.pokemon.Type;

public abstract class Move {
    protected Type type;
    protected double power = 0.0;
    protected double accuracy = 1.0;
    protected int priority = 0;
    protected int hits = 1;
    private static final Move noMove = new Move(Type.NONE, 0.0, 0.0, -100, 0){

        @Override
        public final void attack(Pokemon pokemon, Pokemon pokemon2) {
        }

        @Override
        public String describe() {
            return Messages.get("noattack");
        }
    };
    private static final Move struggleMove = new PhysicalMove(Type.NONE, 50.0, 1.0){

        @Override
        public final String describe() {
            return Messages.get("struggle");
        }

        @Override
        public final void applySelfDamage(Pokemon pokemon, double d) {
            pokemon.setMod(Stat.HP, (int)Math.round(d / 4.0));
        }
    };
    private static final Move confusionMove = new PhysicalMove(Type.NONE, 40.0, 1.0){

        @Override
        public final String describe() {
            return Messages.get("confusion");
        }

        @Override
        public final void applySelfDamage(Pokemon pokemon, double d) {
            pokemon.setMod(Stat.HP, (int)d);
        }

        @Override
        public double calcCriticalHit(Pokemon pokemon, Pokemon pokemon2) {
            return 1.0;
        }

        @Override
        protected void applyOppDamage(Pokemon pokemon, double d) {
        }
    };

    public Move() {
        this(Type.NONE, 0.0, 1.0, 0, 1);
    }

    public Move(Type type, double d, double d2) {
        this(type, d, d2, 0, 1);
    }

    public Move(Type type, double d, double d2, int n, int n2) {
        this.type = type;
        this.accuracy = d2;
        this.power = d;
        this.priority = n;
        this.hits = n2;
    }

    protected abstract void attack(Pokemon var1, Pokemon var2);

    protected boolean checkAccuracy(Pokemon pokemon, Pokemon pokemon2) {
        return this.accuracy * pokemon.getStat(Stat.ACCURACY) / pokemon2.getStat(Stat.EVASION) > Math.random();
    }

    public final int getPriority() {
        return this.priority;
    }

    protected String describe() {
        return Messages.get("attack");
    }

    protected void applyOppEffects(Pokemon pokemon) {
    }

    protected void applySelfEffects(Pokemon pokemon) {
    }

    public static final Move getNoMove() {
        return noMove;
    }

    public static final Move getStruggleMove() {
        return struggleMove;
    }

    public static final Move getConfusionMove() {
        return confusionMove;
    }
}

