/*
 * Decompiled with CFR 0.152.
 */
package ru.ifmo.se.pokemon;

import java.util.LinkedList;
import java.util.List;
import ru.ifmo.se.pokemon.Effect;
import ru.ifmo.se.pokemon.Messages;
import ru.ifmo.se.pokemon.Move;
import ru.ifmo.se.pokemon.Stat;
import ru.ifmo.se.pokemon.Status;
import ru.ifmo.se.pokemon.Type;

public class Pokemon {
    private String name;
    private List<Type> types = new LinkedList<Type>();
    private List<Move> moves = new LinkedList<Move>();
    private Move preparedMove;
    private Effect stage = new Effect();
    private Effect condition = new Effect();
    private List<Effect> effects = new LinkedList<Effect>();
    private int confusion;
    private int level = 1;
    private double[] base = new double[Stat.values().length];

    public Pokemon(String string, int n) {
        this.types.add(Type.NONE);
        this.moves.add(Move.getStruggleMove());
        this.name = string;
        this.setLevel(n);
    }

    public Pokemon() {
        this(Messages.get("noname"), 1);
    }

    public final void setStats(double d, double d2, double d3, double d4, double d5, double d6) {
        this.base[Stat.HP.ordinal()] = d;
        this.base[Stat.ATTACK.ordinal()] = d2;
        this.base[Stat.DEFENSE.ordinal()] = d3;
        this.base[Stat.SPECIAL_ATTACK.ordinal()] = d4;
        this.base[Stat.SPECIAL_DEFENSE.ordinal()] = d5;
        this.base[Stat.SPEED.ordinal()] = d6;
    }

    public final void setLevel(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > 100) {
            n = 100;
        }
        this.level = n;
    }

    public final double getStat(Stat stat) {
        double d;
        double d2 = 15.0;
        double d3 = 0.0;
        double d4 = this.base[stat.ordinal()];
        double d5 = this.stage.stat(stat);
        d5 += this.condition.success() ? (double)this.condition.stat(stat) : 0.0;
        for (Effect effect : this.effects) {
            d5 += effect.success() ? (double)effect.stat(stat) : 0.0;
        }
        if (Math.abs(d5) > 6.0) {
            double d6 = d5 = d5 > 0.0 ? 6.0 : -6.0;
        }
        double d7 = stat.isHidden() ? 0.0 : (stat == Stat.HP ? (double)this.level + 10.0 : 5.0);
        double d8 = d = stat.isHidden() ? 3.0 : 2.0;
        d4 = stat.isHidden() ? d4 : ((d4 *= stat == Stat.HP ? 1.0 : (d5 > 0.0 ? (d + d5) / d : d / (d + d5))) * 2.0 + d2 + Math.sqrt(d3) / 4.0) * (double)this.level / 100.0;
        return d4 += d7;
    }

    public final boolean hasType(Type type) {
        for (Type type2 : this.types) {
            if (type2 != type) continue;
            return true;
        }
        return false;
    }

    public final void addEffect(Effect effect) {
        if (effect.condition() == Status.NORMAL) {
            this.effects.add(effect);
        } else {
            this.setCondition(effect);
        }
    }

    public final void setCondition(Effect effect) {
        if (effect.success() && this.condition.condition() != effect.condition()) {
            this.condition = effect;
            String string = "";
            switch (effect.condition()) {
                case BURN: {
                    string = Messages.get("burn");
                    break;
                }
                case FREEZE: {
                    string = Messages.get("freeze");
                    break;
                }
                case PARALYZE: {
                    string = Messages.get("paralyze");
                    break;
                }
                case POISON: {
                    string = Messages.get("poison");
                    break;
                }
                case SLEEP: {
                    string = Messages.get("sleep");
                }
            }
            System.out.println(this + " " + string);
        }
    }

    public final Status getCondition() {
        return this.condition.condition();
    }

    public final void confuse() {
        this.confusion = (int)(Math.random() * 4.0 + 1.0);
    }

    public final void restore() {
        this.base[Stat.ACCURACY.ordinal()] = 1.0;
        this.base[Stat.EVASION.ordinal()] = 1.0;
        this.condition.clear();
        this.stage.clear();
        this.effects.clear();
    }

    public final double getHP() {
        return this.getStat(Stat.HP) - (double)this.stage.stat(Stat.HP);
    }

    public final void setMod(Stat stat, int n) {
        if (n != 0) {
            int n2 = n + this.stage.stat(stat);
            String string = "";
            if (stat == Stat.HP) {
                string = Messages.get(n > 0 ? "minusHP" : "plusHP") + " " + Math.abs(n);
            } else {
                if (Math.abs(n2) > 6) {
                    n2 = n2 > 0 ? 6 : -6;
                }
                string = Messages.get(n < 0 ? "minusStat" : "plusStat");
            }
            this.stage.stat(stat, n2);
            System.out.println(this + " " + string + " " + Messages.get(stat.toString()) + ".");
        }
    }

    public final Type[] getTypes() {
        return this.types.toArray(new Type[0]);
    }

    public final int getLevel() {
        return this.level;
    }

    private double getAttackChance() {
        double d = this.stage.attack();
        d *= this.condition.attack();
        for (Effect effect : this.effects) {
            d *= effect.attack();
        }
        return d;
    }

    public final void prepareMove() {
        if (this.getAttackChance() > Math.random()) {
            if (this.moves.size() == 0) {
                this.preparedMove = Move.getStruggleMove();
            } else if (this.confusion > 0 && Math.random() < 0.33) {
                this.preparedMove = Move.getConfusionMove();
                --this.confusion;
            } else {
                this.preparedMove = this.moves.get((int)Math.floor(Math.random() * (double)this.moves.size()));
            }
        } else {
            this.preparedMove = Move.getNoMove();
        }
    }

    public final boolean isAlive() {
        return this.getStat(Stat.HP) > (double)this.stage.stat(Stat.HP);
    }

    public final boolean attack(Pokemon pokemon) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.preparedMove.attack(this, pokemon);
        if (this.isAlive() && pokemon.isAlive()) {
            System.out.println();
            return false;
        }
        if (!this.isAlive() && !pokemon.isAlive()) {
            System.out.println(Messages.get("bothFaint"));
        } else {
            System.out.println((this.isAlive() ? pokemon : this) + " " + Messages.get("faint"));
        }
        return true;
    }

    public final void turn() {
        this.setMod(Stat.HP, this.condition.stat(Stat.HP));
        if (this.condition.turn()) {
            this.condition.clear();
        }
        if (this.condition.condition() == Status.FREEZE && Math.random() < 0.2) {
            this.condition.clear();
            System.out.println(this + " " + Messages.get("thawn"));
        }
        for (Effect effect : this.effects) {
            this.setMod(Stat.HP, effect.stat(Stat.HP));
            if (!effect.turn()) continue;
            effect.clear();
        }
    }

    protected final void setType(Type ... typeArray) {
        this.types.clear();
        if (typeArray == null) {
            this.types.add(Type.NONE);
        } else {
            for (Type type : typeArray) {
                this.types.add(type);
                if (this.types.size() >= 2) break;
            }
        }
    }

    protected final void addType(Type type) {
        if (this.types.size() < 2 && !this.types.contains((Object)type)) {
            this.types.add(type);
        }
    }

    protected final void setMove(Move ... moveArray) {
        this.moves.clear();
        if (moveArray == null) {
            this.moves.add(Move.getStruggleMove());
        } else {
            for (Move move : moveArray) {
                this.moves.add(move);
                if (this.moves.size() >= 4) break;
            }
        }
    }

    protected final void addMove(Move move) {
        this.moves.add(move);
        while (this.moves.size() > 4) {
            this.moves.remove(0);
        }
    }

    protected final Move getPreparedMove() {
        return this.preparedMove;
    }

    public final String toString() {
        return (this.getClass().isAnonymousClass() ? Messages.get("poke") : this.getClass().getSimpleName()) + " " + this.name;
    }
}

